/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.rest.action.user;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.action.user.GetUsersResponse;
import org.elasticsearch.shield.client.ShieldClient;

public class RestGetUsersAction
extends BaseRestHandler {
    @Inject
    public RestGetUsersAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_shield/user/", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_shield/user/{username}", (RestHandler)this);
    }

    protected void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        final String[] usernames = request.paramAsStringArray("username", Strings.EMPTY_ARRAY);
        new ShieldClient((ElasticsearchClient)client).prepareGetUsers(usernames).execute((ActionListener)new RestBuilderListener<GetUsersResponse>(channel){

            public RestResponse buildResponse(GetUsersResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                for (User user : response.users()) {
                    builder.field(user.principal(), (ToXContent)user);
                }
                builder.endObject();
                if (usernames.length != 0 && response.users().length == 0) {
                    return new BytesRestResponse(RestStatus.NOT_FOUND, builder);
                }
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

