/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.ssl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;

public abstract class AbstractSSLService
extends AbstractComponent {
    public static final String CIPHERS_SETTING = "shield.ssl.ciphers";
    public static final String SUPPORTED_PROTOCOLS_SETTING = "shield.ssl.supported_protocols";
    public static final String[] DEFAULT_SUPPORTED_PROTOCOLS = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
    static final String[] DEFAULT_CIPHERS = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA"};
    static final TimeValue DEFAULT_SESSION_CACHE_TIMEOUT = TimeValue.timeValueHours((long)24L);
    static final int DEFAULT_SESSION_CACHE_SIZE = 1000;
    static final String DEFAULT_PROTOCOL = "TLSv1.2";
    protected final LoadingCache<SSLSettings, SSLContext> sslContexts = CacheBuilder.newBuilder().build((CacheLoader)new SSLContextCacheLoader());
    protected Environment env;

    public AbstractSSLService(Settings settings, Environment environment) {
        super(settings);
        this.env = environment;
    }

    public SSLSocketFactory sslSocketFactory() {
        SSLSocketFactory socketFactory = this.sslContext().getSocketFactory();
        return new ShieldSSLSocketFactory(socketFactory, this.supportedProtocols(), this.supportedCiphers(socketFactory.getSupportedCipherSuites(), this.ciphers()));
    }

    public String[] supportedProtocols() {
        return this.settings.getAsArray(SUPPORTED_PROTOCOLS_SETTING, DEFAULT_SUPPORTED_PROTOCOLS);
    }

    public String[] ciphers() {
        return this.settings.getAsArray(CIPHERS_SETTING, DEFAULT_CIPHERS);
    }

    public SSLEngine createSSLEngine() {
        return this.createSSLEngine(Settings.EMPTY);
    }

    public SSLEngine createSSLEngine(Settings settings) {
        return this.createSSLEngine(settings, null, -1);
    }

    public SSLEngine createSSLEngine(Settings settings, String host, int port) {
        String[] ciphers = settings.getAsArray(CIPHERS_SETTING, this.ciphers());
        String[] supportedProtocols = settings.getAsArray(SUPPORTED_PROTOCOLS_SETTING, this.supportedProtocols());
        return this.createSSLEngine(this.sslContext(settings), ciphers, supportedProtocols, host, port);
    }

    public SSLContext sslContext() {
        return this.sslContext(Settings.EMPTY);
    }

    protected SSLContext sslContext(Settings settings) {
        SSLSettings sslSettings = this.sslSettings(settings);
        try {
            return (SSLContext)this.sslContexts.getUnchecked((Object)sslSettings);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof ElasticsearchException) {
                throw (ElasticsearchException)e.getCause();
            }
            throw new ElasticsearchException("failed to load SSLContext", (Throwable)e, new Object[0]);
        }
    }

    public static String[] sensitiveSettings() {
        return new String[]{CIPHERS_SETTING, SUPPORTED_PROTOCOLS_SETTING, "protocol", "session.cache_size", "session.cache_timeout", "keystore.path", "keystore.password", "keystore.algorithm", "keystore.key_password", "truststore.path", "truststore.password", "truststore.algorithm"};
    }

    protected abstract SSLSettings sslSettings(Settings var1);

    SSLEngine createSSLEngine(SSLContext sslContext, String[] ciphers, String[] supportedProtocols, String host, int port) {
        SSLEngine sslEngine = sslContext.createSSLEngine(host, port);
        try {
            sslEngine.setEnabledCipherSuites(this.supportedCiphers(sslEngine.getSupportedCipherSuites(), ciphers));
        }
        catch (ElasticsearchException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("failed loading cipher suites [" + Arrays.asList(ciphers) + "]", t);
        }
        try {
            sslEngine.setEnabledProtocols(supportedProtocols);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("failed setting supported protocols [" + Arrays.asList(supportedProtocols) + "]", e);
        }
        return sslEngine;
    }

    String[] supportedCiphers(String[] supportedCiphers, String[] requestedCiphers) {
        ArrayList<String> requestedCiphersList = new ArrayList<String>(requestedCiphers.length);
        LinkedList<String> unsupportedCiphers = new LinkedList<String>();
        for (String requestedCipher : requestedCiphers) {
            boolean found = false;
            for (String supportedCipher : supportedCiphers) {
                if (!supportedCipher.equals(requestedCipher)) continue;
                found = true;
                requestedCiphersList.add(requestedCipher);
                break;
            }
            if (found) continue;
            unsupportedCiphers.add(requestedCipher);
        }
        if (requestedCiphersList.isEmpty()) {
            throw new IllegalArgumentException("none of the ciphers [" + Arrays.asList(requestedCiphers) + "] are supported by this JVM");
        }
        if (!unsupportedCiphers.isEmpty()) {
            this.logger.error("unsupported ciphers [{}] were requested but cannot be used in this JVM. If you are trying to use ciphers\nwith a key length greater than 128 bits on an Oracle JVM, you will need to install the unlimited strength\nJCE policy files. Additionally, please ensure the PKCS11 provider is enabled for your JVM.", new Object[]{unsupportedCiphers});
        }
        return requestedCiphersList.toArray(new String[requestedCiphersList.size()]);
    }

    protected Path resolvePath(String location) {
        return this.env.configFile().resolve(location);
    }

    static class ShieldSSLSocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;
        private final String[] supportedProtocols;
        private final String[] ciphers;

        ShieldSSLSocketFactory(SSLSocketFactory delegate, String[] supportedProtocols, String[] ciphers) {
            this.delegate = delegate;
            this.supportedProtocols = supportedProtocols;
            this.ciphers = ciphers;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.ciphers;
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket();
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(socket, host, port, autoClose);
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(host, port);
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(host, port, localHost, localPort);
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(host, port);
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(address, port, localAddress, localPort);
            this.configureSSLSocket(sslSocket);
            return sslSocket;
        }

        private void configureSSLSocket(SSLSocket socket) {
            socket.setEnabledProtocols(this.supportedProtocols);
            socket.setEnabledCipherSuites(this.ciphers);
        }
    }

    public static class SSLSettings {
        private static final ESLogger logger = Loggers.getLogger(SSLSettings.class);
        String keyStorePath;
        String keyStorePassword;
        String keyStoreAlgorithm;
        String keyPassword;
        String trustStorePath;
        String trustStorePassword;
        String trustStoreAlgorithm;
        String sslProtocol;
        int sessionCacheSize;
        TimeValue sessionCacheTimeout;

        SSLSettings(Settings settings, Settings sslServiceSettings) {
            this.keyStorePath = settings.get("keystore.path", sslServiceSettings.get("shield.ssl.keystore.path", System.getProperty("javax.net.ssl.keyStore")));
            this.keyStorePassword = settings.get("keystore.password", sslServiceSettings.get("shield.ssl.keystore.password", System.getProperty("javax.net.ssl.keyStorePassword")));
            this.keyStoreAlgorithm = settings.get("keystore.algorithm", sslServiceSettings.get("shield.ssl.keystore.algorithm", System.getProperty("ssl.KeyManagerFactory.algorithm", KeyManagerFactory.getDefaultAlgorithm())));
            this.keyPassword = settings.get("keystore.key_password", sslServiceSettings.get("shield.ssl.keystore.key_password", this.keyStorePassword));
            this.trustStorePath = settings.get("truststore.path", sslServiceSettings.get("shield.ssl.truststore.path", System.getProperty("javax.net.ssl.trustStore")));
            this.trustStorePassword = settings.get("truststore.password", sslServiceSettings.get("shield.ssl.truststore.password", System.getProperty("javax.net.ssl.trustStorePassword")));
            this.trustStoreAlgorithm = settings.get("truststore.algorithm", sslServiceSettings.get("shield.ssl.truststore.algorithm", System.getProperty("ssl.TrustManagerFactory.algorithm", TrustManagerFactory.getDefaultAlgorithm())));
            this.sslProtocol = settings.get("protocol", sslServiceSettings.get("shield.ssl.protocol", AbstractSSLService.DEFAULT_PROTOCOL));
            this.sessionCacheSize = settings.getAsInt("session.cache_size", sslServiceSettings.getAsInt("shield.ssl.session.cache_size", Integer.valueOf(1000)));
            this.sessionCacheTimeout = settings.getAsTime("session.cache_timeout", sslServiceSettings.getAsTime("shield.ssl.session.cache_timeout", DEFAULT_SESSION_CACHE_TIMEOUT));
            if (this.trustStorePath == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("no truststore defined. using keystore [{}] as truststore", new Object[]{this.keyStorePath});
                }
                this.trustStorePath = this.keyStorePath;
                this.trustStorePassword = this.keyStorePassword;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SSLSettings that = (SSLSettings)o;
            if (this.keyStorePath != null ? !this.keyStorePath.equals(that.keyStorePath) : that.keyStorePath != null) {
                return false;
            }
            if (this.sslProtocol != null ? !this.sslProtocol.equals(that.sslProtocol) : that.sslProtocol != null) {
                return false;
            }
            return !(this.trustStorePath != null ? !this.trustStorePath.equals(that.trustStorePath) : that.trustStorePath != null);
        }

        public int hashCode() {
            int result = this.keyStorePath != null ? this.keyStorePath.hashCode() : 0;
            result = 31 * result + (this.trustStorePath != null ? this.trustStorePath.hashCode() : 0);
            result = 31 * result + (this.sslProtocol != null ? this.sslProtocol.hashCode() : 0);
            return result;
        }
    }

    private class SSLContextCacheLoader
    extends CacheLoader<SSLSettings, SSLContext> {
        private SSLContextCacheLoader() {
        }

        public SSLContext load(SSLSettings sslSettings) throws Exception {
            if (AbstractSSLService.this.logger.isDebugEnabled()) {
                AbstractSSLService.this.logger.debug("using keystore[{}], key_algorithm[{}], truststore[{}], truststore_algorithm[{}], tls_protocol[{}], session_cache_size[{}], session_cache_timeout[{}]", new Object[]{sslSettings.keyStorePath, sslSettings.keyStoreAlgorithm, sslSettings.trustStorePath, sslSettings.trustStoreAlgorithm, sslSettings.sslProtocol, sslSettings.sessionCacheSize, sslSettings.sessionCacheTimeout});
            }
            TrustManager[] trustManagers = this.trustManagers(sslSettings.trustStorePath, sslSettings.trustStorePassword, sslSettings.trustStoreAlgorithm);
            KeyManager[] keyManagers = this.keyManagers(sslSettings.keyStorePath, sslSettings.keyStorePassword, sslSettings.keyStoreAlgorithm, sslSettings.keyPassword);
            return this.createSslContext(keyManagers, trustManagers, sslSettings.sslProtocol, sslSettings.sessionCacheSize, sslSettings.sessionCacheTimeout);
        }

        private KeyManager[] keyManagers(String keyStore, String keyStorePassword, String keyStoreAlgorithm, String keyPassword) {
            if (keyStore == null) {
                return null;
            }
            try {
                KeyStore ks = this.readKeystore(keyStore, keyStorePassword);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyStoreAlgorithm);
                kmf.init(ks, keyPassword.toCharArray());
                return kmf.getKeyManagers();
            }
            catch (Exception e) {
                throw new ElasticsearchException("failed to initialize a KeyManagerFactory", (Throwable)e, new Object[0]);
            }
        }

        private SSLContext createSslContext(KeyManager[] keyManagers, TrustManager[] trustManagers, String sslProtocol, int sessionCacheSize, TimeValue sessionCacheTimeout) {
            try {
                SSLContext sslContext = SSLContext.getInstance(sslProtocol);
                sslContext.init(keyManagers, trustManagers, null);
                sslContext.getServerSessionContext().setSessionCacheSize(sessionCacheSize);
                sslContext.getServerSessionContext().setSessionTimeout(Ints.checkedCast((long)sessionCacheTimeout.seconds()));
                return sslContext;
            }
            catch (Exception e) {
                throw new ElasticsearchException("failed to initialize the SSLContext", (Throwable)e, new Object[0]);
            }
        }

        private TrustManager[] trustManagers(String trustStorePath, String trustStorePassword, String trustStoreAlgorithm) {
            try {
                KeyStore ks = null;
                if (trustStorePath != null) {
                    ks = this.readKeystore(trustStorePath, trustStorePassword);
                }
                TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(trustStoreAlgorithm);
                trustFactory.init(ks);
                return trustFactory.getTrustManagers();
            }
            catch (Exception e) {
                throw new ElasticsearchException("failed to initialize a TrustManagerFactory", (Throwable)e, new Object[0]);
            }
        }

        private KeyStore readKeystore(String path, String password) throws Exception {
            try (InputStream in = Files.newInputStream(AbstractSSLService.this.resolvePath(path), new OpenOption[0]);){
                KeyStore ks = KeyStore.getInstance("jks");
                assert (password != null);
                ks.load(in, password.toCharArray());
                KeyStore keyStore = ks;
                return keyStore;
            }
        }
    }
}

