/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.ssl;

import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.shield.ShieldSettingsFilter;
import org.elasticsearch.shield.ssl.AbstractSSLService;

public class ServerSSLService
extends AbstractSSLService {
    @Inject
    public ServerSSLService(Settings settings, ShieldSettingsFilter settingsFilter, Environment environment) {
        super(settings, environment);
        settingsFilter.filterOut("shield.ssl.*");
    }

    @Override
    protected AbstractSSLService.SSLSettings sslSettings(Settings customSettings) {
        AbstractSSLService.SSLSettings sslSettings = new AbstractSSLService.SSLSettings(customSettings, this.settings);
        if (sslSettings.keyStorePath == null) {
            throw new IllegalArgumentException("no keystore configured");
        }
        if (sslSettings.keyStorePassword == null) {
            throw new IllegalArgumentException("no keystore password configured");
        }
        assert (sslSettings.trustStorePath != null);
        if (sslSettings.trustStorePassword == null) {
            throw new IllegalArgumentException("no truststore password configured");
        }
        return sslSettings;
    }
}

