/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.shield.support;

import java.io.IOException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.FilterClient;
import org.elasticsearch.common.ContextAndHeaderHolder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.shield.User;
import org.elasticsearch.shield.authc.AuthenticationService;

public class ClientWithUser
extends FilterClient {
    private final AuthenticationService authenticationService;
    private final User user;

    public ClientWithUser(Client in, AuthenticationService authenticationService, User user) {
        super(in);
        this.authenticationService = authenticationService;
        this.user = user;
    }

    protected <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void doExecute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        try {
            this.authenticationService.attachUserHeaderIfMissing((ContextAndHeaderHolder)request, this.user);
        }
        catch (IOException e) {
            this.logger.error("failed to attach authorization to internal message!", (Throwable)e, new Object[0]);
            throw new ElasticsearchSecurityException("unable to attach user to request", RestStatus.SERVICE_UNAVAILABLE, (Throwable)e, new Object[0]);
        }
        super.doExecute(action, request, listener);
    }
}

