/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.runtime.api.Framework;

public class BatchFileEntry {
    protected static final Log log = LogFactory.getLog(BatchFileEntry.class);
    protected String key;
    protected Map<String, Serializable> params;
    protected Blob blob;
    protected Blob chunkedBlob;

    public BatchFileEntry(String key, Blob blob) {
        this(key, false);
        this.blob = blob;
    }

    public BatchFileEntry(String key, int chunkCount, String fileName, String mimeType, long fileSize) {
        this(key, true);
        this.params.put("chunkCount", (Serializable)((Object)String.valueOf(chunkCount)));
        if (!StringUtils.isEmpty((String)fileName)) {
            this.params.put("fileName", (Serializable)((Object)fileName));
        }
        if (!StringUtils.isEmpty((String)mimeType)) {
            this.params.put("mimeType", (Serializable)((Object)mimeType));
        }
        this.params.put("fileSize", (Serializable)((Object)String.valueOf(fileSize)));
    }

    public BatchFileEntry(String key, Map<String, Serializable> params) {
        this.key = key;
        this.params = params;
    }

    protected BatchFileEntry(String key, boolean chunked) {
        this.key = key;
        this.params = new HashMap<String, Serializable>();
        this.params.put("chunked", (Serializable)((Object)String.valueOf(chunked)));
    }

    public String getKey() {
        return this.key;
    }

    public Map<String, Serializable> getParams() {
        return this.params;
    }

    public boolean isChunked() {
        return Boolean.parseBoolean((String)((Object)this.params.get("chunked")));
    }

    public String getFileName() {
        if (this.isChunked()) {
            return (String)((Object)this.params.get("fileName"));
        }
        Blob blob = this.getBlob();
        if (blob == null) {
            return null;
        }
        return blob.getFilename();
    }

    public String getMimeType() {
        if (this.isChunked()) {
            return (String)((Object)this.params.get("mimeType"));
        }
        Blob blob = this.getBlob();
        if (blob == null) {
            return null;
        }
        return blob.getMimeType();
    }

    public long getFileSize() {
        if (this.isChunked()) {
            return Long.parseLong((String)((Object)this.params.get("fileSize")));
        }
        Blob blob = this.getBlob();
        if (blob == null) {
            return -1L;
        }
        return blob.getLength();
    }

    public int getChunkCount() {
        if (!this.isChunked()) {
            throw new NuxeoException(String.format("Cannot get chunk count of file entry %s as it is not chunked", this.key));
        }
        return Integer.parseInt((String)((Object)this.params.get("chunkCount")));
    }

    public Map<Integer, String> getChunks() {
        if (!this.isChunked()) {
            throw new NuxeoException(String.format("Cannot get chunks of file entry %s as it is not chunked", this.key));
        }
        HashMap<Integer, String> chunks = new HashMap<Integer, String>();
        for (String param : this.params.keySet()) {
            if (!NumberUtils.isDigits((String)param)) continue;
            chunks.put(Integer.parseInt(param), (String)((Object)this.params.get(param)));
        }
        return chunks;
    }

    public List<Integer> getOrderedChunkIndexes() {
        if (!this.isChunked()) {
            throw new NuxeoException(String.format("Cannot get chunk indexes of file entry %s as it is not chunked", this.key));
        }
        ArrayList<Integer> sortedChunkIndexes = new ArrayList<Integer>(this.getChunks().keySet());
        Collections.sort(sortedChunkIndexes);
        return sortedChunkIndexes;
    }

    public Collection<String> getChunkEntryKeys() {
        if (!this.isChunked()) {
            throw new NuxeoException(String.format("Cannot get chunk entry keys of file entry %s as it is not chunked", this.key));
        }
        return this.getChunks().values();
    }

    public boolean isChunksCompleted() {
        return this.getChunks().size() == this.getChunkCount();
    }

    public Blob getBlob() {
        if (this.isChunked()) {
            if (this.chunkedBlob != null) {
                return this.chunkedBlob;
            }
            File tmpChunkedFile = null;
            try {
                Map<Integer, String> chunks = this.getChunks();
                int uploadedChunkCount = chunks.size();
                int chunkCount = this.getChunkCount();
                if (uploadedChunkCount != chunkCount) {
                    log.warn((Object)String.format("Cannot get blob for file entry %s as there are only %d uploaded chunks out of %d.", this.key, uploadedChunkCount, chunkCount));
                    return null;
                }
                this.chunkedBlob = Blobs.createBlobWithExtension(null);
                tmpChunkedFile = this.chunkedBlob.getFile();
                BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
                TransientStore ts = bm.getTransientStore();
                List<Integer> sortedChunkIndexes = this.getOrderedChunkIndexes();
                for (int index : sortedChunkIndexes) {
                    Blob chunk = this.getChunk(ts, chunks.get(index));
                    if (chunk == null) continue;
                    this.transferTo(chunk, tmpChunkedFile);
                }
                ts.putParameter(this.key, "tmpChunkedFilePath", (Serializable)((Object)tmpChunkedFile.getAbsolutePath()));
                this.chunkedBlob.setMimeType(this.getMimeType());
                this.chunkedBlob.setFilename(this.getFileName());
                return this.chunkedBlob;
            }
            catch (IOException ioe) {
                if (tmpChunkedFile != null && tmpChunkedFile.exists()) {
                    tmpChunkedFile.delete();
                }
                this.chunkedBlob = null;
                throw new NuxeoException((Throwable)ioe);
            }
        }
        return this.blob;
    }

    protected Blob getChunk(TransientStore ts, String key) {
        List blobs = ts.getBlobs(key);
        if (CollectionUtils.isEmpty((Collection)blobs)) {
            return null;
        }
        return (Blob)blobs.get(0);
    }

    protected void transferTo(Blob blob, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file, true);
             InputStream in = blob.getStream();){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    public String addChunk(int index, Blob blob) {
        if (!this.isChunked()) {
            throw new NuxeoException("Cannot add a chunk to a non chunked file entry.");
        }
        int chunkCount = this.getChunkCount();
        if (index < 0) {
            throw new NuxeoException(String.format("Cannot add chunk with negative index %d.", index));
        }
        if (index >= chunkCount) {
            throw new NuxeoException(String.format("Cannot add chunk with index %d to file entry %s as chunk count is %d.", index, this.key, chunkCount));
        }
        if (this.getChunks().containsKey(index)) {
            throw new NuxeoException(String.format("Cannot add chunk with index %d to file entry %s as it already exists.", index, this.key));
        }
        String chunkEntryKey = this.key + "_" + index;
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        TransientStore ts = bm.getTransientStore();
        ts.putBlobs(chunkEntryKey, Collections.singletonList(blob));
        ts.putParameter(this.key, String.valueOf(index), (Serializable)((Object)chunkEntryKey));
        return chunkEntryKey;
    }

    public void beforeRemove() {
        File tmpChunkedFile;
        BatchManager bm = (BatchManager)Framework.getService(BatchManager.class);
        String tmpChunkedFilePath = (String)((Object)bm.getTransientStore().getParameter(this.key, "tmpChunkedFilePath"));
        if (tmpChunkedFilePath != null && (tmpChunkedFile = new File(tmpChunkedFilePath)).exists()) {
            log.debug((Object)String.format("Deleting temporary chunked file %s", tmpChunkedFilePath));
            tmpChunkedFile.delete();
        }
    }
}

