/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public final class CacheRegistry
extends ContributionFragmentRegistry<CacheDescriptor> {
    private static final Log log = LogFactory.getLog(CacheRegistry.class);
    protected final Map<String, CacheDescriptor> caches = new HashMap<String, CacheDescriptor>();
    protected boolean started;

    public String getContributionId(CacheDescriptor contrib) {
        return contrib.name;
    }

    public void contributionUpdated(String id, CacheDescriptor descriptor, CacheDescriptor newOrigContrib) {
        String name = descriptor.name;
        if (name == null) {
            throw new RuntimeException("The cache name must not be null!");
        }
        if (descriptor.remove) {
            this.contributionRemoved(id, descriptor);
            return;
        }
        if (this.caches.containsKey(name)) {
            log.warn((Object)String.format("Another cache has already been registered for the given name %s", name));
            return;
        }
        this.caches.put(name, descriptor);
        log.info((Object)("cache registered: " + name));
        if (this.started) {
            descriptor.start();
        }
    }

    public boolean isSupportingMerge() {
        return false;
    }

    public void contributionRemoved(String id, CacheDescriptor origContrib) {
        String name = origContrib.name;
        CacheDescriptor cache = this.caches.remove(name);
        if (cache == null) {
            log.warn((Object)("No such cache registered" + name));
            return;
        }
        try {
            cache.stop();
        }
        catch (RuntimeException e) {
            log.error((Object)String.format("Error while removing cache '%s'", name), (Throwable)e);
        }
        log.info((Object)("cache removed: " + name));
    }

    public CacheDescriptor clone(CacheDescriptor orig) {
        return orig.clone();
    }

    public void merge(CacheDescriptor src, CacheDescriptor dst) {
        boolean remove = src.remove;
        if (remove) {
            dst.remove = remove;
            return;
        }
    }

    public Cache getCache(String name) {
        if (this.caches.containsKey(name)) {
            return this.caches.get((Object)name).cache;
        }
        return null;
    }

    public List<Cache> getCaches() {
        ArrayList<Cache> res = new ArrayList<Cache>(this.caches.size());
        for (CacheDescriptor desc : this.caches.values()) {
            res.add(desc.cache);
        }
        return res;
    }

    public void invalidateAll() {
        this.caches.values().forEach(CacheDescriptor::invalidateAll);
    }

    public void start() {
        RuntimeException errors = new RuntimeException("Cannot start caches, check suppressed error");
        for (CacheDescriptor desc : this.caches.values()) {
            try {
                desc.start();
            }
            catch (RuntimeException cause) {
                errors.addSuppressed(cause);
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
        this.started = true;
    }

    public void stop() {
        RuntimeException errors = new RuntimeException("Cannot stop caches, check suppressed error");
        for (CacheDescriptor desc : this.caches.values()) {
            try {
                desc.stop();
            }
            catch (RuntimeException cause) {
                errors.addSuppressed(cause);
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
        this.started = false;
    }
}

