/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.core.cache.CacheServiceImpl;
import org.nuxeo.ecm.core.cache.InMemoryCacheImpl;
import org.nuxeo.ecm.core.transientstore.AbstractTransientStore;
import org.nuxeo.ecm.core.transientstore.StorageEntry;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreConfig;
import org.nuxeo.runtime.api.Framework;

public class SimpleTransientStore
extends AbstractTransientStore {
    protected Log log = LogFactory.getLog(SimpleTransientStore.class);
    protected Cache l1Cache;
    protected Cache l2Cache;
    protected CacheDescriptor l1cd;
    protected CacheDescriptor l2cd;
    protected AtomicLong storageSize = new AtomicLong(0L);

    @Override
    public void init(TransientStoreConfig config) {
        this.log.debug((Object)("Initializing SimpleTransientStore: " + config.getName()));
        super.init(config);
        CacheService cs = (CacheService)Framework.getService(CacheService.class);
        if (cs == null) {
            throw new UnsupportedOperationException("Cache service is required");
        }
        this.l1cd = this.getL1CacheConfig();
        this.l2cd = this.getL2CacheConfig();
        ((CacheServiceImpl)cs).registerCache(this.l1cd);
        ((CacheServiceImpl)cs).registerCache(this.l2cd);
        this.l1Cache = cs.getCache(this.l1cd.name);
        this.l2Cache = cs.getCache(this.l2cd.name);
    }

    @Override
    public void shutdown() {
        this.log.debug((Object)("Shutting down SimpleTransientStore: " + this.config.getName()));
        CacheService cs = (CacheService)Framework.getService(CacheService.class);
        if (cs != null) {
            if (this.l1cd != null) {
                ((CacheServiceImpl)cs).unregisterCache(this.l1cd);
            }
            if (this.l2cd != null) {
                ((CacheServiceImpl)cs).unregisterCache(this.l2cd);
            }
        }
    }

    @Override
    public boolean exists(String key) {
        return this.getL1Cache().hasEntry(key) || this.getL2Cache().hasEntry(key);
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.getL1Cache().keySet());
        keys.addAll(this.getL2Cache().keySet());
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putParameter(String key, String parameter, Serializable value) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            StorageEntry entry = this.getStorageEntry(key);
            if (entry == null) {
                entry = new StorageEntry();
            }
            entry.putParam(parameter, value);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting parameter %s to value %s in StorageEntry stored at key %s", parameter, value, key));
            }
            this.putStorageEntry(key, entry);
        }
    }

    @Override
    public Serializable getParameter(String key, String parameter) {
        StorageEntry entry = this.getStorageEntry(key);
        if (entry == null) {
            return null;
        }
        Serializable res = entry.getParam(parameter);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Fetched parameter %s from StorageEntry stored at key %s: %s", parameter, key, res));
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putParameters(String key, Map<String, Serializable> parameters) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            StorageEntry entry = this.getStorageEntry(key);
            if (entry == null) {
                entry = new StorageEntry();
            }
            entry.putParams(parameters);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting parameters %s in StorageEntry stored at key %s", parameters, key));
            }
            this.putStorageEntry(key, entry);
        }
    }

    @Override
    public Map<String, Serializable> getParameters(String key) {
        StorageEntry entry = this.getStorageEntry(key);
        if (entry == null) {
            return null;
        }
        Map<String, Serializable> res = entry.getParams();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Fetched parameters from StorageEntry stored at key %s: %s", key, res));
        }
        return res;
    }

    @Override
    public List<Blob> getBlobs(String key) {
        StorageEntry entry = this.getStorageEntry(key);
        if (entry == null) {
            return null;
        }
        List<Map<String, String>> blobInfos = entry.getBlobInfos();
        if (blobInfos == null) {
            return new ArrayList<Blob>();
        }
        return this.loadBlobs(blobInfos);
    }

    @Override
    public long getSize(String key) {
        StorageEntry entry = this.getStorageEntry(key);
        if (entry == null) {
            return -1L;
        }
        long size = entry.getSize();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Fetched field \"size\" from StorageEntry stored at key %s: %d", key, size));
        }
        return size;
    }

    @Override
    public boolean isCompleted(String key) {
        boolean completed;
        StorageEntry entry = this.getStorageEntry(key);
        boolean bl = completed = entry != null && entry.isCompleted();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Fetched field \"completed\" from StorageEntry stored at key %s: %s", key, completed));
        }
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCompleted(String key, boolean completed) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            StorageEntry entry = this.getStorageEntry(key);
            if (entry == null) {
                entry = new StorageEntry();
            }
            entry.setCompleted(completed);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting field \"completed\" to value %s in StorageEntry stored at key %s", completed, key));
            }
            this.putStorageEntry(key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String key) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            long entrySize;
            StorageEntry entry = (StorageEntry)this.getL1Cache().get(key);
            if (entry == null) {
                entry = (StorageEntry)this.getL2Cache().get(key);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Invalidating StorageEntry stored at key %s form L2 cache", key));
                }
                this.getL2Cache().invalidate(key);
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Invalidating StorageEntry stored at key %s form L1 cache", key));
                }
                this.getL1Cache().invalidate(key);
            }
            if (entry != null && (entrySize = entry.getSize()) > 0L) {
                this.decrementStorageSize(entrySize);
            }
            FileUtils.deleteQuietly((File)this.getCachingDirectory(key));
        }
    }

    @Override
    public void release(String key) {
        StorageEntry entry = (StorageEntry)this.getL1Cache().get(key);
        if (entry != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Invalidating StorageEntry stored at key %s form L1 cache", key));
            }
            this.getL1Cache().invalidate(key);
            if (this.getStorageSize() <= (long)(this.config.getTargetMaxSizeMB() * 0x100000) || this.config.getTargetMaxSizeMB() < 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Putting StorageEntry at key %s in L2 cache", key));
                }
                this.getL2Cache().put(key, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void persistBlobs(String key, long sizeOfBlobs, List<Map<String, String>> blobInfos) {
        SimpleTransientStore simpleTransientStore = this;
        synchronized (simpleTransientStore) {
            StorageEntry entry = this.getStorageEntry(key);
            if (entry == null) {
                if (sizeOfBlobs > 0L) {
                    this.incrementStorageSize(sizeOfBlobs);
                }
                entry = new StorageEntry();
            } else {
                this.incrementStorageSize(sizeOfBlobs - entry.getSize());
            }
            entry.setSize(sizeOfBlobs);
            entry.setBlobInfos(blobInfos);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting blobs %s in StorageEntry stored at key %s", blobInfos, key));
            }
            this.putStorageEntry(key, entry);
        }
    }

    @Override
    public long getStorageSize() {
        int intStorageSize = (int)this.storageSize.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Fetched storage size of store %s: %d", this.config.getName(), intStorageSize));
        }
        return intStorageSize;
    }

    @Override
    protected void setStorageSize(long newSize) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Setting storage size of store %s to %d", this.config.getName(), newSize));
        }
        this.storageSize.set(newSize);
    }

    @Override
    protected long incrementStorageSize(long size) {
        long incremented = this.storageSize.addAndGet(size);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Incremented storage size of store %s to %s", this.config.getName(), incremented));
        }
        return incremented;
    }

    @Override
    protected long decrementStorageSize(long size) {
        long decremented = this.storageSize.addAndGet(-size);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Decremented storage size of store %s to %s", this.config.getName(), decremented));
        }
        return decremented;
    }

    @Override
    protected void removeAllEntries() {
        this.log.debug((Object)"Invalidating all entries from L1 and L2 caches");
        this.getL1Cache().invalidateAll();
        this.getL2Cache().invalidateAll();
    }

    public Cache getL1Cache() {
        return this.l1Cache;
    }

    public Cache getL2Cache() {
        return this.l2Cache;
    }

    protected CacheDescriptor getL1CacheConfig() {
        return new TransientCacheConfig(this.config.getName() + "L1", this.config.getFirstLevelTTL());
    }

    protected CacheDescriptor getL2CacheConfig() {
        return new TransientCacheConfig(this.config.getName() + "L2", this.config.getSecondLevelTTL());
    }

    protected Class<? extends Cache> getCacheImplClass() {
        return InMemoryCacheImpl.class;
    }

    protected StorageEntry getStorageEntry(String key) {
        StorageEntry entry = (StorageEntry)this.getL1Cache().get(key);
        if (entry == null) {
            entry = (StorageEntry)this.getL2Cache().get(key);
        }
        return entry;
    }

    protected void putStorageEntry(String key, StorageEntry entry) {
        this.getL1Cache().put(key, entry);
    }

    protected class TransientCacheConfig
    extends CacheDescriptor {
        TransientCacheConfig(String name, int ttl) {
            this.name = name;
            this.implClass = SimpleTransientStore.this.getCacheImplClass();
            this.ttl = ttl;
        }
    }
}

