/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreConfig;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class TransientStorageComponent
extends DefaultComponent
implements TransientStoreService {
    protected Map<String, TransientStoreConfig> configs = new HashMap<String, TransientStoreConfig>();
    protected Map<String, TransientStore> stores = new HashMap<String, TransientStore>();
    public static final String EP_STORE = "store";
    public static final String DEFAULT_STORE_NAME = "default";

    @Override
    public TransientStore getStore(String name) {
        TransientStore store = this.stores.get(name);
        if (store == null && (store = this.stores.get(DEFAULT_STORE_NAME)) == null) {
            store = this.registerDefaultStore();
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransientStore registerDefaultStore() {
        TransientStorageComponent transientStorageComponent = this;
        synchronized (transientStorageComponent) {
            TransientStore defaultStore = this.stores.get(DEFAULT_STORE_NAME);
            if (defaultStore == null) {
                TransientStoreConfig defaultConfig = new TransientStoreConfig(DEFAULT_STORE_NAME);
                defaultStore = defaultConfig.getStore();
                this.stores.put(defaultConfig.getName(), defaultStore);
            }
            return defaultStore;
        }
    }

    @Override
    public void doGC() {
        this.stores.values().forEach(TransientStore::doGC);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_STORE.equals(extensionPoint)) {
            TransientStoreConfig config = (TransientStoreConfig)contribution;
            this.configs.put(config.getName(), config);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_STORE.equals(extensionPoint)) {
            TransientStoreConfig config = (TransientStoreConfig)contribution;
            TransientStore store = this.stores.get(config.getName());
            store.shutdown();
        }
    }

    public void start(ComponentContext context) {
        for (TransientStoreConfig config : this.configs.values()) {
            this.registerStore(config);
        }
    }

    protected TransientStore registerStore(TransientStoreConfig config) {
        TransientStore store = config.getStore();
        this.stores.put(config.getName(), store);
        return store;
    }

    public void deactivate(ComponentContext context) {
        this.stores.values().forEach(TransientStore::shutdown);
        this.stores.clear();
        this.configs.values().forEach(TransientStoreConfig::flush);
        super.deactivate(context);
    }

    public void cleanUpStores() {
        this.stores.values().forEach(TransientStore::removeAll);
    }
}

