/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.runtime.api.Framework;

public class DirectoryCSVLoader {
    private static final Log log = LogFactory.getLog(DirectoryCSVLoader.class);
    public static final String CSV_NULL_MARKER = "__NULL__";

    private DirectoryCSVLoader() {
    }

    public static void loadData(String dataFileName, char delimiter, Schema schema, Consumer<Map<String, Object>> loader) throws DirectoryException {
        try (InputStream in = DirectoryCSVLoader.getResource(dataFileName);
             CSVParser csvParser = new CSVParser((Reader)new InputStreamReader(in, "UTF-8"), CSVFormat.DEFAULT.withDelimiter(delimiter).withHeader(new String[0]));){
            Map header = csvParser.getHeaderMap();
            ArrayList<Field> fields = new ArrayList<Field>();
            for (String columnName : header.keySet()) {
                Field field = schema.getField(columnName.trim());
                if (field == null) {
                    throw new DirectoryException("Column not found: " + columnName + " in schema: " + schema.getName());
                }
                fields.add(field);
            }
            int lineno = 1;
            for (CSVRecord record : csvParser) {
                ++lineno;
                if (record.size() == 0 || record.size() == 1 && StringUtils.isBlank((String)record.get(0))) continue;
                if (!record.isConsistent()) {
                    log.error((Object)("Invalid column count while reading CSV file: " + dataFileName + ", line: " + lineno + ", values: " + record));
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 0; i < header.size(); ++i) {
                    Field field = (Field)fields.get(i);
                    String value = record.get(i);
                    Object v = CSV_NULL_MARKER.equals(value) ? null : DirectoryCSVLoader.decode(field, value);
                    map.put(field.getName().getPrefixedName(), v);
                }
                loader.accept(map);
            }
        }
        catch (IOException e) {
            throw new DirectoryException("Read error while reading data file: " + dataFileName, (Throwable)e);
        }
    }

    protected static Object decode(Field field, String value) {
        Type type = field.getType();
        if (type instanceof DateType) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(Timestamp.valueOf(value));
            return cal;
        }
        return type.decode(value);
    }

    protected static InputStream getResource(String name) {
        InputStream in = DirectoryCSVLoader.class.getClassLoader().getResourceAsStream(name);
        if (in == null && (in = Framework.getResourceLoader().getResourceAsStream(name)) == null) {
            throw new DirectoryException("Data file not found: " + name);
        }
        return in;
    }
}

