/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.core;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Collections2;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.PasswordHelper;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.core.CoreDirectory;
import org.nuxeo.ecm.directory.core.CoreDirectoryDescriptor;

public class CoreDirectorySession
extends BaseSession {
    protected final String schemaIdField;
    protected final String schemaPasswordField;
    protected final CoreSession coreSession;
    protected final String createPath;
    protected final String docType;
    protected static final String UUID_FIELD = "ecm:uuid";
    private static final Log log = LogFactory.getLog(CoreDirectorySession.class);

    public CoreDirectorySession(CoreDirectory directory) {
        super((Directory)directory, null);
        CoreDirectoryDescriptor descriptor = directory.getDescriptor();
        this.coreSession = CoreInstance.openCoreSession((String)descriptor.getRepositoryName());
        this.schemaIdField = directory.getFieldMapper().getBackendField(this.getIdField());
        this.schemaPasswordField = directory.getFieldMapper().getBackendField(this.getPasswordField());
        this.docType = descriptor.docType;
        this.createPath = descriptor.getCreatePath();
    }

    public CoreDirectory getDirectory() {
        return (CoreDirectory)this.directory;
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        if (UUID_FIELD.equals(this.getIdField())) {
            IdRef ref = new IdRef(id);
            if (this.coreSession.exists((DocumentRef)ref)) {
                DocumentModel document = this.coreSession.getDocument((DocumentRef)new IdRef(id));
                return this.docType.equals(document.getType()) ? document : null;
            }
            return null;
        }
        StringBuilder sbQuery = new StringBuilder("SELECT * FROM ");
        sbQuery.append(this.docType);
        sbQuery.append(" WHERE ");
        sbQuery.append(this.getDirectory().getField(this.schemaIdField).getName().getPrefixedName());
        sbQuery.append(" = '");
        sbQuery.append(id);
        sbQuery.append("' AND ecm:path STARTSWITH '");
        sbQuery.append(this.createPath);
        sbQuery.append("'");
        DocumentModelList listDoc = this.coreSession.query(sbQuery.toString());
        if (!listDoc.isEmpty()) {
            if (listDoc.size() > 1) {
                log.warn((Object)String.format("Found more than one result in getEntry, the first result only will be returned", new Object[0]));
            }
            DocumentModel docResult = (DocumentModel)listDoc.get(0);
            if (this.isReadOnly()) {
                BaseSession.setReadOnlyEntry((DocumentModel)docResult);
            }
            return docResult;
        }
        return null;
    }

    public DocumentModelList getEntries() throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    private String getPrefixedFieldName(String fieldName) {
        if (UUID_FIELD.equals(fieldName)) {
            return fieldName;
        }
        Field schemaField = this.getDirectory().getField(fieldName);
        return schemaField.getName().getPrefixedName();
    }

    public DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    protected void deleteEntryWithoutReferences(String id) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) throws DirectoryException {
        if (this.isReadOnly()) {
            log.warn((Object)String.format("The directory '%s' is in read-only mode, could not create entry.", this.directory.getName()));
            return null;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        LinkedList<String> createdRefs = new LinkedList<String>();
        for (String fieldId : fieldMap.keySet()) {
            if (this.getDirectory().isReference(fieldId)) {
                createdRefs.add(fieldId);
            }
            Object value = fieldMap.get(fieldId);
            properties.put(this.getMappedPrefixedFieldName(fieldId), value);
        }
        String rawid = (String)properties.get(this.getPrefixedFieldName(this.schemaIdField));
        if (rawid == null && !UUID_FIELD.equals(this.getIdField())) {
            throw new DirectoryException(String.format("Entry is missing id field '%s'", this.schemaIdField));
        }
        DocumentModel docModel = this.coreSession.createDocumentModel(this.createPath, rawid, this.docType);
        docModel.setProperties(this.schemaName, properties);
        DocumentModel createdDoc = this.coreSession.createDocument(docModel);
        for (String referenceFieldName : createdRefs) {
            Reference reference = this.directory.getReference(referenceFieldName);
            List targetIds = (List)createdDoc.getProperty(this.schemaName, referenceFieldName);
            reference.setTargetIdsForSource(docModel.getId(), targetIds);
        }
        return docModel;
    }

    public void updateEntry(DocumentModel docModel) throws DirectoryException {
        if (this.isReadOnly()) {
            log.warn((Object)String.format("The directory '%s' is in read-only mode, could not update entry.", this.directory.getName()));
        } else if (!CoreDirectorySession.isReadOnlyEntry((DocumentModel)docModel)) {
            String id = (String)docModel.getProperty(this.schemaName, this.getIdField());
            if (id == null) {
                throw new DirectoryException("Can not update entry with a null id for document ref " + docModel.getRef());
            }
            if (this.getEntry(id) == null) {
                throw new DirectoryException(String.format("Update entry failed : Entry with id '%s' not found !", id));
            }
            DataModel dataModel = docModel.getDataModel(this.schemaName);
            HashMap updatedProps = new HashMap();
            LinkedList<String> updatedRefs = new LinkedList<String>();
            for (String field : docModel.getProperties(this.schemaName).keySet()) {
                String schemaField = this.getMappedPrefixedFieldName(field);
                if (dataModel.isDirty(schemaField)) continue;
                if (this.getDirectory().isReference(field)) {
                    updatedRefs.add(field);
                    continue;
                }
                updatedProps.put(schemaField, docModel.getProperties(this.schemaName).get(field));
            }
            docModel.setProperties(this.schemaName, updatedProps);
            for (String referenceFieldName : updatedRefs) {
                Reference reference = this.directory.getReference(referenceFieldName);
                List targetIds = (List)docModel.getProperty(this.schemaName, referenceFieldName);
                reference.setTargetIdsForSource(docModel.getId(), targetIds);
            }
            this.coreSession.saveDocument(docModel);
        }
    }

    public void deleteEntry(DocumentModel docModel) throws DirectoryException {
        String id = (String)docModel.getProperty(this.schemaName, this.schemaIdField);
        this.deleteEntry(id);
    }

    public void deleteEntry(String id) throws DirectoryException {
        if (this.isReadOnly()) {
            log.warn((Object)String.format("The directory '%s' is in read-only mode, could not delete entry.", this.directory.getName()));
        } else {
            if (id == null) {
                throw new DirectoryException("Can not update entry with a null id ");
            }
            this.checkDeleteConstraints(id);
            DocumentModel docModel = this.getEntry(id);
            if (docModel != null) {
                this.coreSession.removeDocument(docModel.getRef());
            }
        }
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        if (this.isReadOnly()) {
            log.warn((Object)String.format("The directory '%s' is in read-only mode, could not delete entry.", this.directory.getName()));
        }
        HashMap<String, String> props = new HashMap<String, String>(map);
        props.put(this.schemaIdField, id);
        DocumentModelList docList = this.query(props);
        if (!docList.isEmpty()) {
            if (docList.size() > 1) {
                log.warn((Object)String.format("Found more than one result in getEntry, the first result only will be deleted", new Object[0]));
            }
        } else {
            throw new DirectoryException(String.format("Delete entry failed : Entry with id '%s' not found !", id));
        }
        this.deleteEntry((DocumentModel)docList.get(0));
    }

    protected String getMappedPrefixedFieldName(String fieldName) {
        String backendFieldId = this.getDirectory().getFieldMapper().getBackendField(fieldName);
        return this.getPrefixedFieldName(backendFieldId);
    }

    public DocumentModelList query(final Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws DirectoryException {
        StringBuilder sbQuery = new StringBuilder("SELECT * FROM ");
        sbQuery.append(this.docType);
        if (!filter.isEmpty() || !fulltext.isEmpty() || this.createPath != null && !this.createPath.isEmpty()) {
            sbQuery.append(" WHERE ");
        }
        int i = 1;
        boolean hasFilter = false;
        for (String filterKey : filter.keySet()) {
            if (fulltext.contains(filterKey)) continue;
            sbQuery.append(this.getMappedPrefixedFieldName(filterKey));
            sbQuery.append(" = ");
            sbQuery.append("'");
            sbQuery.append(filter.get(filterKey));
            sbQuery.append("'");
            if (i < filter.size()) {
                sbQuery.append(" AND ");
                ++i;
            }
            hasFilter = true;
        }
        if (hasFilter && filter.size() > 0 && fulltext.size() > 0) {
            sbQuery.append(" AND ");
        }
        if (fulltext.size() > 0) {
            Collection fullTextValues = Collections2.transform(fulltext, (Function)new Function<String, String>(){

                public String apply(String key) {
                    return (String)filter.get(key);
                }
            });
            sbQuery.append("ecm:fulltext");
            sbQuery.append(" = ");
            sbQuery.append("'");
            sbQuery.append(Joiner.on((String)" ").join((Iterable)fullTextValues));
            sbQuery.append("'");
        }
        if (this.createPath != null && !this.createPath.isEmpty()) {
            if (filter.size() > 0 || fulltext.size() > 0) {
                sbQuery.append(" AND ");
            }
            sbQuery.append(" ecm:path STARTSWITH '");
            sbQuery.append(this.createPath);
            sbQuery.append("'");
        }
        DocumentModelList resultsDoc = this.coreSession.query(sbQuery.toString(), null, (long)limit, (long)offset, false);
        if (this.isReadOnly()) {
            for (DocumentModel documentModel : resultsDoc) {
                BaseSession.setReadOnlyEntry((DocumentModel)documentModel);
            }
        }
        return resultsDoc;
    }

    public void close() throws DirectoryException {
        this.coreSession.close();
        this.getDirectory().removeSession((Session)this);
    }

    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public boolean authenticate(String username, String password) {
        DocumentModel entry = this.getEntry(username);
        if (entry == null) {
            return false;
        }
        String storedPassword = (String)entry.getProperty(this.schemaName, this.schemaPasswordField);
        return PasswordHelper.verifyPassword(password, storedPassword);
    }

    public boolean isAuthenticating() {
        return this.schemaPasswordField != null;
    }

    public boolean hasEntry(String id) {
        return this.getEntry(id) != null;
    }
}

