/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert;

import java.io.Serializable;
import java.util.Map;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class ConvertHelper {
    protected String findConverter(Blob blob, String destMimeType) {
        MimetypeRegistry mtr = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
        String srcMt = mtr.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, blob.getMimeType());
        blob.setMimeType(srcMt);
        ConversionService cs = (ConversionService)Framework.getLocalService(ConversionService.class);
        return cs.getConverterName(srcMt, destMimeType);
    }

    protected Blob applyConverter(Blob blob, String converter, String destMimeType, Map<String, Serializable> params) {
        ConversionService cs = (ConversionService)Framework.getLocalService(ConversionService.class);
        BlobHolder bh = cs.convert(converter, (BlobHolder)new SimpleBlobHolder(blob), params);
        if (bh == null || bh.getBlob() == null) {
            return blob;
        }
        Blob result = bh.getBlob();
        MimetypeRegistry mtr = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
        String filename = FileUtils.getFileNameNoExt((String)blob.getFilename());
        filename = filename + "." + (String)mtr.getExtensionsFromMimetypeName(destMimeType).get(0);
        result.setFilename(filename);
        return result;
    }

    public Blob convertBlob(Blob blob, String mimeType) {
        String converter = this.findConverter(blob, mimeType);
        if (converter != null) {
            return this.applyConverter(blob, converter, mimeType, null);
        }
        return blob;
    }

    public Blob convertBlob(Blob blob, String mimeType, Map<String, Serializable> params) {
        String converter = this.findConverter(blob, mimeType);
        if (converter != null) {
            return this.applyConverter(blob, converter, mimeType, params);
        }
        return blob;
    }
}

