/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.service.extension.CreationContainerListProvider;
import org.nuxeo.ecm.platform.filemanager.service.extension.CreationContainerListProviderDescriptor;
import org.nuxeo.ecm.platform.filemanager.service.extension.FileImporter;
import org.nuxeo.ecm.platform.filemanager.service.extension.FileImporterDescriptor;
import org.nuxeo.ecm.platform.filemanager.service.extension.FolderImporter;
import org.nuxeo.ecm.platform.filemanager.service.extension.FolderImporterDescriptor;
import org.nuxeo.ecm.platform.filemanager.service.extension.UnicityExtension;
import org.nuxeo.ecm.platform.filemanager.service.extension.VersioningDescriptor;
import org.nuxeo.ecm.platform.filemanager.utils.FileManagerUtils;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class FileManagerService
extends DefaultComponent
implements FileManager {
    public static final ComponentName NAME = new ComponentName("org.nuxeo.ecm.platform.filemanager.service.FileManagerService");
    public static final String DEFAULT_FOLDER_TYPE_NAME = "Folder";
    public static final String QUERY = "SELECT * FROM Document WHERE file:content/digest = '%s'";
    public static final int MAX = 15;
    private static final Log log = LogFactory.getLog(FileManagerService.class);
    private final Map<String, FileImporter> fileImporters;
    private final List<FolderImporter> folderImporters;
    private final List<CreationContainerListProvider> creationContainerListProviders;
    private List<String> fieldsXPath = new ArrayList<String>();
    private MimetypeRegistry mimeService;
    private boolean unicityEnabled = false;
    private String digestAlgorithm = "sha-256";
    private boolean computeDigest = false;
    public static final VersioningOption DEF_VERSIONING_OPTION = VersioningOption.MINOR;
    public static final boolean DEF_VERSIONING_AFTER_ADD = false;
    @Deprecated
    private VersioningOption defaultVersioningOption = DEF_VERSIONING_OPTION;
    @Deprecated
    private boolean versioningAfterAdd = false;
    private TypeManager typeService;

    public FileManagerService() {
        this.fileImporters = new HashMap<String, FileImporter>();
        this.folderImporters = new LinkedList<FolderImporter>();
        this.creationContainerListProviders = new LinkedList<CreationContainerListProvider>();
    }

    private MimetypeRegistry getMimeService() {
        if (this.mimeService == null) {
            this.mimeService = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        return this.mimeService;
    }

    private TypeManager getTypeService() {
        if (this.typeService == null) {
            this.typeService = (TypeManager)Framework.getService(TypeManager.class);
        }
        return this.typeService;
    }

    private Blob checkMimeType(Blob blob, String fullname) {
        String filename = FileManagerUtils.fetchFileName((String)fullname);
        blob = this.getMimeService().updateMimetype(blob, filename, Boolean.valueOf(true));
        return blob;
    }

    public DocumentModel createFolder(CoreSession documentManager, String fullname, String path, boolean overwrite) throws IOException {
        if (this.folderImporters.isEmpty()) {
            return this.defaultCreateFolder(documentManager, fullname, path, overwrite);
        }
        FolderImporter folderImporter = this.folderImporters.get(this.folderImporters.size() - 1);
        return folderImporter.create(documentManager, fullname, path, overwrite, this.getTypeService());
    }

    @Deprecated
    public DocumentModel defaultCreateFolder(CoreSession documentManager, String fullname, String path) {
        return this.defaultCreateFolder(documentManager, fullname, path, true);
    }

    public DocumentModel defaultCreateFolder(CoreSession documentManager, String fullname, String path, boolean overwrite) {
        return this.defaultCreateFolder(documentManager, fullname, path, DEFAULT_FOLDER_TYPE_NAME, true, overwrite);
    }

    @Deprecated
    public DocumentModel defaultCreateFolder(CoreSession documentManager, String fullname, String path, String containerTypeName, boolean checkAllowedSubTypes) {
        return this.defaultCreateFolder(documentManager, fullname, path, containerTypeName, checkAllowedSubTypes, true);
    }

    public DocumentModel defaultCreateFolder(CoreSession documentManager, String fullname, String path, String containerTypeName, boolean checkAllowedSubTypes, boolean overwrite) {
        DocumentModel docModel;
        String title = FileManagerUtils.fetchFileName((String)fullname);
        if (overwrite && (docModel = FileManagerUtils.getExistingDocByTitle((CoreSession)documentManager, (String)path, (String)title)) != null) {
            return docModel;
        }
        PathRef containerRef = new PathRef(path);
        if (!documentManager.hasPermission((DocumentRef)containerRef, "ReadProperties") || !documentManager.hasPermission((DocumentRef)containerRef, "AddChildren")) {
            throw new DocumentSecurityException("Not enough rights to create folder");
        }
        DocumentModel container = documentManager.getDocument((DocumentRef)containerRef);
        if (checkAllowedSubTypes && !this.getTypeService().isAllowedSubType(containerTypeName, container.getType(), container)) {
            return null;
        }
        PathSegmentService pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        DocumentModel docModel2 = documentManager.createDocumentModel(containerTypeName);
        docModel2.setProperty("dublincore", "title", (Object)title);
        docModel2.setPathInfo(path, pss.generatePathSegment(docModel2));
        docModel2 = documentManager.createDocument(docModel2);
        documentManager.save();
        log.debug((Object)("Created container: " + docModel2.getName() + " with type " + containerTypeName));
        return docModel2;
    }

    public DocumentModel createDocumentFromBlob(CoreSession documentManager, Blob input, String path, boolean overwrite, String fullName) throws IOException {
        return this.createDocumentFromBlob(documentManager, input, path, overwrite, fullName, false);
    }

    public DocumentModel createDocumentFromBlob(CoreSession documentManager, Blob input, String path, boolean overwrite, String fullName, boolean noMimeTypeCheck) throws IOException {
        if (!noMimeTypeCheck) {
            input = this.checkMimeType(input, fullName);
        }
        ArrayList<FileImporter> importers = new ArrayList<FileImporter>(this.fileImporters.values());
        Collections.sort(importers);
        String normalizedMimeType = this.getMimeService().getMimetypeEntryByMimeType(input.getMimeType()).getNormalized();
        for (FileImporter importer : importers) {
            DocumentModel doc;
            if (!importer.isEnabled() || !importer.matches(normalizedMimeType) && !importer.matches(input.getMimeType()) || (doc = importer.create(documentManager, input, path, overwrite, fullName, this.getTypeService())) == null) continue;
            return doc;
        }
        return null;
    }

    public DocumentModel updateDocumentFromBlob(CoreSession documentManager, Blob input, String path, String fullName) {
        String filename = FileManagerUtils.fetchFileName((String)fullName);
        DocumentModel doc = FileManagerUtils.getExistingDocByFileName((CoreSession)documentManager, (String)path, (String)filename);
        if (doc != null) {
            doc.setProperty("file", "content", (Object)input);
            documentManager.saveDocument(doc);
            documentManager.save();
            log.debug((Object)("Updated the document: " + doc.getName()));
        }
        return doc;
    }

    public FileImporter getPluginByName(String name) {
        return this.fileImporters.get(name);
    }

    public void registerExtension(Extension extension) {
        if (extension.getExtensionPoint().equals("plugins")) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                if (contrib instanceof FileImporterDescriptor) {
                    this.registerFileImporter((FileImporterDescriptor)contrib, extension);
                    continue;
                }
                if (contrib instanceof FolderImporterDescriptor) {
                    this.registerFolderImporter((FolderImporterDescriptor)contrib, extension);
                    continue;
                }
                if (!(contrib instanceof CreationContainerListProviderDescriptor)) continue;
                this.registerCreationContainerListProvider((CreationContainerListProviderDescriptor)contrib, extension);
            }
        } else if (extension.getExtensionPoint().equals("unicity")) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                if (!(contrib instanceof UnicityExtension)) continue;
                this.registerUnicityOptions((UnicityExtension)contrib, extension);
            }
        } else if (extension.getExtensionPoint().equals("versioning")) {
            Object[] contribs;
            String message = "Extension point 'versioning' has been deprecated and corresponding behavior removed from Nuxeo Platform. Please use versioning policy instead.";
            DeprecationLogger.log((String)message, (String)"9.1");
            Framework.getRuntime().getWarnings().add(message);
            for (Object contrib : contribs = extension.getContributions()) {
                Boolean veradd;
                if (!(contrib instanceof VersioningDescriptor)) continue;
                VersioningDescriptor descr = (VersioningDescriptor)contrib;
                String defver = descr.defaultVersioningOption;
                if (!StringUtils.isBlank((String)defver)) {
                    try {
                        this.defaultVersioningOption = VersioningOption.valueOf((String)defver.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        log.warn((Object)String.format("Illegal versioning option: %s, using %s instead", defver, DEF_VERSIONING_OPTION));
                        this.defaultVersioningOption = DEF_VERSIONING_OPTION;
                    }
                }
                if ((veradd = descr.versionAfterAdd) == null) continue;
                this.versioningAfterAdd = veradd;
            }
        } else {
            log.warn((Object)String.format("Unknown contribution %s: ignored", extension.getExtensionPoint()));
        }
    }

    public void unregisterExtension(Extension extension) {
        if (extension.getExtensionPoint().equals("plugins")) {
            Object[] contribs;
            for (Object contrib : contribs = extension.getContributions()) {
                if (contrib instanceof FileImporterDescriptor) {
                    this.unregisterFileImporter((FileImporterDescriptor)contrib);
                    continue;
                }
                if (contrib instanceof FolderImporterDescriptor) {
                    this.unregisterFolderImporter((FolderImporterDescriptor)contrib);
                    continue;
                }
                if (!(contrib instanceof CreationContainerListProviderDescriptor)) continue;
                this.unregisterCreationContainerListProvider((CreationContainerListProviderDescriptor)contrib);
            }
        } else if (!extension.getExtensionPoint().equals("unicity")) {
            if (extension.getExtensionPoint().equals("versioning")) {
                this.defaultVersioningOption = DEF_VERSIONING_OPTION;
                this.versioningAfterAdd = false;
            } else {
                log.warn((Object)String.format("Unknown contribution %s: ignored", extension.getExtensionPoint()));
            }
        }
    }

    private void registerUnicityOptions(UnicityExtension unicityExtension, Extension extension) {
        if (unicityExtension.getAlgo() != null) {
            this.digestAlgorithm = unicityExtension.getAlgo();
        }
        if (unicityExtension.getEnabled() != null) {
            this.unicityEnabled = unicityExtension.getEnabled();
        }
        if (unicityExtension.getFields() != null) {
            this.fieldsXPath = unicityExtension.getFields();
        } else {
            this.fieldsXPath.add("file:content");
        }
        if (unicityExtension.getComputeDigest() != null) {
            this.computeDigest = unicityExtension.getComputeDigest();
        }
    }

    private void registerFileImporter(FileImporterDescriptor pluginExtension, Extension extension) {
        String name = pluginExtension.getName();
        if (name == null) {
            log.error((Object)"Cannot register file importer without a name");
            return;
        }
        String className = pluginExtension.getClassName();
        if (this.fileImporters.containsKey(name)) {
            FileImporter newPlugin;
            log.info((Object)("Overriding file importer plugin " + name));
            FileImporter oldPlugin = this.fileImporters.get(name);
            try {
                newPlugin = className != null ? (FileImporter)extension.getContext().loadClass(className).newInstance() : oldPlugin;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            newPlugin = pluginExtension.isMerge() ? this.mergeFileImporters(oldPlugin, newPlugin, pluginExtension) : this.fillImporterWithDescriptor(newPlugin, pluginExtension);
            this.fileImporters.put(name, newPlugin);
            log.info((Object)("Registered file importer " + name));
        } else if (className != null) {
            FileImporter plugin;
            try {
                plugin = (FileImporter)extension.getContext().loadClass(className).newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            plugin = this.fillImporterWithDescriptor(plugin, pluginExtension);
            this.fileImporters.put(name, plugin);
            log.info((Object)("Registered file importer " + name));
        } else {
            log.info((Object)("Unable to register file importer " + name + ", className is null or plugin is not yet registered"));
        }
    }

    private FileImporter mergeFileImporters(FileImporter oldPlugin, FileImporter newPlugin, FileImporterDescriptor desc) {
        List<String> filters = desc.getFilters();
        if (filters != null && !filters.isEmpty()) {
            List<String> oldFilters = oldPlugin.getFilters();
            oldFilters.addAll(filters);
            newPlugin.setFilters(oldFilters);
        }
        newPlugin.setName(desc.getName());
        String docType = desc.getDocType();
        if (docType != null) {
            newPlugin.setDocType(docType);
        }
        newPlugin.setFileManagerService(this);
        newPlugin.setEnabled(desc.isEnabled());
        Integer order = desc.getOrder();
        if (order != null) {
            newPlugin.setOrder(desc.getOrder());
        }
        return newPlugin;
    }

    private FileImporter fillImporterWithDescriptor(FileImporter fileImporter, FileImporterDescriptor desc) {
        List<String> filters = desc.getFilters();
        if (filters != null && !filters.isEmpty()) {
            fileImporter.setFilters(filters);
        }
        fileImporter.setName(desc.getName());
        fileImporter.setDocType(desc.getDocType());
        fileImporter.setFileManagerService(this);
        fileImporter.setEnabled(desc.isEnabled());
        fileImporter.setOrder(desc.getOrder());
        return fileImporter;
    }

    private void unregisterFileImporter(FileImporterDescriptor pluginExtension) {
        String name = pluginExtension.getName();
        this.fileImporters.remove(name);
        log.info((Object)("unregistered file importer: " + name));
    }

    private void registerFolderImporter(FolderImporterDescriptor folderImporterDescriptor, Extension extension) {
        FolderImporter folderImporter;
        String name = folderImporterDescriptor.getName();
        String className = folderImporterDescriptor.getClassName();
        try {
            folderImporter = (FolderImporter)extension.getContext().loadClass(className).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        folderImporter.setName(name);
        folderImporter.setFileManagerService(this);
        this.folderImporters.add(folderImporter);
        log.info((Object)("registered folder importer: " + name));
    }

    private void unregisterFolderImporter(FolderImporterDescriptor folderImporterDescriptor) {
        String name = folderImporterDescriptor.getName();
        FolderImporter folderImporterToRemove = null;
        for (FolderImporter folderImporter : this.folderImporters) {
            if (!name.equals(folderImporter.getName())) continue;
            folderImporterToRemove = folderImporter;
        }
        if (folderImporterToRemove != null) {
            this.folderImporters.remove(folderImporterToRemove);
        }
        log.info((Object)("unregistered folder importer: " + name));
    }

    private void registerCreationContainerListProvider(CreationContainerListProviderDescriptor ccListProviderDescriptor, Extension extension) {
        CreationContainerListProvider provider;
        String name = ccListProviderDescriptor.getName();
        String[] docTypes = ccListProviderDescriptor.getDocTypes();
        String className = ccListProviderDescriptor.getClassName();
        try {
            provider = (CreationContainerListProvider)extension.getContext().loadClass(className).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        provider.setName(name);
        provider.setDocTypes(docTypes);
        if (this.creationContainerListProviders.contains(provider)) {
            this.creationContainerListProviders.remove(provider);
        }
        this.creationContainerListProviders.add(0, provider);
        log.info((Object)("registered creationContaineterList provider: " + name));
    }

    private void unregisterCreationContainerListProvider(CreationContainerListProviderDescriptor ccListProviderDescriptor) {
        String name = ccListProviderDescriptor.getName();
        CreationContainerListProvider providerToRemove = null;
        for (CreationContainerListProvider provider : this.creationContainerListProviders) {
            if (!name.equals(provider.getName())) continue;
            providerToRemove = provider;
            break;
        }
        if (providerToRemove != null) {
            this.creationContainerListProviders.remove(providerToRemove);
        }
        log.info((Object)("unregistered creationContaineterList provider: " + name));
    }

    public List<DocumentLocation> findExistingDocumentWithFile(CoreSession documentManager, String path, String digest, Principal principal) {
        String nxql = String.format(QUERY, digest);
        DocumentModelList documentModelList = documentManager.query(nxql, 15);
        ArrayList<DocumentLocation> docLocationList = new ArrayList<DocumentLocation>(documentModelList.size());
        for (DocumentModel documentModel : documentModelList) {
            docLocationList.add((DocumentLocation)new DocumentLocationImpl(documentModel));
        }
        return docLocationList;
    }

    public boolean isUnicityEnabled() {
        return this.unicityEnabled;
    }

    public boolean isDigestComputingEnabled() {
        return this.computeDigest;
    }

    public List<String> getFields() {
        return this.fieldsXPath;
    }

    public DocumentModelList getCreationContainers(Principal principal, String docType) {
        DocumentModelListImpl containers = new DocumentModelListImpl();
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        for (String repositoryName : repositoryManager.getRepositoryNames()) {
            CoreSession session = CoreInstance.openCoreSession((String)repositoryName, (Principal)principal);
            Throwable throwable = null;
            try {
                containers.addAll((Collection)this.getCreationContainers(session, docType));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (session == null) continue;
                if (throwable != null) {
                    try {
                        session.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                session.close();
            }
        }
        return containers;
    }

    public DocumentModelList getCreationContainers(CoreSession documentManager, String docType) {
        for (CreationContainerListProvider provider : this.creationContainerListProviders) {
            if (!provider.accept(docType)) continue;
            return provider.getCreationContainerList(documentManager, docType);
        }
        return new DocumentModelListImpl();
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @Deprecated
    public VersioningOption getVersioningOption() {
        return this.defaultVersioningOption;
    }

    @Deprecated
    public boolean doVersioningAfterAdd() {
        return this.versioningAfterAdd;
    }
}

