/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class IntParameter
implements ParameterHolder,
Cloneable {
    private int value;

    public IntParameter(int value) {
        this.value = value;
    }

    @Override
    public void writeTo(PacketOutputStream os) {
        os.write(String.valueOf(this.value).getBytes());
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) {
        os.writeUnsafe(String.valueOf(this.value).getBytes());
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return String.valueOf(this.value).getBytes().length;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.assureBufferCapacity(4);
        writeBuffer.buffer.putInt(this.value);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.INTEGER;
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public boolean isLongData() {
        return false;
    }

    @Override
    public boolean isNullData() {
        return false;
    }
}

