/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.read;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.ErrorPacket;
import org.mariadb.jdbc.internal.util.Utils;
import org.mariadb.jdbc.internal.util.buffer.Buffer;
import org.mariadb.jdbc.internal.util.dao.QueryException;

public class ReadInitialConnectPacket {
    static final String MARIADB_RPL_HACK_PREFIX = "5.5.5-";
    private final byte protocolVersion;
    private final long serverThreadId;
    private final long serverCapabilities;
    private final byte serverLanguage;
    private final short serverStatus;
    private final byte[] seed;
    private String serverVersion;
    private String pluginName;

    public ReadInitialConnectPacket(ReadPacketFetcher packetFetcher) throws IOException, QueryException {
        Buffer buffer = packetFetcher.getReusableBuffer();
        if (buffer.getByteAt(0) == -1) {
            ErrorPacket errorPacket = new ErrorPacket(buffer);
            throw new QueryException(errorPacket.getMessage());
        }
        this.protocolVersion = buffer.readByte();
        this.serverVersion = buffer.readString(StandardCharsets.US_ASCII);
        this.serverThreadId = buffer.readInt();
        byte[] seed1 = buffer.readRawBytes(8);
        buffer.skipByte();
        short serverCapabilities2FirstBytes = buffer.readShort();
        this.serverLanguage = buffer.readByte();
        this.serverStatus = buffer.readShort();
        int serverCapabilities4FirstBytes = serverCapabilities2FirstBytes + (buffer.readShort() << 16);
        int saltLength = 0;
        if ((serverCapabilities4FirstBytes & 0x80000) != 0) {
            saltLength = Math.max(12, buffer.readByte() - 9);
        } else {
            buffer.skipByte();
        }
        buffer.skipBytes(6);
        long mariaDbAdditionalCapacities = buffer.readInt();
        if ((serverCapabilities4FirstBytes & 0x8000) != 0) {
            byte[] seed2 = buffer.readRawBytes(saltLength);
            this.seed = Utils.copyWithLength(seed1, seed1.length + seed2.length);
            System.arraycopy(seed2, 0, this.seed, seed1.length, seed2.length);
        } else {
            this.seed = Utils.copyWithLength(seed1, seed1.length);
        }
        buffer.skipByte();
        if ((serverCapabilities4FirstBytes & 0x80000) != 0) {
            this.pluginName = buffer.readString(StandardCharsets.US_ASCII);
            if (this.serverVersion.startsWith(MARIADB_RPL_HACK_PREFIX)) {
                this.serverCapabilities = ((long)serverCapabilities4FirstBytes & 0xFFFFFFFFL) + (mariaDbAdditionalCapacities << 32);
                this.serverVersion = this.serverVersion.substring(MARIADB_RPL_HACK_PREFIX.length());
            } else {
                this.serverCapabilities = (long)serverCapabilities4FirstBytes & 0xFFFFFFFFL;
            }
        } else {
            this.serverCapabilities = (long)serverCapabilities4FirstBytes & 0xFFFFFFFFL;
        }
    }

    public String toString() {
        return this.protocolVersion + ":" + this.serverVersion + ":" + this.serverThreadId + ":" + new String(this.seed) + ":" + this.serverCapabilities + ":" + this.serverLanguage + ":" + this.serverStatus;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getServerThreadId() {
        return this.serverThreadId;
    }

    public byte[] getSeed() {
        return this.seed;
    }

    public long getServerCapabilities() {
        return this.serverCapabilities;
    }

    public byte getServerLanguage() {
        return this.serverLanguage;
    }

    public short getServerStatus() {
        return this.serverStatus;
    }

    public String getPluginName() {
        return this.pluginName;
    }
}

