/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.mariadb.jdbc.MariaDbStatement;
import org.mariadb.jdbc.internal.queryresults.ExecutionResult;
import org.mariadb.jdbc.internal.queryresults.MultiExecutionResult;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class MultiVariableIntExecutionResult
implements MultiExecutionResult {
    private MariaDbStatement statement = null;
    private boolean moreResultAvailable;
    private int fetchSize;
    private boolean selectPossible;
    private boolean canHaveCallableResultset;
    public Deque<ExecutionResult> cachedExecutionResults;
    private MariaSelectResultSet resultSet = null;
    private List<Long> insertId;
    private List<Integer> affectedRows;
    private int waitedSize;

    public MultiVariableIntExecutionResult(MariaDbStatement statement, int size, int fetchSize, boolean selectPossible) {
        this.statement = statement;
        this.fetchSize = fetchSize;
        this.selectPossible = selectPossible;
        this.canHaveCallableResultset = false;
        this.cachedExecutionResults = new ArrayDeque<ExecutionResult>();
        this.affectedRows = new ArrayList<Integer>(size);
        this.insertId = new ArrayList<Long>(size);
    }

    @Override
    public void addResultSet(MariaSelectResultSet result, boolean moreResultAvailable) {
        this.resultSet = result;
        this.insertId.add(-2L);
        this.affectedRows.add(-1);
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public void addStats(long affectedRows, long insertId, boolean moreResultAvailable) {
        this.insertId.add(insertId);
        this.affectedRows.add((int)affectedRows);
        this.setMoreResultAvailable(moreResultAvailable);
    }

    @Override
    public long[] getInsertIds() {
        long[] ret = new long[this.insertId.size()];
        Iterator<Long> iterator = this.insertId.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    @Override
    public int[] getAffectedRows() {
        int[] ret = new int[this.affectedRows.size()];
        Iterator<Integer> iterator = this.affectedRows.iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = iterator.next();
        }
        return ret;
    }

    @Override
    public boolean hasMoreThanOneAffectedRows() {
        return this.affectedRows.size() > 0;
    }

    @Override
    public int getFirstAffectedRows() {
        return this.affectedRows.get(0);
    }

    @Override
    public void addStatsError(boolean moreResultAvailable) {
        this.affectedRows.add(-3);
        this.insertId.add(null);
        this.setMoreResultAvailable(moreResultAvailable);
    }

    public void addStatsError() {
        this.affectedRows.add(-3);
        this.insertId.add(null);
    }

    @Override
    public void fixStatsError(int sendCommand) {
        while (this.affectedRows.size() < sendCommand) {
            this.affectedRows.add(-3);
            this.insertId.add(null);
        }
    }

    @Override
    public int[] updateResultsForRewrite(int waitedSize, boolean hasException) {
        this.waitedSize = waitedSize;
        long totalAffectedRows = 0L;
        Iterator<Integer> iterator = this.affectedRows.iterator();
        while (iterator.hasNext()) {
            totalAffectedRows += (long)iterator.next().intValue();
        }
        int realSize = (int)Math.max((long)waitedSize, totalAffectedRows);
        int baseResult = totalAffectedRows == (long)realSize ? 1 : -2;
        int[] arr = new int[realSize];
        int counter = 0;
        for (int affectedRow : this.affectedRows) {
            for (int i = 0; i < affectedRow; ++i) {
                arr[counter++] = baseResult;
            }
        }
        while (counter < realSize) {
            arr[counter++] = hasException ? -3 : -2;
        }
        return arr;
    }

    public long[] getInsertIdsForRewrite(int autoIncrementIncrement) {
        long totalAffectedRows = 0L;
        Iterator<Integer> iterator = this.affectedRows.iterator();
        Iterator<Long> idsIterator = this.insertId.iterator();
        while (iterator.hasNext()) {
            int affectedRow = iterator.next();
            if (affectedRow == -3) {
                return new long[0];
            }
            totalAffectedRows += (long)affectedRow;
        }
        long realSize = Math.max((long)this.waitedSize, totalAffectedRows);
        long[] arr = new long[(int)realSize];
        int counter = 0;
        iterator = this.affectedRows.iterator();
        while (iterator.hasNext()) {
            long id = idsIterator.next();
            int affectedRow = iterator.next();
            if (affectedRow == -3) break;
            for (int i = 0; i < affectedRow; ++i) {
                arr[counter++] = id + (long)(i * autoIncrementIncrement);
            }
        }
        while ((long)counter < realSize) {
            arr[counter++] = -3L;
        }
        return arr;
    }

    @Override
    public int[] updateResultsMultiple(int waitedSize, boolean hasException) {
        if (hasException) {
            for (int i = this.affectedRows.size(); i < waitedSize; ++i) {
                this.addStatsError();
            }
        }
        return this.getAffectedRows();
    }

    @Override
    public MariaSelectResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public MariaDbStatement getStatement() {
        return this.statement;
    }

    @Override
    public boolean hasMoreResultAvailable() {
        return this.moreResultAvailable;
    }

    protected void setMoreResultAvailable(boolean moreResultAvailable) {
        this.moreResultAvailable = moreResultAvailable;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public void close() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
        }
    }

    @Override
    public boolean isSelectPossible() {
        return this.selectPossible;
    }

    @Override
    public boolean isCanHaveCallableResultset() {
        return this.canHaveCallableResultset;
    }

    @Override
    public Deque<ExecutionResult> getCachedExecutionResults() {
        return this.cachedExecutionResults;
    }

    public void addResult(ExecutionResult executionResult) {
        this.cachedExecutionResults.add(executionResult);
    }

    @Override
    public boolean isSingleExecutionResult() {
        return false;
    }
}

