/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.operation;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.connect.client.we.StudioSnapshotHelper;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageState;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.ecm.admin.runtime.PlatformVersionHelper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Service.HotReloadStudioSnapshot", category="Services", label="Hot Reload Studio Snapshot Package", description="Updates Studio project with latest snapshot.")
public class HotReloadStudioSnapshot {
    public static final String ID = "Service.HotReloadStudioSnapshot";
    protected static boolean updateInProgress = false;
    private static final Log log = LogFactory.getLog(HotReloadStudioSnapshot.class);
    @Context
    protected CoreSession session;
    @Context
    protected PackageManager pm;
    @Param(name="validate", required=false)
    protected boolean validate = true;

    @OperationMethod
    public void run() throws Exception {
        if (updateInProgress) {
            return;
        }
        if (!((NuxeoPrincipal)this.session.getPrincipal()).isAdministrator()) {
            throw new NuxeoException("Must be Administrator to use this function");
        }
        if (!Framework.isDevModeSet()) {
            throw new NuxeoException("You must enable Dev mode to Hot reload your Studio Snapshot package.");
        }
        List pkgs = this.pm.listRemoteAssociatedStudioPackages();
        DownloadablePackage snapshotPkg = StudioSnapshotHelper.getSnapshot(pkgs);
        if (snapshotPkg == null) {
            throw new NuxeoException("No Snapshot Package was found.");
        }
        try {
            updateInProgress = true;
            this.hotReloadPackage(snapshotPkg);
        }
        finally {
            updateInProgress = false;
        }
    }

    public void hotReloadPackage(DownloadablePackage remotePkg) {
        if (this.validate) {
            this.pm.flushCache();
            String targetPlatform = PlatformVersionHelper.getPlatformFilter();
            if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform((Package)remotePkg, (String)targetPlatform)) {
                throw new NuxeoException(String.format("This package is not validated for your current platform: %s", targetPlatform));
            }
        }
        try {
            PackageUpdateService pus = (PackageUpdateService)Framework.getLocalService(PackageUpdateService.class);
            String packageId = remotePkg.getId();
            LocalPackage pkg = pus.getPackage(packageId);
            if (pkg != null) {
                HotReloadStudioSnapshot.removePackage(pus, pkg);
            }
            DownloadingPackage downloadingPkg = this.pm.download(packageId);
            while (!downloadingPkg.isCompleted()) {
                log.debug((Object)("Downloading studio snapshot package: " + packageId));
                Thread.sleep(100L);
            }
            log.info((Object)("Installing " + packageId));
            pkg = pus.getPackage(packageId);
            if (pkg == null || PackageState.DOWNLOADED != pkg.getPackageState()) {
                throw new NuxeoException("Error while downloading studio snapshot " + pkg);
            }
            Task installTask = pkg.getInstallTask();
            try {
                HotReloadStudioSnapshot.performTask(installTask);
            }
            catch (PackageException e) {
                installTask.rollback();
                throw e;
            }
        }
        catch (InterruptedException e) {
            ExceptionUtils.checkInterrupt((Exception)e);
            throw new NuxeoException("Error while downloading studio snapshot", (Throwable)e);
        }
        catch (ConnectServerError | PackageException e) {
            throw new NuxeoException("Error while installing studio snapshot", e);
        }
    }

    protected static void removePackage(PackageUpdateService pus, LocalPackage pkg) throws PackageException {
        log.info((Object)String.format("Removing package %s before update...", pkg.getId()));
        if (pkg.getPackageState().isInstalled()) {
            log.info((Object)("Uninstalling " + pkg.getId()));
            Task uninstallTask = pkg.getUninstallTask();
            try {
                HotReloadStudioSnapshot.performTask(uninstallTask);
            }
            catch (PackageException e) {
                uninstallTask.rollback();
                throw e;
            }
        }
        pus.removePackage(pkg.getId());
    }

    protected static void performTask(Task task) throws PackageException {
        ValidationStatus validationStatus = task.validate();
        if (validationStatus.hasErrors()) {
            throw new PackageException("Failed to validate package " + task.getPackage().getId() + " -> " + validationStatus.getErrors());
        }
        if (validationStatus.hasWarnings()) {
            log.warn((Object)("Got warnings on package validation " + task.getPackage().getId() + " -> " + validationStatus.getWarnings()));
        }
        task.run(null);
    }
}

