/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.BlockJoinSelector;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.NumericUtils;

public class ToParentBlockJoinSortField
extends SortField {
    private final boolean order;
    private final BitSetProducer parentFilter;
    private final BitSetProducer childFilter;

    public ToParentBlockJoinSortField(String field, SortField.Type type, boolean reverse, BitSetProducer parentFilter, BitSetProducer childFilter) {
        super(field, type, reverse);
        switch (this.getType()) {
            case STRING: 
            case DOUBLE: 
            case FLOAT: 
            case LONG: 
            case INT: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Sort type " + type + " is not supported");
            }
        }
        this.order = reverse;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    public ToParentBlockJoinSortField(String field, SortField.Type type, boolean reverse, boolean order, BitSetProducer parentFilter, BitSetProducer childFilter) {
        super(field, type, reverse);
        this.order = order;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        switch (this.getType()) {
            case STRING: {
                return this.getStringComparator(numHits);
            }
            case DOUBLE: {
                return this.getDoubleComparator(numHits);
            }
            case FLOAT: {
                return this.getFloatComparator(numHits);
            }
            case LONG: {
                return this.getLongComparator(numHits);
            }
            case INT: {
                return this.getIntComparator(numHits);
            }
        }
        throw new UnsupportedOperationException("Sort type " + this.getType() + " is not supported");
    }

    private FieldComparator<?> getStringComparator(int numHits) {
        return new FieldComparator.TermOrdValComparator(numHits, this.getField(), this.missingValue == STRING_LAST){

            protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                SortedSetDocValues sortedSet = DocValues.getSortedSet((LeafReader)context.reader(), (String)field);
                BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return DocValues.emptySorted();
                }
                return BlockJoinSelector.wrap(sortedSet, type, parents, children);
            }
        };
    }

    private FieldComparator<?> getIntComparator(int numHits) {
        return new FieldComparator.IntComparator(numHits, this.getField(), (Integer)this.missingValue){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                SortedNumericDocValues sortedNumeric = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
                BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return DocValues.emptyNumeric();
                }
                return BlockJoinSelector.wrap(sortedNumeric, type, parents, children);
            }

            protected Bits getDocsWithValue(LeafReaderContext context, String field) throws IOException {
                Bits docsWithValue = DocValues.getDocsWithField((LeafReader)context.reader(), (String)field);
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return new Bits.MatchNoBits(context.reader().maxDoc());
                }
                return BlockJoinSelector.wrap(docsWithValue, parents, children);
            }
        };
    }

    private FieldComparator<?> getLongComparator(int numHits) {
        return new FieldComparator.LongComparator(numHits, this.getField(), (Long)this.missingValue){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                SortedNumericDocValues sortedNumeric = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
                BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return DocValues.emptyNumeric();
                }
                return BlockJoinSelector.wrap(sortedNumeric, type, parents, children);
            }

            protected Bits getDocsWithValue(LeafReaderContext context, String field) throws IOException {
                Bits docsWithValue = DocValues.getDocsWithField((LeafReader)context.reader(), (String)field);
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return new Bits.MatchNoBits(context.reader().maxDoc());
                }
                return BlockJoinSelector.wrap(docsWithValue, parents, children);
            }
        };
    }

    private FieldComparator<?> getFloatComparator(int numHits) {
        return new FieldComparator.FloatComparator(numHits, this.getField(), (Float)this.missingValue){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                SortedNumericDocValues sortedNumeric = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
                BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return DocValues.emptyNumeric();
                }
                final NumericDocValues view = BlockJoinSelector.wrap(sortedNumeric, type, parents, children);
                return new NumericDocValues(){

                    public long get(int docID) {
                        return NumericUtils.sortableFloatBits((int)((int)view.get(docID)));
                    }
                };
            }
        };
    }

    private FieldComparator<?> getDoubleComparator(int numHits) {
        return new FieldComparator.DoubleComparator(numHits, this.getField(), (Double)this.missingValue){

            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                SortedNumericDocValues sortedNumeric = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field);
                BlockJoinSelector.Type type = ToParentBlockJoinSortField.this.order ? BlockJoinSelector.Type.MAX : BlockJoinSelector.Type.MIN;
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return DocValues.emptyNumeric();
                }
                final NumericDocValues view = BlockJoinSelector.wrap(sortedNumeric, type, parents, children);
                return new NumericDocValues(){

                    public long get(int docID) {
                        return NumericUtils.sortableDoubleBits((long)view.get(docID));
                    }
                };
            }

            protected Bits getDocsWithValue(LeafReaderContext context, String field) throws IOException {
                Bits docsWithValue = DocValues.getDocsWithField((LeafReader)context.reader(), (String)field);
                BitSet parents = ToParentBlockJoinSortField.this.parentFilter.getBitSet(context);
                BitSet children = ToParentBlockJoinSortField.this.childFilter.getBitSet(context);
                if (children == null) {
                    return new Bits.MatchNoBits(context.reader().maxDoc());
                }
                return BlockJoinSelector.wrap(docsWithValue, parents, children);
            }
        };
    }
}

