/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.directory.BaseDirectoryDescriptor;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryDeleteConstraintException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectorySecurityException;
import org.nuxeo.ecm.directory.EntrySource;
import org.nuxeo.ecm.directory.PermissionDescriptor;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryDeleteConstraint;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseSession
implements Session,
EntrySource {
    protected static final String POWER_USERS_GROUP = "powerusers";
    protected static final String READONLY_ENTRY_FLAG = "READONLY_ENTRY";
    protected static final String MULTI_TENANT_ID_FORMAT = "tenant_%s_%s";
    private static final Log log = LogFactory.getLog(BaseSession.class);
    protected final Directory directory;
    protected PermissionDescriptor[] permissions = null;
    protected boolean readAllColumns;
    protected String schemaName;
    protected Map<String, Field> schemaFieldMap;
    protected String directoryName;
    protected BaseDirectoryDescriptor.SubstringMatchType substringMatchType;
    protected Class<? extends Reference> referenceClass;
    protected String passwordHashAlgorithm;
    protected boolean autoincrementId;

    protected BaseSession(Directory directory, Class<? extends Reference> referenceClass) {
        this.directory = directory;
        this.schemaFieldMap = directory.getSchemaFieldMap();
        this.schemaName = directory.getSchema();
        this.directoryName = directory.getName();
        BaseDirectoryDescriptor desc = directory.getDescriptor();
        this.substringMatchType = desc.getSubstringMatchType();
        this.autoincrementId = desc.isAutoincrementIdField();
        this.permissions = desc.permissions;
        this.passwordHashAlgorithm = desc.passwordHashAlgorithm;
        this.referenceClass = referenceClass;
    }

    public abstract Directory getDirectory();

    @Override
    public void setReadAllColumns(boolean readAllColumns) {
        this.readAllColumns = readAllColumns;
    }

    @Override
    public String getIdField() {
        return this.directory.getIdField();
    }

    @Override
    public String getPasswordField() {
        return this.directory.getPasswordField();
    }

    @Override
    public boolean isAuthenticating() {
        return this.directory.getPasswordField() != null;
    }

    @Override
    public boolean isReadOnly() {
        return this.directory.isReadOnly();
    }

    public void checkPermission(String permission) {
        if (this.hasPermission(permission)) {
            return;
        }
        if (permission.equals("Write") && this.isReadOnly()) {
            throw new DirectorySecurityException("Directory is read-only");
        }
        NuxeoPrincipal user = ClientLoginModule.getCurrentPrincipal();
        throw new DirectorySecurityException("User " + user + " does not have " + permission + " permission");
    }

    public void checkDeleteConstraints(String entryId) {
        List<DirectoryDeleteConstraint> deleteConstraints = this.directory.getDirectoryDeleteConstraints();
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        if (deleteConstraints != null && !deleteConstraints.isEmpty()) {
            for (DirectoryDeleteConstraint deleteConstraint : deleteConstraints) {
                if (deleteConstraint.canDelete(directoryService, entryId)) continue;
                throw new DirectoryDeleteConstraintException("This entry is referenced in another vocabulary.");
            }
        }
    }

    public boolean hasPermission(String permission) {
        if (permission.equals("Write") && this.isReadOnly()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Directory is read-only");
            }
            return false;
        }
        NuxeoPrincipal user = ClientLoginModule.getCurrentPrincipal();
        if (user == null) {
            return true;
        }
        String username = user.getName();
        if (username.equals("system") || user.isAdministrator()) {
            return true;
        }
        if (this.permissions == null || this.permissions.length == 0) {
            if (user.isAdministrator()) {
                return true;
            }
            if (user.isMemberOf(POWER_USERS_GROUP)) {
                return true;
            }
            if (permission.equals("Read")) {
                return true;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("User " + user + " does not have " + permission + " permission"));
            }
            return false;
        }
        ArrayList<String> groups = new ArrayList<String>(user.getAllGroups());
        groups.add("Everyone");
        boolean allowed = this.hasPermission(permission, username, groups);
        if (!allowed && permission.equals("Read")) {
            allowed = this.hasPermission("Write", username, groups);
        }
        if (!allowed && log.isTraceEnabled()) {
            log.trace((Object)("User " + user + " does not have " + permission + " permission"));
        }
        return allowed;
    }

    protected boolean hasPermission(String permission, String username, List<String> groups) {
        for (PermissionDescriptor desc : this.permissions) {
            if (!desc.name.equals(permission)) continue;
            if (desc.groups != null) {
                for (String group : desc.groups) {
                    if (!groups.contains(group)) continue;
                    return true;
                }
            }
            if (desc.users == null) continue;
            for (String user : desc.users) {
                if (!user.equals(username)) continue;
                return true;
            }
        }
        return false;
    }

    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values) throws PropertyException {
        DocumentModelImpl entry = new DocumentModelImpl(sessionId, schema, id, null, null, null, null, new String[]{schema}, new HashSet(), null, null);
        if (values == null) {
            values = Collections.emptyMap();
        }
        DataModelImpl dataModel = new DataModelImpl(schema, values);
        entry.addDataModel((DataModel)dataModel);
        return entry;
    }

    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values, boolean readOnly) throws PropertyException {
        DocumentModel entry = BaseSession.createEntryModel(sessionId, schema, id, values);
        if (readOnly) {
            BaseSession.setReadOnlyEntry(entry);
        }
        return entry;
    }

    public static boolean isReadOnlyEntry(DocumentModel entry) {
        return entry.getContextData(READONLY_ENTRY_FLAG) == Boolean.TRUE;
    }

    public static void setReadOnlyEntry(DocumentModel entry) {
        entry.putContextData(READONLY_ENTRY_FLAG, (Serializable)Boolean.TRUE);
    }

    public static void setReadWriteEntry(DocumentModel entry) {
        entry.putContextData(READONLY_ENTRY_FLAG, (Serializable)Boolean.FALSE);
    }

    public static String computeMultiTenantDirectoryId(String tenantId, String id) {
        return String.format(MULTI_TENANT_ID_FORMAT, tenantId, id);
    }

    @Override
    public DocumentModel getEntry(String id) throws DirectoryException {
        return this.getEntry(id, true);
    }

    @Override
    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        if (!this.hasPermission("Read")) {
            return null;
        }
        if (this.readAllColumns) {
            return this.getEntryFromSource(id, fetchReferences);
        }
        return this.directory.getCache().getEntry(id, this, fetchReferences);
    }

    @Override
    public DocumentModelList getEntries() throws DirectoryException {
        if (!this.hasPermission("Read")) {
            return new DocumentModelListImpl();
        }
        return this.query(Collections.emptyMap());
    }

    @Override
    public DocumentModel getEntryFromSource(String id, boolean fetchReferences) throws DirectoryException {
        String idFieldName = this.schemaFieldMap != null ? this.schemaFieldMap.get(this.getIdField()).getName().getPrefixedName() : this.getIdField();
        DocumentModelList result = this.query(Collections.singletonMap(idFieldName, id), Collections.emptySet(), Collections.emptyMap(), true);
        return result.isEmpty() ? null : (DocumentModel)result.get(0);
    }

    @Override
    public DocumentModel createEntry(DocumentModel documentModel) {
        return this.createEntry(documentModel.getProperties(this.schemaName));
    }

    @Override
    public DocumentModel createEntry(Map<String, Object> fieldMap) throws DirectoryException {
        this.checkPermission("Write");
        DocumentModel docModel = this.createEntryWithoutReferences(fieldMap);
        String idFieldName = this.schemaFieldMap != null ? this.schemaFieldMap.get(this.getIdField()).getName().getPrefixedName() : this.getIdField();
        Object entry = fieldMap.get(idFieldName);
        String sourceId = docModel.getId();
        for (Reference reference : this.getDirectory().getReferences()) {
            String referenceFieldName = this.schemaFieldMap.get(reference.getFieldName()).getName().getPrefixedName();
            if (this.getDirectory().getReferences(reference.getFieldName()).size() > 1) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Directory " + this.directoryName + " cannot create field " + reference.getFieldName() + " for entry " + entry + ": this field is associated with more than one reference"));
                continue;
            }
            List targetIds = (List)fieldMap.get(referenceFieldName);
            if (reference.getClass() == this.referenceClass) {
                reference.addLinks(sourceId, targetIds, (Session)this);
                continue;
            }
            reference.addLinks(sourceId, targetIds);
        }
        this.getDirectory().invalidateCaches();
        return docModel;
    }

    @Override
    public void updateEntry(DocumentModel docModel) throws DirectoryException {
        this.checkPermission("Write");
        List<String> referenceFieldList = this.updateEntryWithoutReferences(docModel);
        for (String referenceFieldName : referenceFieldList) {
            List<Reference> references = this.directory.getReferences(referenceFieldName);
            if (references.size() > 1) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Directory " + this.getDirectory().getName() + " cannot update field " + referenceFieldName + " for entry " + docModel.getId() + ": this field is associated with more than one reference"));
                continue;
            }
            Reference reference = references.get(0);
            List targetIds = (List)docModel.getProperty(this.schemaName, referenceFieldName);
            if (reference.getClass() == this.referenceClass) {
                reference.setTargetIdsForSource(docModel.getId(), targetIds, this);
                continue;
            }
            reference.setTargetIdsForSource(docModel.getId(), targetIds);
        }
        this.getDirectory().invalidateCaches();
    }

    @Override
    public void deleteEntry(DocumentModel docModel) throws DirectoryException {
        this.deleteEntry(docModel.getId());
    }

    @Override
    @Deprecated
    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        this.deleteEntry(id);
    }

    @Override
    public void deleteEntry(String id) throws DirectoryException {
        this.checkPermission("Write");
        this.checkDeleteConstraints(id);
        for (Reference reference : this.getDirectory().getReferences()) {
            if (reference.getClass() == this.referenceClass) {
                reference.removeLinksForSource(id, this);
                continue;
            }
            reference.removeLinksForSource(id);
        }
        this.deleteEntryWithoutReferences(id);
        this.getDirectory().invalidateCaches();
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter) throws DirectoryException {
        return this.query(filter, Collections.emptySet());
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext) throws DirectoryException {
        return this.query(filter, fulltext, new HashMap<String, String>());
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy) throws DirectoryException {
        return this.query(filter, fulltext, orderBy, false);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences) throws DirectoryException {
        return this.query(filter, fulltext, orderBy, fetchReferences, 0, 0);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws DirectoryException {
        log.info((Object)"Call an unoverrided query with offset and limit.");
        DocumentModelList entries = this.query(filter, fulltext, orderBy, fetchReferences);
        int toIndex = offset + limit;
        if (toIndex > entries.size()) {
            toIndex = entries.size();
        }
        return new DocumentModelListImpl(entries.subList(offset, toIndex));
    }

    @Override
    public List<String> getProjection(Map<String, Serializable> filter, String columnName) throws DirectoryException {
        return this.getProjection(filter, Collections.emptySet(), columnName);
    }

    @Override
    public List<String> getProjection(Map<String, Serializable> filter, Set<String> fulltext, String columnName) throws DirectoryException {
        DocumentModelList docList = this.query(filter, fulltext);
        ArrayList<String> result = new ArrayList<String>();
        for (DocumentModel docModel : docList) {
            Object obj = docModel.getProperty(this.schemaName, columnName);
            String propValue = String.valueOf(obj);
            result.add(propValue);
        }
        return result;
    }

    protected abstract DocumentModel createEntryWithoutReferences(Map<String, Object> var1);

    protected abstract List<String> updateEntryWithoutReferences(DocumentModel var1) throws DirectoryException;

    protected abstract void deleteEntryWithoutReferences(String var1) throws DirectoryException;
}

