/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import org.nuxeo.ecm.core.storage.BaseDocument;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.StateHelper;

public class DBSDocumentState {
    private static final String UNDEFINED_PARENT_ID = "_undefined_";
    protected State state;
    protected State originalState;
    private String id;
    private String parentId = "_undefined_";

    public DBSDocumentState() {
        this.state = new State();
        this.originalState = null;
    }

    public DBSDocumentState(State base) {
        this.state = StateHelper.deepCopy((State)base);
        this.originalState = null;
    }

    public void markDirty() {
        if (this.originalState == null) {
            this.originalState = StateHelper.deepCopy((State)this.state);
        }
    }

    public boolean isDirty() {
        return this.originalState != null;
    }

    public void setNotDirty() {
        this.originalState = null;
        StateHelper.resetDeltas((State)this.state);
    }

    public State getState() {
        return this.state;
    }

    public State.StateDiff getStateChange() {
        if (this.originalState == null) {
            return null;
        }
        State.StateDiff diff = StateHelper.diff((State)this.originalState, (State)this.state);
        if (diff.isEmpty()) {
            return null;
        }
        return diff;
    }

    public State getOriginalState() {
        return this.originalState == null ? this.state : this.originalState;
    }

    public Serializable get(String key) {
        if ("ecm:id".equals(key)) {
            return this.getId();
        }
        if ("ecm:parentId".equals(key)) {
            return this.getParentId();
        }
        return this.state.get((Object)key);
    }

    public void put(String key, Serializable value) {
        this.markDirty();
        if ("ecm:id".equals(key)) {
            this.id = (String)((Object)value);
        } else if ("ecm:parentId".equals(key)) {
            this.parentId = (String)((Object)value);
        }
        this.state.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.state.get((Object)key) != null;
    }

    public String getId() {
        if (this.id == null) {
            this.id = (String)((Object)this.state.get((Object)"ecm:id"));
        }
        return this.id;
    }

    public String getParentId() {
        if (this.parentId == UNDEFINED_PARENT_ID) {
            this.parentId = (String)((Object)this.state.get((Object)"ecm:parentId"));
        }
        return this.parentId;
    }

    public String getName() {
        return (String)((Object)this.get("ecm:name"));
    }

    public String getPrimaryType() {
        return (String)((Object)this.get("ecm:primaryType"));
    }

    public String getVersionSeriesId() {
        return (String)((Object)this.get("ecm:versionSeriesId"));
    }

    public Long getSysChangeToken() {
        return (Long)this.get("ecm:systemChangeToken");
    }

    public Long getChangeToken() {
        return (Long)this.get("ecm:changeToken");
    }

    public boolean validateUserVisibleChangeToken(String userVisibleChangeToken) {
        Long sysChangeToken = this.getSysChangeToken();
        Long changeToken = this.getChangeToken();
        return BaseDocument.validateUserVisibleChangeToken((Long)sysChangeToken, (Long)changeToken, (String)userVisibleChangeToken);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + (this.isDirty() ? "dirty," : "") + this.state.toString() + ')';
    }
}

