/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.MultiExpression;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.OrderByClause;
import org.nuxeo.ecm.core.query.sql.model.OrderByExpr;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SelectClause;
import org.nuxeo.ecm.core.query.sql.model.SelectList;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.storage.ExpressionEvaluator;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.runtime.api.Framework;

public class DBSExpressionEvaluator
extends ExpressionEvaluator {
    private static final Log log = LogFactory.getLog(DBSExpressionEvaluator.class);
    private static final Long ZERO = 0L;
    private static final Long ONE = 1L;
    protected final SelectClause selectClause;
    protected final Expression expression;
    protected final OrderByClause orderByClause;
    protected SchemaManager schemaManager;
    protected List<String> documentTypes;
    protected State state;
    protected boolean parsing;
    protected List<ValueInfo> referenceValueInfos;
    protected Map<String, ValueInfo> canonicalReferenceValueInfos;
    protected Map<String, IterInfo> canonicalPrefixIterInfos;
    protected List<IterInfo> allIterInfos;
    protected List<IterInfo> toplevelIterInfos;
    protected List<ValueInfo> toplevelValueInfos;
    protected int uncorrelatedCounter;
    protected boolean hasWildcard;
    protected int refCount;

    public DBSExpressionEvaluator(DBSSession session, SelectClause selectClause, Expression expression, OrderByClause orderByClause, String[] principals, boolean fulltextSearchDisabled) {
        super((ExpressionEvaluator.PathResolver)new DBSPathResolver(session), principals, fulltextSearchDisabled);
        this.selectClause = selectClause;
        this.expression = expression;
        this.orderByClause = orderByClause;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public OrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    protected List<String> getDocumentTypes() {
        if (this.documentTypes == null) {
            this.documentTypes = new ArrayList<String>();
            for (DocumentType docType : this.schemaManager.getDocumentTypes()) {
                this.documentTypes.add(docType.getName());
            }
        }
        return this.documentTypes;
    }

    protected Set<String> getMixinDocumentTypes(String mixin) {
        Set types = this.schemaManager.getDocumentTypeNamesForFacet(mixin);
        return types == null ? Collections.emptySet() : types;
    }

    protected boolean isNeverPerInstanceMixin(String mixin) {
        return this.schemaManager.getNoPerDocumentQueryFacets().contains(mixin);
    }

    public void parse() {
        this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        this.referenceValueInfos = new ArrayList<ValueInfo>();
        this.canonicalReferenceValueInfos = new HashMap<String, ValueInfo>();
        this.allIterInfos = new ArrayList<IterInfo>();
        this.toplevelIterInfos = new ArrayList<IterInfo>();
        this.toplevelValueInfos = new ArrayList<ValueInfo>();
        this.canonicalPrefixIterInfos = new HashMap<String, IterInfo>();
        this.uncorrelatedCounter = -1;
        this.hasWildcard = false;
        this.parsing = true;
        this.walkAll();
        this.parsing = false;
        Collections.reverse(this.allIterInfos);
    }

    public List<Map<String, Serializable>> matches(State state) {
        boolean finished;
        if (!this.checkSecurity(state)) {
            return Collections.emptyList();
        }
        this.state = state;
        this.initializeValuesAndIterators(state);
        ArrayList<Map<String, Serializable>> matches = new ArrayList<Map<String, Serializable>>();
        do {
            Map<String, Serializable> projection;
            if ((projection = this.walkAll()) == null) continue;
            matches.add(projection);
        } while (this.hasWildcard && !(finished = this.incrementIterators()));
        return matches;
    }

    protected boolean checkSecurity(State state) {
        if (this.principals == null) {
            return true;
        }
        String[] racl = (String[])state.get((Object)"ecm:racl");
        if (racl == null) {
            log.error((Object)("NULL racl for " + state.get((Object)"ecm:id")));
            return false;
        }
        for (String user : racl) {
            if (!this.principals.contains(user)) continue;
            return true;
        }
        return false;
    }

    protected Map<String, Serializable> walkAll() {
        this.refCount = 0;
        Map<String, Serializable> projection = this.walkSelectClauseAndOrderBy(this.selectClause, this.orderByClause);
        Object res = this.walkExpression(this.expression);
        if (Boolean.TRUE.equals(res)) {
            return projection;
        }
        return null;
    }

    public Map<String, Serializable> walkSelectClauseAndOrderBy(SelectClause selectClause, OrderByClause orderByClause) {
        Reference ref;
        HashMap<String, Serializable> projection = new HashMap<String, Serializable>();
        boolean projectionOnFulltextScore = false;
        boolean sortOnFulltextScore = false;
        SelectList elements = selectClause.getSelectList();
        for (Operand op : elements.values()) {
            if (!(op instanceof Reference)) continue;
            ref = (Reference)op;
            if (ref.name.equals("ecm:fulltextScore")) {
                projectionOnFulltextScore = true;
            }
            this.addProjection(ref, projection);
        }
        if (orderByClause != null) {
            for (OrderByExpr obe : orderByClause.elements) {
                ref = obe.reference;
                if (ref.name.equals("ecm:fulltextScore")) {
                    sortOnFulltextScore = true;
                }
                this.addProjection(ref, projection);
            }
        }
        if ((projectionOnFulltextScore || sortOnFulltextScore) && !this.parsing) {
            if (!this.hasFulltext) {
                throw new QueryParseException("ecm:fulltextScore cannot be used without ecm:fulltext");
            }
            projection.put("ecm:fulltextScore", Double.valueOf(1.0));
        }
        return projection;
    }

    protected void addProjection(Reference ref, Map<String, Serializable> projection) {
        String name = ref.name;
        if (name.equals("ecm:path")) {
            if (!this.parsing) {
                projection.put("ecm:name", this.state.get((Object)"ecm:name"));
                projection.put("ecm:uuid", this.state.get((Object)"ecm:id"));
                projection.put("ecm:parentId", this.state.get((Object)"ecm:parentId"));
            }
            return;
        }
        ValueInfo valueInfo = this.walkReferenceGetValueInfo(ref);
        if (!this.parsing) {
            projection.put(valueInfo.nxqlProp, (Serializable)valueInfo.value);
        }
    }

    public boolean hasWildcardProjection() {
        return this.selectClause.getSelectList().values().stream().anyMatch(operand -> operand instanceof Reference && ((Reference)operand).name.contains("*"));
    }

    public Object walkReference(Reference ref) {
        return this.walkReferenceGetValueInfo(ref).getValueForEvaluation();
    }

    protected ValueInfo walkReferenceGetValueInfo(Reference ref) {
        if (this.parsing) {
            ValueInfo valueInfo = this.parseReference(ref);
            this.referenceValueInfos.add(valueInfo);
            return valueInfo;
        }
        return this.referenceValueInfos.get(this.refCount++);
    }

    protected ValueInfo parseReference(Reference ref) {
        ValueInfo parsed = this.parseReference(ref.name);
        if ("DATE".equals(ref.cast)) {
            Type type = parsed.type;
            if (!(type instanceof DateType || type instanceof ListType && ((ListType)type).getFieldType() instanceof DateType)) {
                throw new QueryParseException("Cannot cast to " + ref.cast + ": " + ref.name);
            }
            parsed.isDateCast = true;
        }
        return this.canonicalReferenceValueInfos.computeIfAbsent(parsed.canonRef, k -> {
            List<IterInfo> iterInfos = this.toplevelIterInfos;
            List<ValueInfo> valueInfos = this.toplevelValueInfos;
            ArrayList<String> prefix = new ArrayList<String>(3);
            ArrayList<Serializable> steps = new ArrayList<Serializable>(1);
            for (Serializable step : parsed.steps) {
                if (step instanceof String) {
                    prefix.add((String)((Object)step));
                    steps.add(step);
                    continue;
                }
                if (step instanceof Integer) {
                    prefix.add(step.toString());
                    steps.add(step);
                    continue;
                }
                this.hasWildcard = true;
                prefix.add("*" + step);
                String canonPrefix = StringUtils.join(prefix, (char)'/');
                IterInfo iter = this.canonicalPrefixIterInfos.get(canonPrefix);
                if (iter == null) {
                    iter = new IterInfo(steps);
                    this.canonicalPrefixIterInfos.put(canonPrefix, iter);
                    this.allIterInfos.add(iter);
                    iterInfos.add(iter);
                }
                iterInfos = iter.dependentIterInfos;
                valueInfos = iter.dependentValueInfos;
                steps = new ArrayList();
            }
            parsed.steps = steps;
            valueInfos.add(parsed);
            return parsed;
        });
    }

    protected ValueInfo parseReference(String name) {
        boolean isTrueOrNullBoolean;
        Type type;
        String[] parts = name.split("/");
        String prop = parts[0];
        if (prop.startsWith("ecm:")) {
            if ((prop = DBSSession.convToInternal(prop)).equals("ecm:acp")) {
                return this.parseACP(parts, name);
            }
            type = DBSSession.getType(prop);
            isTrueOrNullBoolean = true;
        } else {
            Field field = this.schemaManager.getField(prop);
            if (field == null) {
                if (prop.indexOf(58) > -1) {
                    throw new QueryParseException("No such property: " + name);
                }
                for (Schema schema : this.schemaManager.getSchemas()) {
                    if (StringUtils.isBlank((String)schema.getNamespace().prefix) && schema != null && (field = schema.getField(prop)) != null) break;
                }
                if (field == null) {
                    throw new QueryParseException("No such property: " + name);
                }
            }
            type = field.getType();
            isTrueOrNullBoolean = false;
            prop = field.getName().getPrefixedName();
        }
        parts[0] = prop;
        ArrayList<String> canonParts = new ArrayList<String>(parts.length);
        ArrayList<Serializable> steps = new ArrayList<Serializable>(parts.length);
        boolean firstPart = true;
        for (String part : parts) {
            Object step;
            int c = part.indexOf(91);
            if (c >= 0) {
                part = part.substring(c + 1, part.length() - 1);
            }
            if (NumberUtils.isDigits((String)part)) {
                step = Integer.valueOf(part);
                type = ((ListType)type).getFieldType();
            } else if (!part.startsWith("*")) {
                step = part;
                if (!firstPart) {
                    Field field = ((ComplexType)type).getField(part);
                    if (field == null) {
                        throw new QueryParseException("No such property: " + name);
                    }
                    type = field.getType();
                }
            } else {
                int corr;
                if (part.length() == 1) {
                    --this.uncorrelatedCounter;
                    part = "*" + corr;
                } else {
                    String digits = part.substring(1);
                    if (!NumberUtils.isDigits((String)digits)) {
                        throw new QueryParseException("Invalid wildcard (" + part + ") in property: " + name);
                    }
                    corr = Integer.parseInt(digits);
                    if (corr < 0) {
                        throw new QueryParseException("Invalid wildcard (" + part + ") in property: " + name);
                    }
                }
                step = (long)corr;
                type = ((ListType)type).getFieldType();
            }
            canonParts.add(part);
            steps.add((Serializable)step);
            firstPart = false;
        }
        String canonRef = StringUtils.join(canonParts, (char)'/');
        ValueInfo valueInfo = new ValueInfo(steps, name, canonRef);
        valueInfo.type = type;
        valueInfo.isTrueOrNullBoolean = isTrueOrNullBoolean;
        return valueInfo;
    }

    protected ValueInfo parseACP(String[] parts, String name) {
        String canonRef;
        ArrayList<Serializable> steps;
        int corr;
        if (parts.length != 3) {
            throw new QueryParseException("No such property: " + name);
        }
        String wildcard = parts[1];
        if (NumberUtils.isDigits((String)wildcard)) {
            throw new QueryParseException("Cannot use explicit index in ACLs: " + name);
        }
        if (wildcard.length() == 1) {
            corr = this.uncorrelatedCounter--;
            wildcard = "*" + corr;
        } else {
            String digits = wildcard.substring(1);
            if (!NumberUtils.isDigits((String)digits)) {
                throw new QueryParseException("Invalid wildcard (" + wildcard + ") in property: " + name);
            }
            corr = Integer.parseInt(digits);
            if (corr < 0) {
                throw new QueryParseException("Invalid wildcard (" + wildcard + ") in property: " + name);
            }
        }
        String subPart = DBSSession.convToInternalAce(parts[2]);
        if (subPart == null) {
            throw new QueryParseException("No such property: " + name);
        }
        if (subPart.equals("name")) {
            steps = new ArrayList<Serializable>(Arrays.asList("ecm:acp", Long.valueOf(corr), "name"));
            canonRef = "ecm:acp/" + wildcard + '/' + "name";
        } else {
            int corr2 = corr * 1000000;
            String wildcard2 = "*" + corr2;
            steps = new ArrayList<Serializable>(Arrays.asList("ecm:acp", Long.valueOf(corr), "acl", Long.valueOf(corr2), subPart));
            canonRef = "ecm:acp/" + wildcard + '/' + "acl" + '/' + wildcard2 + '/' + subPart;
        }
        ValueInfo valueInfo = new ValueInfo(steps, name, canonRef);
        valueInfo.type = DBSSession.getType(subPart);
        valueInfo.isTrueOrNullBoolean = false;
        return valueInfo;
    }

    protected void initializeValuesAndIterators(State state) {
        this.init(state, this.toplevelValueInfos, this.toplevelIterInfos);
    }

    protected void init(Object state, List<ValueInfo> valueInfos, List<IterInfo> iterInfos) {
        for (ValueInfo valueInfo : valueInfos) {
            valueInfo.value = this.traverse(state, valueInfo.steps);
        }
        for (IterInfo iterInfo : iterInfos) {
            Object value = this.traverse(state, iterInfo.steps);
            iterInfo.setList(value);
            Object iterState = iterInfo.hasNext() ? iterInfo.next() : null;
            this.init(iterState, iterInfo.dependentValueInfos, iterInfo.dependentIterInfos);
        }
    }

    protected Object traverse(Object value, List<Serializable> steps) {
        for (Serializable step : steps) {
            value = this.traverse(value, step);
        }
        return value;
    }

    protected Object traverse(Object value, Serializable step) {
        if (step instanceof String) {
            if (value != null && !(value instanceof State)) {
                throw new QueryParseException("Invalid property " + step + " (no State but " + value.getClass() + ")");
            }
            return value == null ? null : ((State)value).get((Object)step);
        }
        if (step instanceof Integer) {
            int index = (Integer)step;
            if (value == null) {
                return null;
            }
            if (value instanceof List) {
                List list = (List)value;
                if (index >= list.size()) {
                    return null;
                }
                return list.get(index);
            }
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (index >= array.length) {
                    return null;
                }
                return array[index];
            }
            throw new QueryParseException("Invalid property " + step + " (no List/array but " + value.getClass() + ")");
        }
        throw new QueryParseException("Invalid step " + step + " (unknown class " + step.getClass() + ")");
    }

    protected boolean incrementIterators() {
        boolean more = false;
        for (IterInfo iterInfo : this.allIterInfos) {
            more = iterInfo.hasNext();
            if (!more) {
                iterInfo.reset();
            }
            Object state = iterInfo.hasNext() ? iterInfo.next() : null;
            this.init(state, iterInfo.dependentValueInfos, iterInfo.dependentIterInfos);
            if (!more) continue;
            break;
        }
        return !more;
    }

    public Boolean walkMixinTypes(List<String> mixins, boolean include) {
        List<Object> mixinTypes;
        HashSet<Object> matchPrimaryTypes;
        if (this.parsing) {
            return null;
        }
        if (include) {
            matchPrimaryTypes = new HashSet();
            for (String string : mixins) {
                matchPrimaryTypes.addAll(this.getMixinDocumentTypes(string));
            }
        } else {
            matchPrimaryTypes = new HashSet<String>(this.getDocumentTypes());
            for (String string : mixins) {
                matchPrimaryTypes.removeAll(this.getMixinDocumentTypes(string));
            }
        }
        HashSet<String> matchMixinTypes = new HashSet<String>();
        for (String mixin : mixins) {
            if (this.isNeverPerInstanceMixin(mixin)) continue;
            matchMixinTypes.add(mixin);
        }
        String string = (String)((Object)this.state.get((Object)"ecm:primaryType"));
        Object[] mixinTypesArray = (Object[])this.state.get((Object)"ecm:mixinTypes");
        List<Object> list = mixinTypes = mixinTypesArray == null ? Collections.emptyList() : Arrays.asList(mixinTypesArray);
        if (include) {
            if (matchPrimaryTypes.contains(string)) {
                return Boolean.TRUE;
            }
            matchMixinTypes.retainAll(mixinTypes);
            return !matchMixinTypes.isEmpty();
        }
        if (!matchPrimaryTypes.contains(string)) {
            return Boolean.FALSE;
        }
        matchMixinTypes.retainAll(mixinTypes);
        return matchMixinTypes.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(this.selectClause);
        sb.append(" WHERE ");
        if (this.expression instanceof MultiExpression) {
            Iterator it = ((MultiExpression)this.expression).values.iterator();
            while (it.hasNext()) {
                Operand operand = (Operand)it.next();
                sb.append(operand.toString());
                if (!it.hasNext()) continue;
                sb.append(" AND ");
            }
        } else {
            sb.append(this.expression);
        }
        if (this.orderByClause != null) {
            sb.append(" ORDER BY ");
            sb.append(this.orderByClause);
        }
        return sb.toString();
    }

    protected static class DBSPathResolver
    implements ExpressionEvaluator.PathResolver {
        protected final DBSSession session;

        public DBSPathResolver(DBSSession session) {
            this.session = session;
        }

        public String getIdForPath(String path) {
            return this.session.getDocumentIdByPath(path);
        }
    }

    protected static final class IterInfo
    implements Iterator<Object> {
        public final List<Serializable> steps;
        public final List<ValueInfo> dependentValueInfos = new ArrayList<ValueInfo>(2);
        public final List<IterInfo> dependentIterInfos = new ArrayList<IterInfo>(2);
        protected List<Object> list;
        protected Iterator<Object> it;

        public IterInfo(List<Serializable> steps) {
            this.steps = steps;
        }

        public void setList(Object list) {
            List<Object> stateList;
            this.list = list == null ? Collections.emptyList() : (list instanceof List ? (stateList = (List<Object>)list) : Arrays.asList((Object[])list));
            this.reset();
        }

        public void reset() {
            this.it = this.list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public Object next() {
            return this.it.next();
        }

        public String toString() {
            return "IterInfo(" + System.identityHashCode(this) + "," + this.steps + ")";
        }
    }

    protected static final class ValueInfo {
        public List<Serializable> steps;
        public final String nxqlProp;
        public final String canonRef;
        public Type type;
        public boolean isTrueOrNullBoolean;
        public boolean isDateCast;
        public Object value;

        public ValueInfo(List<Serializable> steps, String nxqlProp, String canonRef) {
            this.steps = steps;
            this.nxqlProp = nxqlProp;
            this.canonRef = canonRef;
        }

        public Object getValueForEvaluation() {
            if (this.type instanceof BooleanType) {
                if (this.isTrueOrNullBoolean) {
                    return Boolean.TRUE.equals(this.value) ? ONE : ZERO;
                }
                return this.value == null ? null : ((Boolean)this.value != false ? ONE : ZERO);
            }
            if (this.isDateCast) {
                if (this.value == null) {
                    return null;
                }
                if (this.value instanceof Calendar) {
                    return this.castToDate((Calendar)this.value);
                }
                Object[] array = (Object[])this.value;
                ArrayList<Calendar> dates = new ArrayList<Calendar>(array.length);
                for (Object v : array) {
                    v = v instanceof Calendar ? this.castToDate((Calendar)v) : null;
                    dates.add((Calendar)v);
                }
                return dates.toArray();
            }
            if (this.value == null && this.type instanceof ListType && ((ListType)this.type).isArray()) {
                return new Object[0];
            }
            return this.value;
        }

        protected Calendar castToDate(Calendar date) {
            date.set(11, 0);
            date.set(12, 0);
            date.set(13, 0);
            date.set(14, 0);
            return date;
        }

        public String toString() {
            return "ValueInfo(" + this.canonRef + " " + this.steps + " = " + this.value + ")";
        }
    }
}

