/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.storage.State;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;

public class DBSStateFlattener {
    public static Map<String, Serializable> flatten(State state) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        DBSStateFlattener.flatten(map, state, null);
        return map;
    }

    private static void flatten(Map<String, Serializable> map, State state, String prefix) {
        for (Map.Entry en : state.entrySet()) {
            int i;
            String nameSlash;
            String name;
            String key = (String)en.getKey();
            Serializable value = (Serializable)en.getValue();
            if (key.startsWith("ecm:")) {
                name = DBSSession.convToNXQL(key);
                if (name == null) {
                    continue;
                }
            } else {
                name = key;
            }
            String string = name = prefix == null ? name : prefix + name;
            if (value instanceof State) {
                DBSStateFlattener.flatten(map, (State)value, name + '/');
                continue;
            }
            if (value instanceof List) {
                nameSlash = name + '/';
                i = 0;
                for (Object v : (List)((Object)value)) {
                    if (v instanceof State) {
                        DBSStateFlattener.flatten(map, (State)v, nameSlash + i + '/');
                    } else {
                        map.put(nameSlash + i, (Serializable)v);
                    }
                    ++i;
                }
                continue;
            }
            if (value instanceof Object[]) {
                nameSlash = name + '/';
                i = 0;
                for (Object v : (Object[])value) {
                    map.put(nameSlash + i, (Serializable)v);
                    ++i;
                }
                continue;
            }
            map.put(name, value);
        }
    }
}

