/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.AbstractReference;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryEntryNotFoundException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Reference;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.directory.multi.MultiDirectory;
import org.nuxeo.ecm.directory.multi.SourceDescriptor;
import org.nuxeo.ecm.directory.multi.SubDirectoryDescriptor;
import org.nuxeo.runtime.api.Framework;

public class MultiReference
extends AbstractReference
implements Cloneable {
    private static final Log log = LogFactory.getLog(MultiReference.class);
    final MultiDirectory dir;

    MultiReference(MultiDirectory dir, String fieldName) {
        super(fieldName, null);
        this.dir = dir;
    }

    public void addLinks(String sourceId, List<String> targetIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void addLinks(String sourceId, List<String> targetIds, Session session) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void addLinks(List<String> sourceIds, String targetId, Session session) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void addLinks(List<String> sourceIds, String targetId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    protected List<String> doCollect(Collector extractor) throws DirectoryException {
        DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
        HashSet<String> ids = new HashSet<String>();
        for (SourceDescriptor src : this.dir.getDescriptor().sources) {
            for (SubDirectoryDescriptor sub : src.subDirectories) {
                List ref;
                Directory dir = dirService.getDirectory(sub.name);
                if (dir == null || (ref = dir.getReferences(this.fieldName)) == null) continue;
                try {
                    ids.addAll(extractor.collect(ref));
                }
                catch (DirectoryEntryNotFoundException e) {
                    log.debug((Object)e.getMessage());
                }
            }
        }
        ArrayList<String> x = new ArrayList<String>(ids.size());
        x.addAll(ids);
        return x;
    }

    public List<String> getSourceIdsForTarget(String targetId) throws DirectoryException {
        return this.doCollect(refs -> {
            ArrayList sourceIds = new ArrayList(1);
            for (Reference ref : refs) {
                sourceIds.addAll(ref.getSourceIdsForTarget(targetId));
            }
            return sourceIds;
        });
    }

    public List<String> getTargetIdsForSource(String sourceId) throws DirectoryException {
        return this.doCollect(refs -> {
            ArrayList targetIds = new ArrayList(1);
            for (Reference ref : refs) {
                targetIds.addAll(ref.getSourceIdsForTarget(sourceId));
            }
            return targetIds;
        });
    }

    public void removeLinksForSource(String sourceId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void removeLinksForSource(String sourceId, Session session) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void removeLinksForTarget(String targetId) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void removeLinksForTarget(String targetId, Session session) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void setSourceIdsForTarget(String targetId, List<String> sourceIds, Session session) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public void setTargetIdsForSource(String sourceId, List<String> targetIds, Session session) throws DirectoryException {
        throw new UnsupportedOperationException();
    }

    public MultiReference clone() {
        try {
            return (MultiReference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected static interface Collector {
        public List<String> collect(List<Reference> var1) throws DirectoryException;
    }
}

