/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.pubsub.SerializableInvalidations;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.redis.contribs.RedisInvalidations;
import org.nuxeo.ecm.core.storage.sql.ClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.JedisPubSub;

@Deprecated
public class RedisClusterInvalidator
implements ClusterInvalidator {
    protected static final String PREFIX = "inval";
    protected static final String INVALIDATION_CHANNEL = "channel";
    protected static final String CLUSTER_NODES_KEY = "nodes";
    protected static final int TIMEOUT_REGISTER_SECOND = 86400;
    protected static final long TIMEOUT_SUBSCRIBE_SECOND = 10L;
    protected static final String STARTED_FIELD = "started";
    protected static final String LAST_INVAL_FIELD = "lastInvalSent";
    protected String nodeId;
    protected String repositoryName;
    protected RedisExecutor redisExecutor;
    protected Invalidations receivedInvals;
    protected Thread subscriberThread;
    protected String namespace;
    protected String startedDateTime;
    private static final Log log = LogFactory.getLog(RedisClusterInvalidator.class);
    private CountDownLatch subscribeLatch;
    private String registerSha;
    private String sendSha;

    public void initialize(String nodeId, RepositoryImpl repository) {
        this.nodeId = nodeId;
        this.repositoryName = repository.getName();
        this.redisExecutor = (RedisExecutor)Framework.getLocalService(RedisExecutor.class);
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        this.namespace = redisAdmin.namespace(PREFIX, this.repositoryName);
        try {
            this.registerSha = redisAdmin.load("org.nuxeo.ecm.core.redis", "register-node-inval");
            this.sendSha = redisAdmin.load("org.nuxeo.ecm.core.redis", "send-inval");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.receivedInvals = new Invalidations();
        this.createSubscriberThread();
        this.registerNode();
    }

    protected void createSubscriberThread() {
        this.subscribeLatch = new CountDownLatch(1);
        String name = "RedisClusterInvalidatorSubscriber:" + this.repositoryName + ":" + this.nodeId;
        this.subscriberThread = new Thread(this::subscribeToInvalidationChannel, name);
        this.subscriberThread.setUncaughtExceptionHandler((t, e) -> log.error((Object)("Uncaught error on thread " + t.getName()), e));
        this.subscriberThread.setPriority(5);
        this.subscriberThread.start();
        try {
            if (!this.subscribeLatch.await(10L, TimeUnit.SECONDS)) {
                log.error((Object)"Redis channel subscription timeout after 10s, continuing but this node may not receive cluster invalidations");
            }
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e2);
        }
    }

    protected void subscribeToInvalidationChannel() {
        log.info((Object)("Subscribing to channel: " + this.getChannelName()));
        this.redisExecutor.subscribe(new JedisPubSub(){

            public void onSubscribe(String channel, int subscribedChannels) {
                super.onSubscribe(channel, subscribedChannels);
                if (RedisClusterInvalidator.this.subscribeLatch != null) {
                    RedisClusterInvalidator.this.subscribeLatch.countDown();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Subscribed to channel: " + RedisClusterInvalidator.this.getChannelName()));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(String channel, String message) {
                try {
                    RedisInvalidations rInvals = new RedisInvalidations(RedisClusterInvalidator.this.nodeId, message);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Receive invalidations: " + rInvals));
                    }
                    Invalidations invals = rInvals.getInvalidations();
                    RedisClusterInvalidator redisClusterInvalidator = RedisClusterInvalidator.this;
                    synchronized (redisClusterInvalidator) {
                        RedisClusterInvalidator.this.receivedInvals.add((SerializableInvalidations)invals);
                    }
                }
                catch (IllegalArgumentException e) {
                    log.debug((Object)("Fail to read message: " + message), (Throwable)e);
                }
            }
        }, this.getChannelName());
    }

    protected String getChannelName() {
        return this.namespace + INVALIDATION_CHANNEL;
    }

    protected void registerNode() {
        this.startedDateTime = this.getCurrentDateTime();
        List<String> keys = Collections.singletonList(this.getNodeKey());
        List<String> args = Arrays.asList(STARTED_FIELD, this.startedDateTime, Integer.valueOf(86400).toString());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering node: " + this.nodeId));
        }
        this.redisExecutor.evalsha(this.registerSha, keys, args);
        if (log.isInfoEnabled()) {
            log.info((Object)("Node registered: " + this.nodeId));
        }
    }

    protected String getNodeKey() {
        return this.namespace + CLUSTER_NODES_KEY + ":" + this.nodeId;
    }

    public void close() {
        log.debug((Object)"Closing");
        this.unsubscribeToInvalidationChannel();
        this.receivedInvals.clear();
    }

    protected void unsubscribeToInvalidationChannel() {
        this.subscriberThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Invalidations receiveInvalidations() {
        Invalidations ret;
        Invalidations newInvals = new Invalidations();
        RedisClusterInvalidator redisClusterInvalidator = this;
        synchronized (redisClusterInvalidator) {
            ret = this.receivedInvals;
            this.receivedInvals = newInvals;
        }
        return ret;
    }

    public void sendInvalidations(Invalidations invals) {
        List<String> args;
        RedisInvalidations rInvals = new RedisInvalidations(this.nodeId, invals);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sending invalidations: " + rInvals));
        }
        List<String> keys = Arrays.asList(this.getChannelName(), this.getNodeKey());
        try {
            args = Arrays.asList(rInvals.serialize(), STARTED_FIELD, this.startedDateTime, LAST_INVAL_FIELD, this.getCurrentDateTime(), Integer.valueOf(86400).toString());
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        this.redisExecutor.evalsha(this.sendSha, keys, args);
        log.trace((Object)"invals sent");
    }

    protected String getCurrentDateTime() {
        return LocalDateTime.now().toString();
    }
}

