/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.storage.kv.KeyValueStoreProvider;
import org.nuxeo.runtime.api.Framework;

public class RedisKeyValueStore
implements KeyValueStoreProvider {
    private static final Log log = LogFactory.getLog(RedisKeyValueStore.class);
    public static final String NAMESPACE_PROP = "namespace";
    protected static final Long ONE = 1L;
    protected String namespace;
    protected byte[] compareAndSetSHA;
    protected byte[] compareAndDelSHA;
    protected byte[] compareNullAndSetSHA;

    protected static byte[] getBytes(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }

    public void initialize(Map<String, String> properties) {
        String[] stringArray;
        log.debug((Object)"Initializing");
        String name = properties.get(NAMESPACE_PROP);
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        if (name == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = name;
        }
        this.namespace = redisAdmin.namespace(stringArray);
        try {
            this.compareAndSetSHA = RedisKeyValueStore.getBytes(redisAdmin.load("org.nuxeo.ecm.core.redis", "compare-and-set"));
            this.compareAndDelSHA = RedisKeyValueStore.getBytes(redisAdmin.load("org.nuxeo.ecm.core.redis", "compare-and-del"));
            this.compareNullAndSetSHA = RedisKeyValueStore.getBytes(redisAdmin.load("org.nuxeo.ecm.core.redis", "compare-null-and-set"));
        }
        catch (IOException e) {
            throw new NuxeoException("Cannot load Redis script", (Throwable)e);
        }
    }

    public void close() {
        log.debug((Object)"Closed");
    }

    public void clear() {
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        redisAdmin.clear(this.namespace + "*");
    }

    public void put(String key, byte[] value) {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        redisExecutor.execute(jedis -> {
            byte[] keyb = RedisKeyValueStore.getBytes(this.namespace + key);
            if (value == null) {
                jedis.del(keyb);
            } else {
                jedis.set(keyb, value);
            }
            return null;
        });
    }

    public byte[] get(String key) {
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        return redisExecutor.execute(jedis -> jedis.get(RedisKeyValueStore.getBytes(this.namespace + key)));
    }

    public boolean compareAndSet(String key, byte[] expected, byte[] value) {
        List<Object> args;
        byte[] sha;
        if (expected == null && value == null) {
            return this.get(key) == null;
        }
        List<byte[]> keys = Collections.singletonList(RedisKeyValueStore.getBytes(this.namespace + key));
        if (expected == null) {
            sha = this.compareNullAndSetSHA;
            args = Collections.singletonList(value);
        } else if (value == null) {
            sha = this.compareAndDelSHA;
            args = Collections.singletonList(expected);
        } else {
            sha = this.compareAndSetSHA;
            args = Arrays.asList(expected, value);
        }
        RedisExecutor redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        Object result = redisExecutor.evalsha(sha, keys, args);
        return ONE.equals(result);
    }
}

