/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.transientstore.AbstractTransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreConfig;
import org.nuxeo.runtime.api.Framework;

public class RedisTransientStore
extends AbstractTransientStore {
    protected static final String SIZE_KEY = "size";
    protected RedisExecutor redisExecutor;
    protected String namespace;
    protected String sizeKey;
    protected KeyMatcher keyMatcher;
    protected RedisAdmin redisAdmin;
    protected int firstLevelTTL;
    protected int secondLevelTTL;
    protected Log log = LogFactory.getLog(RedisTransientStore.class);

    public RedisTransientStore() {
        this.redisExecutor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        this.redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
    }

    public void init(TransientStoreConfig config) {
        this.log.debug((Object)("Initializing RedisTransientStore: " + config.getName()));
        super.init(config);
        this.namespace = this.redisAdmin.namespace("transientStore", config.getName());
        this.sizeKey = this.namespace + SIZE_KEY;
        this.keyMatcher = new KeyMatcher();
        this.firstLevelTTL = config.getFirstLevelTTL() * 60;
        this.secondLevelTTL = config.getSecondLevelTTL() * 60;
    }

    public void shutdown() {
        this.log.debug((Object)("Shutting down RedisTransientStore: " + this.config.getName()));
    }

    public boolean exists(String key) {
        return this.getSummary(key) != null || this.getParameters(key) != null;
    }

    public Set<String> keySet() {
        return this.redisExecutor.execute(jedis -> jedis.keys(this.namespace + "*").stream().map(this.keyMatcher).filter(key -> !SIZE_KEY.equals(key)).collect(Collectors.toSet()));
    }

    public void putParameter(String key, String parameter, Serializable value) {
        this.redisExecutor.execute(jedis -> {
            String paramsKey = this.namespace + this.join(key, "params");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting field %s to value %s in Redis hash stored at key %s", parameter, value, paramsKey));
            }
            jedis.hset(this.getBytes(paramsKey), this.getBytes(parameter), this.serialize(value));
            return null;
        });
        this.setTTL(key, this.firstLevelTTL);
    }

    public Serializable getParameter(String key, String parameter) {
        return this.redisExecutor.execute(jedis -> {
            String paramsKey = this.namespace + this.join(key, "params");
            byte[] paramBytes = jedis.hget(this.getBytes(paramsKey), this.getBytes(parameter));
            if (paramBytes == null) {
                return null;
            }
            Serializable res = this.deserialize(paramBytes);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Fetched field %s from Redis hash stored at key %s -> %s", parameter, paramsKey, res));
            }
            return res;
        });
    }

    public void putParameters(String key, Map<String, Serializable> parameters) {
        this.redisExecutor.execute(jedis -> {
            String paramsKey = this.namespace + this.join(key, "params");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting fields %s in Redis hash stored at key %s", parameters, paramsKey));
            }
            jedis.hmset(this.getBytes(paramsKey), this.serialize(parameters));
            return null;
        });
        this.setTTL(key, this.firstLevelTTL);
    }

    public Map<String, Serializable> getParameters(String key) {
        String paramsKey = this.namespace + this.join(key, "params");
        Map paramBytes = this.redisExecutor.execute(jedis -> jedis.hgetAll(this.getBytes(paramsKey)));
        if (paramBytes.isEmpty()) {
            if (this.getSummary(key) == null) {
                return null;
            }
            return new HashMap<String, Serializable>();
        }
        Map<String, Serializable> res = this.deserialize(paramBytes);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Fetched fields from Redis hash stored at key %s -> %s", paramsKey, res));
        }
        return res;
    }

    public List<Blob> getBlobs(String key) {
        String blobCount = this.redisExecutor.execute(jedis -> jedis.hget(this.namespace + key, "blobCount"));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Fetched field \"blobCount\" from Redis hash stored at key %s -> %s", this.namespace + key, blobCount));
        }
        if (blobCount == null) {
            Map<String, Serializable> parameters = this.getParameters(key);
            if (parameters == null) {
                return null;
            }
            return new ArrayList<Blob>();
        }
        int entryBlobCount = Integer.parseInt(blobCount);
        if (entryBlobCount <= 0) {
            return new ArrayList<Blob>();
        }
        ArrayList<Map> blobInfos = new ArrayList<Map>();
        for (int i = 0; i < entryBlobCount; ++i) {
            String blobInfoIndex = String.valueOf(i);
            Map entryBlobInfo = this.redisExecutor.execute(jedis -> {
                String blobInfoKey = this.namespace + this.join(key, "blobs", blobInfoIndex);
                Map blobInfo = jedis.hgetAll(blobInfoKey);
                if (blobInfo.isEmpty()) {
                    throw new NuxeoException(String.format("Entry with key %s is inconsistent: blobCount = %d but key %s doesn't exist", key, entryBlobCount, blobInfoKey));
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Fetched fields from Redis hash stored at key %s -> %s", blobInfoKey, blobInfo));
                }
                return blobInfo;
            });
            blobInfos.add(entryBlobInfo);
        }
        return this.loadBlobs(blobInfos);
    }

    public long getSize(String key) {
        return this.redisExecutor.execute(jedis -> {
            String size = jedis.hget(this.namespace + key, SIZE_KEY);
            if (size == null) {
                return -1L;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Fetched field \"%s\" from Redis hash stored at key %s -> %s", SIZE_KEY, this.namespace + key, size));
            }
            return Long.parseLong(size);
        });
    }

    public boolean isCompleted(String key) {
        return this.redisExecutor.execute(jedis -> {
            String completed = jedis.hget(this.namespace + key, "completed");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Fetched field \"completed\" from Redis hash stored at key %s -> %s", this.namespace + key, completed));
            }
            return Boolean.parseBoolean(completed);
        });
    }

    public void setCompleted(String key, boolean completed) {
        this.redisExecutor.execute(jedis -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting field \"completed\" to value %s in Redis hash stored at key %s", completed, this.namespace + key));
            }
            jedis.hset(this.namespace + key, "completed", String.valueOf(completed));
            return null;
        });
        this.setTTL(key, this.firstLevelTTL);
    }

    public void remove(String key) {
        Map<String, String> summary = this.getSummary(key);
        if (summary != null) {
            long entrySize;
            String blobCount = summary.get("blobCount");
            this.deleteBlobInfos(key, blobCount);
            this.redisExecutor.execute(jedis -> {
                Long deleted = jedis.del(this.namespace + key);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("Deleted %d Redis hash stored at key %s", deleted, this.namespace + key));
                }
                return deleted;
            });
            String size = summary.get(SIZE_KEY);
            if (size != null && (entrySize = (long)Integer.parseInt(size)) > 0L) {
                this.decrementStorageSize(entrySize);
            }
        }
        this.redisExecutor.execute(jedis -> {
            String paramsKey = this.namespace + this.join(key, "params");
            Long deleted = jedis.del(this.getBytes(paramsKey));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Deleted %d Redis hash stored at key %s", deleted, paramsKey));
            }
            return deleted;
        });
    }

    public void release(String key) {
        if (this.getStorageSize() <= (long)(this.config.getTargetMaxSizeMB() * 0x100000) || this.config.getTargetMaxSizeMB() < 0) {
            this.setTTL(key, this.secondLevelTTL);
        } else {
            this.remove(key);
        }
    }

    protected void persistBlobs(String key, long sizeOfBlobs, List<Map<String, String>> blobInfos) {
        String size;
        Map<String, String> oldSummary = this.getSummary(key);
        long entrySize = -1L;
        if (oldSummary != null && (size = oldSummary.get(SIZE_KEY)) != null) {
            entrySize = Long.parseLong(size);
        }
        if (entrySize > 0L) {
            this.incrementStorageSize(sizeOfBlobs - entrySize);
        } else if (sizeOfBlobs > 0L) {
            this.incrementStorageSize(sizeOfBlobs);
        }
        if (oldSummary != null) {
            String oldBlobCount = oldSummary.get("blobCount");
            this.deleteBlobInfos(key, oldBlobCount);
        }
        HashMap<String, String> entrySummary = new HashMap<String, String>();
        int blobCount = 0;
        if (blobInfos != null) {
            blobCount = blobInfos.size();
        }
        entrySummary.put("blobCount", String.valueOf(blobCount));
        entrySummary.put(SIZE_KEY, String.valueOf(sizeOfBlobs));
        this.redisExecutor.execute(jedis -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting fields %s in Redis hash stored at key %s", entrySummary, this.namespace + key));
            }
            jedis.hmset(this.namespace + key, entrySummary);
            jedis.expire(this.namespace + key, this.firstLevelTTL);
            return null;
        });
        if (blobInfos != null) {
            int blobsTimeout = this.firstLevelTTL + 60;
            for (int i = 0; i < blobInfos.size(); ++i) {
                String blobInfoIndex = String.valueOf(i);
                Map<String, String> blobInfo = blobInfos.get(i);
                this.redisExecutor.execute(jedis -> {
                    String blobInfoKey = this.namespace + this.join(key, "blobs", blobInfoIndex);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("Setting fields %s in Redis hash stored at key %s", blobInfo, blobInfoKey));
                    }
                    jedis.hmset(blobInfoKey, blobInfo);
                    jedis.expire(blobInfoKey, blobsTimeout);
                    return null;
                });
            }
        }
        this.redisExecutor.execute(jedis -> {
            String paramsKey = this.namespace + this.join(key, "params");
            jedis.expire(this.getBytes(paramsKey), this.firstLevelTTL + 60);
            return null;
        });
    }

    public long getStorageSize() {
        return this.redisExecutor.execute(jedis -> {
            String value = jedis.get(this.sizeKey);
            if (value == null) {
                return 0L;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Fetched value of Redis key %s -> %s", this.sizeKey, value));
            }
            return Long.parseLong(value);
        });
    }

    protected void setStorageSize(long newSize) {
        this.redisExecutor.execute(jedis -> {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Setting Redis key %s to value %s", this.sizeKey, newSize));
            }
            jedis.set(this.sizeKey, "" + newSize);
            return null;
        });
    }

    protected long incrementStorageSize(long size) {
        return this.redisExecutor.execute(jedis -> {
            Long incremented = jedis.incrBy(this.sizeKey, size);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Incremented Redis key %s to %d", this.sizeKey, incremented));
            }
            return incremented;
        });
    }

    protected long decrementStorageSize(long size) {
        return this.redisExecutor.execute(jedis -> {
            Long decremented = jedis.decrBy(this.sizeKey, size);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Decremented Redis key %s to %d", this.sizeKey, decremented));
            }
            return decremented;
        });
    }

    protected void removeAllEntries() {
        Set keys = this.redisExecutor.execute(jedis -> jedis.keys(this.namespace + "*"));
        for (String key : keys) {
            this.redisExecutor.execute(jedis -> {
                jedis.del(key);
                return null;
            });
        }
    }

    public long getTTL(String key) {
        long summaryTTL = this.redisExecutor.execute(jedis -> jedis.ttl(this.namespace + key));
        if (summaryTTL >= 0L) {
            return summaryTTL;
        }
        return this.redisExecutor.execute(jedis -> {
            String paramsKey = this.namespace + this.join(key, "params");
            return jedis.ttl(this.getBytes(paramsKey));
        });
    }

    protected Map<String, String> getSummary(String key) {
        return this.redisExecutor.execute(jedis -> {
            Map summary = jedis.hgetAll(this.namespace + key);
            if (summary.isEmpty()) {
                return null;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("Fetched fields from Redis hash stored at key %s -> %s", this.namespace + key, summary));
            }
            return summary;
        });
    }

    protected void deleteBlobInfos(String key, String blobCountStr) {
        int blobCount;
        if (blobCountStr != null && (blobCount = Integer.parseInt(blobCountStr)) > 0) {
            for (int i = 0; i < blobCount; ++i) {
                String blobInfoIndex = String.valueOf(i);
                this.redisExecutor.execute(jedis -> {
                    String blobInfoKey = this.namespace + this.join(key, "blobs", blobInfoIndex);
                    Long deleted = jedis.del(blobInfoKey);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)String.format("Deleted %d Redis hash stored at key %s", deleted, blobInfoKey));
                    }
                    return deleted;
                });
            }
        }
    }

    protected String join(String ... fragments) {
        return StringUtils.join((Object[])fragments, (String)":");
    }

    protected byte[] getBytes(String key) {
        return key.getBytes(StandardCharsets.UTF_8);
    }

    protected String getString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    protected byte[] serialize(Serializable value) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(baos);
            out.writeObject(value);
            out.flush();
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected Serializable deserialize(byte[] bytes) {
        try {
            ByteArrayInputStream bain = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(bain);
            return (Serializable)in.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected Map<byte[], byte[]> serialize(Map<String, Serializable> map) {
        HashMap<byte[], byte[]> serializedMap = new HashMap<byte[], byte[]>();
        for (String key : map.keySet()) {
            serializedMap.put(this.getBytes(key), this.serialize(map.get(key)));
        }
        return serializedMap;
    }

    protected Map<String, Serializable> deserialize(Map<byte[], byte[]> byteMap) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (byte[] key : byteMap.keySet()) {
            map.put(this.getString(key), this.deserialize(byteMap.get(key)));
        }
        return map;
    }

    protected void setTTL(String key, int seconds) {
        Map<String, String> summary = this.getSummary(key);
        if (summary != null) {
            int blobCount;
            this.redisExecutor.execute(jedis -> {
                jedis.expire(this.namespace + key, seconds);
                return null;
            });
            String blobCountStr = summary.get("blobCount");
            if (blobCountStr != null && (blobCount = Integer.parseInt(blobCountStr)) > 0) {
                int blobsTimeout = seconds + 60;
                for (int i = 0; i < blobCount; ++i) {
                    String blobInfoIndex = String.valueOf(i);
                    this.redisExecutor.execute(jedis -> {
                        String blobInfoKey = this.namespace + this.join(key, "blobs", blobInfoIndex);
                        jedis.expire(blobInfoKey, blobsTimeout);
                        return null;
                    });
                }
            }
        }
        int paramsTimeout = summary == null ? seconds : seconds + 60;
        this.redisExecutor.execute(jedis -> {
            String paramsKey = this.namespace + this.join(key, "params");
            jedis.expire(this.getBytes(paramsKey), paramsTimeout);
            return null;
        });
    }

    protected class KeyMatcher
    implements Function<String, String> {
        protected final Pattern KEY_PATTERN = Pattern.compile("(.*?)(:(params|blobs:[0-9]+))?");
        protected final int offset;

        protected KeyMatcher() {
            this.offset = RedisTransientStore.this.namespace.length();
        }

        @Override
        public String apply(String t) {
            Matcher m = this.KEY_PATTERN.matcher(t.substring(this.offset));
            m.matches();
            return m.group(1);
        }
    }
}

