/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.redis.contribs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.redis.RedisAdmin;
import org.nuxeo.ecm.core.redis.RedisCallable;
import org.nuxeo.ecm.core.redis.RedisExecutor;
import org.nuxeo.ecm.core.uidgen.AbstractUIDSequencer;
import org.nuxeo.runtime.api.Framework;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisException;

public class RedisUIDSequencer
extends AbstractUIDSequencer {
    protected static final Log log = LogFactory.getLog(RedisUIDSequencer.class);
    protected String namespace;

    public void init() {
        RedisAdmin redisAdmin = (RedisAdmin)Framework.getService(RedisAdmin.class);
        this.namespace = redisAdmin.namespace("counters");
    }

    public void dispose() {
    }

    public int getNext(String key) {
        return (int)this.getNextLong(key);
    }

    public long getNextLong(final String key) {
        RedisExecutor executor = (RedisExecutor)Framework.getService(RedisExecutor.class);
        try {
            return executor.execute(new RedisCallable<Long>(){

                @Override
                public Long call(Jedis jedis) {
                    return jedis.incr(RedisUIDSequencer.this.namespace + key);
                }
            });
        }
        catch (JedisException e) {
            throw new NuxeoException((Throwable)e);
        }
    }
}

