/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;

public class RepositoryReloader
implements EventListener {
    private static Log log = LogFactory.getLog(RepositoryReloader.class);

    public void handleEvent(Event event) {
        String id = event.getId();
        if ("reloadRepositories".equals(id) || "flush".equals(id)) {
            RepositoryReloader.reloadRepositories();
        }
    }

    protected static void closeRepositories() {
        ((RepositoryService)Framework.getService(RepositoryService.class)).shutdown();
    }

    protected static void flushJCAPool() {
        try {
            Class<?> nuxeoContainerClass = Class.forName("org.nuxeo.runtime.jtajca.NuxeoContainer");
            if (nuxeoContainerClass != null) {
                nuxeoContainerClass.getMethod("resetConnectionManager", new Class[0]).invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)e, (Throwable)e);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void reloadRepositories() {
        RepositoryReloader.closeRepositories();
    }
}

