/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.kv;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.nuxeo.ecm.core.storage.kv.KeyValueStoreProvider;

public class MemKeyValueStore
implements KeyValueStoreProvider {
    protected final Map<String, byte[]> map;
    protected final Lock readLock;
    protected final Lock writeLock;

    public MemKeyValueStore() {
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.readLock = rwLock.readLock();
        this.writeLock = rwLock.writeLock();
        this.map = new HashMap<String, byte[]>();
    }

    @Override
    public void initialize(Map<String, String> properties) {
    }

    @Override
    public void close() {
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            this.map.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected static byte[] clone(byte[] value) {
        return value == null ? null : (byte[])value.clone();
    }

    @Override
    public void put(String key, byte[] value) {
        Objects.requireNonNull(key);
        value = MemKeyValueStore.clone(value);
        this.writeLock.lock();
        try {
            this.map.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public byte[] get(String key) {
        byte[] value;
        Objects.requireNonNull(key);
        this.readLock.lock();
        try {
            value = this.map.get(key);
        }
        finally {
            this.readLock.unlock();
        }
        return MemKeyValueStore.clone(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compareAndSet(String key, byte[] expected, byte[] value) {
        Objects.requireNonNull(key);
        value = MemKeyValueStore.clone(value);
        this.writeLock.lock();
        try {
            byte[] current = this.map.get(key);
            boolean equal = Arrays.equals(expected, current);
            if (equal) {
                this.map.put(key, value);
            }
            boolean bl = equal;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

