/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.logging.JavaUtilLoggingHelper;
import org.nuxeo.common.logging.Log4JHelper;
import org.nuxeo.common.logging.Log4jWatchdogHandle;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentManagerImpl;
import org.nuxeo.runtime.model.impl.DefaultRuntimeContext;
import org.osgi.framework.Bundle;

public abstract class AbstractRuntimeService
implements RuntimeService {
    public static final String REDIRECT_JUL = "org.nuxeo.runtime.redirectJUL";
    public static final String REDIRECT_JUL_THRESHOLD = "org.nuxeo.runtime.redirectJUL.threshold";
    public static final String LOG4J_WATCH_DISABLED = "org.nuxeo.runtime.log4jwatch.disabled";
    public static final String LOG4J_WATCH_DELAY = "org.nuxeo.runtime.log4jwatch.delay";
    public static final long LOG4J_WATCH_DELAY_DEFAULT = 10L;
    static final Log log = LogFactory.getLog(RuntimeService.class);
    protected boolean isStarted = false;
    protected boolean isShuttingDown = false;
    protected File workingDir;
    protected CryptoProperties properties = new CryptoProperties(System.getProperties());
    protected ComponentManager manager;
    protected final RuntimeContext context;
    protected final List<String> warnings = new ArrayList<String>();
    protected LogConfig logConfig = new LogConfig();
    protected final List<String> errors = new ArrayList<String>();

    protected AbstractRuntimeService(DefaultRuntimeContext context) {
        this(context, null);
    }

    protected AbstractRuntimeService(DefaultRuntimeContext context, Map<String, String> properties) {
        String errs;
        this.context = context;
        context.setRuntime(this);
        if (properties != null) {
            this.properties.putAll(properties);
        }
        if ((errs = System.getProperty("org.nuxeo.runtime.deployment.errors")) != null) {
            this.errors.addAll(Arrays.asList(errs.split("\n")));
            System.clearProperty("org.nuxeo.runtime.deployment.errors");
        }
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    protected ComponentManager createComponentManager() {
        return new ComponentManagerImpl(this);
    }

    protected static URL getBuiltinFeatureURL() {
        return Thread.currentThread().getContextClassLoader().getResource("org/nuxeo/runtime/nx-feature.xml");
    }

    @Override
    public synchronized void start() {
        if (this.isStarted) {
            return;
        }
        this.manager = this.createComponentManager();
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeServiceException(e);
        }
        this.logConfig.configure();
        log.info((Object)("Starting Nuxeo Runtime service " + this.getName() + "; version: " + this.getVersion()));
        Framework.sendEvent(new RuntimeServiceEvent(0, this));
        try {
            this.doStart();
        }
        finally {
            Framework.sendEvent(new RuntimeServiceEvent(1, this));
            this.isStarted = true;
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.isStarted) {
            return;
        }
        this.isShuttingDown = true;
        try {
            log.info((Object)("Stopping Nuxeo Runtime service " + this.getName() + "; version: " + this.getVersion()));
            Framework.sendEvent(new RuntimeServiceEvent(2, this));
            try {
                this.manager.shutdown();
                this.doStop();
            }
            finally {
                this.isStarted = false;
                Framework.sendEvent(new RuntimeServiceEvent(3, this));
                this.manager = null;
            }
        }
        finally {
            this.logConfig.cleanup();
            this.isShuttingDown = false;
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    protected void loadConfig() throws IOException {
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    @Override
    public File getHome() {
        return this.workingDir;
    }

    public void setHome(File home) {
        this.workingDir = home;
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    public CryptoProperties getProperties() {
        return this.properties;
    }

    @Override
    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    @Override
    public String getProperty(String name, String defValue) {
        String value = this.properties.getProperty(name, defValue);
        if (value == null || ("${" + name + "}").equals(value)) {
            return value;
        }
        return this.expandVars(value);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.properties.setProperty(name, value.toString());
    }

    public String toString() {
        return this.getName() + " version " + this.getVersion();
    }

    @Override
    public Object getComponent(String name) {
        ComponentInstance co = this.getComponentInstance(name);
        return co != null ? co.getInstance() : null;
    }

    @Override
    public Object getComponent(ComponentName name) {
        ComponentInstance co = this.getComponentInstance(name);
        return co != null ? co.getInstance() : null;
    }

    @Override
    public ComponentInstance getComponentInstance(String name) {
        return this.manager.getComponent(new ComponentName(name));
    }

    @Override
    public ComponentInstance getComponentInstance(ComponentName name) {
        return this.manager.getComponent(name);
    }

    @Override
    public ComponentManager getComponentManager() {
        return this.manager;
    }

    @Override
    public RuntimeContext getContext() {
        return this.context;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        return this.manager.getService(serviceClass);
    }

    @Override
    public String expandVars(String expression) {
        return new TextTemplate((Properties)this.properties).processText(expression);
    }

    @Override
    public File getBundleFile(Bundle bundle) {
        return null;
    }

    @Override
    public Bundle getBundle(String symbolicName) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public boolean getStatusMessage(StringBuilder msg) {
        String hr = "======================================================================";
        if (!this.warnings.isEmpty()) {
            msg.append(hr).append("\n= Component Loading Warnings:\n");
            for (String warning : this.warnings) {
                msg.append("  * ").append(warning).append('\n');
            }
        }
        if (!this.errors.isEmpty()) {
            msg.append(hr).append("\n= Component Loading Errors:\n");
            for (String error : this.errors) {
                msg.append("  * ").append(error).append('\n');
            }
        }
        Map<ComponentName, Set<ComponentName>> pendingRegistrations = this.manager.getPendingRegistrations();
        Map<ComponentName, Set<Extension>> missingRegistrations = this.manager.getMissingRegistrations();
        Collection<ComponentName> unstartedRegistrations = this.manager.getActivatingRegistrations();
        unstartedRegistrations.addAll(this.manager.getStartFailureRegistrations());
        msg.append(hr).append("\n= Component Loading Status: Pending: ").append(pendingRegistrations.size()).append(" / Missing: ").append(missingRegistrations.size()).append(" / Unstarted: ").append(unstartedRegistrations.size()).append(" / Total: ").append(this.manager.getRegistrations().size()).append('\n');
        for (Map.Entry<ComponentName, Set<ComponentName>> entry : pendingRegistrations.entrySet()) {
            msg.append("  * ").append(entry.getKey()).append(" requires ").append(entry.getValue()).append('\n');
        }
        for (Map.Entry<ComponentName, Set<Serializable>> entry : missingRegistrations.entrySet()) {
            msg.append("  * ").append(entry.getKey()).append(" references missing ").append(entry.getValue().stream().map(ext -> "target=" + ext.getTargetComponent().getName() + ";point=" + ext.getExtensionPoint()).collect(Collectors.toList())).append('\n');
        }
        for (ComponentName componentName : unstartedRegistrations) {
            msg.append("  - ").append(componentName).append('\n');
        }
        msg.append(hr);
        return this.errors.isEmpty() && pendingRegistrations.isEmpty() && missingRegistrations.isEmpty() && unstartedRegistrations.isEmpty();
    }

    public static Thread getErrorLoggerThread(final String message) {
        return new Thread(){

            @Override
            public void run() {
                log.error((Object)message);
            }
        };
    }

    protected class LogConfig {
        Log4jWatchdogHandle wdog;

        protected LogConfig() {
        }

        public void configure() {
            if (Boolean.parseBoolean(AbstractRuntimeService.this.getProperty(AbstractRuntimeService.REDIRECT_JUL, "true"))) {
                Level threshold = Level.parse(AbstractRuntimeService.this.getProperty(AbstractRuntimeService.REDIRECT_JUL_THRESHOLD, "INFO").toUpperCase());
                JavaUtilLoggingHelper.redirectToApacheCommons((Level)threshold);
            }
            if (Boolean.parseBoolean(AbstractRuntimeService.this.getProperty(AbstractRuntimeService.LOG4J_WATCH_DISABLED, "false"))) {
                log.info((Object)"Disabled log4j.xml change detection");
            } else {
                long delay;
                try {
                    delay = Long.parseLong(AbstractRuntimeService.this.getProperty(AbstractRuntimeService.LOG4J_WATCH_DELAY, Long.toString(10L)));
                }
                catch (NumberFormatException e) {
                    delay = 10L;
                }
                this.wdog = Log4JHelper.configureAndWatch((long)delay);
                if (this.wdog == null) {
                    log.warn((Object)"Failed to configure log4j.xml change detection");
                } else {
                    log.info((Object)("Configured log4j.xml change detection with a delay of " + delay + "s"));
                }
            }
        }

        public void cleanup() {
            try {
                if (this.wdog != null) {
                    this.wdog.cancel();
                }
            }
            finally {
                this.wdog = null;
                JavaUtilLoggingHelper.reset();
            }
        }
    }
}

