/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.nuxeo.runtime.ComponentListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RegistrationInfo;

public interface ComponentManager {
    public void addComponentListener(ComponentListener var1);

    public void removeComponentListener(ComponentListener var1);

    public void register(RegistrationInfo var1);

    public void unregister(RegistrationInfo var1);

    public void unregister(ComponentName var1);

    @Deprecated
    public boolean unregisterByLocation(String var1);

    @Deprecated
    public boolean hasComponentFromLocation(String var1);

    public RegistrationInfo getRegistrationInfo(ComponentName var1);

    public ComponentInstance getComponent(ComponentName var1);

    public boolean isRegistered(ComponentName var1);

    public Collection<RegistrationInfo> getRegistrations();

    public Map<ComponentName, Set<ComponentName>> getPendingRegistrations();

    public Map<ComponentName, Set<Extension>> getMissingRegistrations();

    public Collection<ComponentName> getActivatingRegistrations();

    public Collection<ComponentName> getResolvedRegistrations();

    public Collection<ComponentName> getStartFailureRegistrations();

    public int size();

    public void shutdown();

    public <T> T getService(Class<T> var1);

    public String[] getServices();

    public ComponentInstance getComponentProvidingService(Class<?> var1);

    public Set<String> getBlacklist();

    public void setBlacklist(Set<String> var1);

    public boolean start();

    public boolean stop();

    public void stop(int var1);

    public void standby();

    public void standby(int var1);

    public void resume();

    public void snapshot();

    public void restart(boolean var1);

    public boolean reset();

    public boolean refresh(boolean var1);

    default public boolean refresh() {
        return this.refresh(false);
    }

    public boolean isStarted();

    public boolean isStandby();

    public boolean isRunning();

    public boolean hasChanged();

    public boolean hasSnapshot();

    public boolean isStashEmpty();

    public void unstash();

    public void addListener(Listener var1);

    public void removeListener(Listener var1);

    public static class LifeCycleHandler
    implements Listener {
        @Override
        public void beforeActivation(ComponentManager mgr) {
        }

        @Override
        public void afterActivation(ComponentManager mgr) {
        }

        @Override
        public void beforeDeactivation(ComponentManager mgr) {
        }

        @Override
        public void afterDeactivation(ComponentManager mgr) {
        }

        @Override
        public void beforeStart(ComponentManager mgr, boolean isResume) {
        }

        @Override
        public void afterStart(ComponentManager mgr, boolean isResume) {
        }

        @Override
        public void beforeStop(ComponentManager mgr, boolean isStandby) {
        }

        @Override
        public void afterStop(ComponentManager mgr, boolean isStandby) {
        }

        public LifeCycleHandler install() {
            Framework.getRuntime().getComponentManager().addListener(this);
            return this;
        }

        public LifeCycleHandler uninstall() {
            Framework.getRuntime().getComponentManager().removeListener(this);
            return this;
        }
    }

    public static interface Listener {
        public void beforeActivation(ComponentManager var1);

        public void afterActivation(ComponentManager var1);

        public void beforeDeactivation(ComponentManager var1);

        public void afterDeactivation(ComponentManager var1);

        public void beforeStart(ComponentManager var1, boolean var2);

        public void afterStart(ComponentManager var1, boolean var2);

        public void beforeStop(ComponentManager var1, boolean var2);

        public void afterStop(ComponentManager var1, boolean var2);
    }
}

