/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.ComponentListener;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.ComponentInstanceImpl;
import org.nuxeo.runtime.model.impl.ComponentRegistry;
import org.nuxeo.runtime.model.impl.ExtensionPointImpl;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.util.Watch;

public class ComponentManagerImpl
implements ComponentManager {
    private static final Log log = LogFactory.getLog(ComponentManagerImpl.class);
    private static final Log infoLog = LogFactory.getLog(ComponentManager.class);
    protected final ConcurrentMap<ComponentName, Set<Extension>> pendingExtensions;
    private ListenerList compListeners;
    private Listeners listeners;
    private final ConcurrentMap<String, RegistrationInfoImpl> services;
    protected volatile Set<String> blacklist;
    protected volatile List<RegistrationInfoImpl> started;
    protected volatile List<RegistrationInfoImpl> standby;
    protected volatile Stash stash;
    protected volatile ComponentRegistry registry = new ComponentRegistry();
    protected volatile ComponentRegistry snapshot;
    protected volatile boolean isFlushingStash = false;
    protected volatile boolean changed = false;

    public ComponentManagerImpl(RuntimeService runtime) {
        this.pendingExtensions = new ConcurrentHashMap<ComponentName, Set<Extension>>();
        this.compListeners = new ListenerList();
        this.listeners = new Listeners();
        this.services = new ConcurrentHashMap<String, RegistrationInfoImpl>();
        this.blacklist = new HashSet<String>();
        this.stash = new Stash();
    }

    public final ComponentRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public Collection<RegistrationInfo> getRegistrations() {
        return this.registry.getComponents();
    }

    @Override
    public Collection<ComponentName> getResolvedRegistrations() {
        return this.registry.getResolvedNames();
    }

    @Override
    public synchronized Map<ComponentName, Set<ComponentName>> getPendingRegistrations() {
        HashMap<ComponentName, Set<ComponentName>> pending = new HashMap<ComponentName, Set<ComponentName>>();
        for (Map.Entry<ComponentName, Set<ComponentName>> p : this.registry.getPendingComponents().entrySet()) {
            pending.put(p.getKey(), new LinkedHashSet(p.getValue()));
        }
        return pending;
    }

    @Override
    public synchronized Map<ComponentName, Set<Extension>> getMissingRegistrations() {
        HashMap<ComponentName, Set<Extension>> missing = new HashMap<ComponentName, Set<Extension>>();
        for (Set p : this.pendingExtensions.values()) {
            for (Extension e : p) {
                missing.computeIfAbsent(e.getComponent().getName(), k -> new LinkedHashSet()).add(e);
            }
        }
        return missing;
    }

    public Set<ComponentName> getNeededRegistrations() {
        return this.pendingExtensions.keySet();
    }

    public Set<Extension> getPendingExtensions(ComponentName name) {
        return (Set)this.pendingExtensions.get(name);
    }

    @Override
    public RegistrationInfo getRegistrationInfo(ComponentName name) {
        return this.registry.getComponent(name);
    }

    @Override
    public boolean isRegistered(ComponentName name) {
        return this.registry.contains(name);
    }

    @Override
    public int size() {
        return this.registry.size();
    }

    @Override
    public ComponentInstance getComponent(ComponentName name) {
        RegistrationInfoImpl ri = this.registry.getComponent(name);
        return ri != null ? ri.getComponent() : null;
    }

    @Override
    public synchronized void shutdown() {
        this.stop();
        this.compListeners = null;
        this.registry.destroy();
        this.registry = null;
        this.snapshot = null;
    }

    @Override
    public Set<String> getBlacklist() {
        return Collections.unmodifiableSet(this.blacklist);
    }

    @Override
    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    @Override
    public synchronized void register(RegistrationInfo regInfo) {
        RegistrationInfoImpl ri = (RegistrationInfoImpl)regInfo;
        ComponentName name = ri.getName();
        if (this.blacklist.contains(name.getName())) {
            log.warn((Object)("Component " + name.getName() + " was blacklisted. Ignoring."));
            return;
        }
        Set<ComponentName> componentsToRemove = this.stash.toRemove;
        if (!componentsToRemove.contains(name)) {
            if (this.registry.contains(name)) {
                if (name.getName().startsWith("org.nuxeo.runtime.")) {
                    return;
                }
                ComponentManagerImpl.handleError("Duplicate component name: " + name, null);
                return;
            }
            for (ComponentName n : ri.getAliases()) {
                if (!this.registry.contains(n)) continue;
                ComponentManagerImpl.handleError("Duplicate component name: " + n + " (alias for " + name + ")", null);
                return;
            }
        }
        if (this.shouldStash()) {
            this.stash.add(ri);
            return;
        }
        if (this.hasSnapshot()) {
            this.changed = true;
        }
        ri.attach(this);
        try {
            log.info((Object)("Registering component: " + name));
            if (!this.registry.addComponent(ri)) {
                log.info((Object)("Registration delayed for component: " + name + ". Waiting for: " + this.registry.getMissingDependencies(ri.getName())));
            }
        }
        catch (RuntimeException e) {
            ComponentManagerImpl.handleError("Failed to register component: " + name + " (" + e.toString() + ')', e);
        }
    }

    @Override
    public synchronized void unregister(RegistrationInfo regInfo) {
        this.unregister(regInfo.getName());
    }

    @Override
    public synchronized void unregister(ComponentName name) {
        if (this.shouldStash()) {
            this.stash.remove(name);
            return;
        }
        if (this.hasSnapshot()) {
            this.changed = true;
        }
        try {
            log.info((Object)("Unregistering component: " + name));
            this.registry.removeComponent(name);
        }
        catch (RuntimeException e) {
            log.error((Object)("Failed to unregister component: " + name), (Throwable)e);
        }
    }

    @Override
    public synchronized boolean unregisterByLocation(String sourceId) {
        ComponentName name = this.registry.deployedFiles.remove(sourceId);
        if (name != null) {
            this.unregister(name);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasComponentFromLocation(String sourceId) {
        return this.registry.deployedFiles.containsKey(sourceId);
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        this.compListeners.add((Object)listener);
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        this.compListeners.remove((Object)listener);
    }

    @Override
    public void addListener(ComponentManager.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ComponentManager.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public ComponentInstance getComponentProvidingService(Class<?> serviceClass) {
        RegistrationInfoImpl ri = (RegistrationInfoImpl)this.services.get(serviceClass.getName());
        if (ri == null) {
            return null;
        }
        ComponentInstance ci = ri.getComponent();
        if (ci == null && log.isDebugEnabled()) {
            log.debug((Object)("The component exposing the service " + serviceClass + " is not resolved or not started"));
        }
        return ci;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        ComponentInstance comp = this.getComponentProvidingService(serviceClass);
        return comp != null ? (T)comp.getAdapter(serviceClass) : null;
    }

    @Override
    public Collection<ComponentName> getActivatingRegistrations() {
        return this.getRegistrations(3);
    }

    @Override
    public Collection<ComponentName> getStartFailureRegistrations() {
        return this.getRegistrations(6);
    }

    protected Collection<ComponentName> getRegistrations(int state) {
        RegistrationInfoImpl[] comps = this.registry.getComponentsArray();
        ArrayList<ComponentName> ret = new ArrayList<ComponentName>();
        for (RegistrationInfoImpl ri : comps) {
            if (ri.getState() != state) continue;
            ret.add(ri.getName());
        }
        return ret;
    }

    void sendEvent(ComponentEvent event) {
        Object[] listeners;
        log.debug((Object)("Dispatching event: " + event));
        for (Object listener : listeners = this.compListeners.getListeners()) {
            ((ComponentListener)listener).handleEvent(event);
        }
    }

    public synchronized void registerExtension(Extension extension) {
        ComponentName name = extension.getTargetComponent();
        RegistrationInfoImpl ri = this.registry.getComponent(name);
        if (ri != null && ri.component != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register contributed extension: " + extension));
            }
            ComponentManagerImpl.loadContributions(ri, extension);
            ri.component.registerExtension(extension);
            this.sendEvent(new ComponentEvent(9, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        } else {
            LinkedHashSet<Extension> extensions;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enqueue contributed extension to pending queue: " + extension));
            }
            if ((extensions = (LinkedHashSet<Extension>)this.pendingExtensions.get(name)) == null) {
                extensions = new LinkedHashSet<Extension>();
                this.pendingExtensions.put(name, extensions);
            }
            extensions.add(extension);
            this.sendEvent(new ComponentEvent(11, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        }
    }

    public synchronized void unregisterExtension(Extension extension) {
        ComponentName name;
        RegistrationInfoImpl ri;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregister contributed extension: " + extension));
        }
        if ((ri = this.registry.getComponent(name = extension.getTargetComponent())) != null) {
            ComponentInstance co = ri.getComponent();
            if (co != null) {
                co.unregisterExtension(extension);
            }
        } else {
            Set extensions = (Set)this.pendingExtensions.get(name);
            if (extensions != null) {
                extensions.remove(name);
                if (extensions.isEmpty()) {
                    this.pendingExtensions.remove(name);
                }
            }
        }
        this.sendEvent(new ComponentEvent(10, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
    }

    public static void loadContributions(RegistrationInfoImpl ri, Extension xt) {
        ExtensionPointImpl xp = ri.getExtensionPoint(xt.getExtensionPoint());
        if (xp != null && xp.contributions != null) {
            try {
                Object[] contribs = xp.loadContributions(ri, xt);
                xt.setContributions(contribs);
            }
            catch (RuntimeException e) {
                ComponentManagerImpl.handleError("Failed to load contributions for component " + xt.getComponent().getName(), e);
            }
        }
    }

    public synchronized void registerServices(RegistrationInfoImpl ri) {
        if (ri.serviceDescriptor == null) {
            return;
        }
        for (String service : ri.serviceDescriptor.services) {
            log.info((Object)("Registering service: " + service));
            this.services.put(service, ri);
        }
    }

    public synchronized void unregisterServices(RegistrationInfoImpl ri) {
        if (ri.serviceDescriptor == null) {
            return;
        }
        for (String service : ri.serviceDescriptor.services) {
            this.services.remove(service);
        }
    }

    @Override
    public String[] getServices() {
        return this.services.keySet().toArray(new String[this.services.size()]);
    }

    protected static void handleError(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        Framework.getRuntime().getWarnings().add(message);
    }

    protected List<RegistrationInfoImpl> activateComponents() {
        Watch watch = new Watch();
        watch.start();
        this.listeners.beforeActivation();
        this.pendingExtensions.clear();
        ArrayList<RegistrationInfoImpl> ris = new ArrayList<RegistrationInfoImpl>();
        for (RegistrationInfoImpl ri : this.registry.getResolvedRegistrationInfo()) {
            watch.start(ri.getName().getName());
            ri.activate();
            ris.add(ri);
            watch.stop(ri.getName().getName());
        }
        this.listeners.afterActivation();
        watch.stop();
        if (infoLog.isInfoEnabled()) {
            infoLog.info((Object)("Components activated in " + watch.total.formatSeconds() + " sec."));
        }
        this.writeDevMetrics(watch, "activate");
        return ris;
    }

    protected void deactivateComponents() {
        Watch watch = new Watch();
        watch.start();
        this.listeners.beforeDeactivation();
        Collection<RegistrationInfoImpl> resolved = this.registry.getResolvedRegistrationInfo();
        ArrayList<RegistrationInfoImpl> reverseResolved = new ArrayList<RegistrationInfoImpl>(resolved);
        Collections.reverse(reverseResolved);
        for (RegistrationInfoImpl ri : reverseResolved) {
            if (!ri.isActivated()) continue;
            watch.start(ri.getName().getName());
            ri.deactivate(false);
            watch.stop(ri.getName().getName());
        }
        this.pendingExtensions.clear();
        this.listeners.afterDeactivation();
        watch.stop();
        this.writeDevMetrics(watch, "deactivate");
    }

    protected void startComponents(List<RegistrationInfoImpl> ris, boolean isResume) {
        Watch watch = new Watch();
        watch.start();
        this.listeners.beforeStart(isResume);
        for (RegistrationInfoImpl ri : ris) {
            watch.start(ri.getName().getName());
            ri.start();
            watch.stop(ri.getName().getName());
        }
        this.started = ris;
        this.listeners.afterStart(isResume);
        watch.stop();
        infoLog.info((Object)("Components started in " + watch.total.formatSeconds() + " sec."));
        this.writeDevMetrics(watch, "start");
    }

    protected void stopComponents(boolean isStandby) {
        try {
            this.doStopComppnents(isStandby);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while stopping components", e);
        }
    }

    private void doStopComppnents(boolean isStandby) throws InterruptedException {
        Watch watch = new Watch();
        watch.start();
        this.listeners.beforeStop(isStandby);
        List<RegistrationInfoImpl> list = this.started;
        for (int i = list.size() - 1; i >= 0; --i) {
            RegistrationInfoImpl ri = list.get(i);
            if (!ri.isStarted()) continue;
            watch.start(ri.getName().getName());
            ri.stop();
            watch.stop(ri.getName().getName());
        }
        this.listeners.afterStop(isStandby);
        watch.stop();
        this.writeDevMetrics(watch, "stop");
    }

    @Override
    public synchronized boolean start() {
        if (this.started != null) {
            return false;
        }
        infoLog.info((Object)"Starting Nuxeo Components");
        List<RegistrationInfoImpl> ris = this.activateComponents();
        Collections.sort(ris, new RIApplicationStartedComparator());
        this.startComponents(ris, false);
        return true;
    }

    @Override
    public synchronized boolean stop() {
        if (this.started == null) {
            return false;
        }
        infoLog.info((Object)"Stopping Nuxeo Components");
        try {
            this.stopComponents(false);
            this.deactivateComponents();
        }
        finally {
            this.started = null;
        }
        return true;
    }

    @Override
    public void stop(int timeoutInSeconds) {
        try {
            ComponentManagerImpl.runWihtinTimeout(timeoutInSeconds, TimeUnit.SECONDS, "Timed out on stop, blocking", this::stop);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while stopping components", e);
        }
    }

    @Override
    public synchronized void standby() {
        if (this.started != null) {
            try {
                this.stopComponents(true);
            }
            finally {
                this.standby = this.started;
                this.started = null;
            }
        }
    }

    @Override
    public void standby(int timeoutInSeconds) {
        try {
            ComponentManagerImpl.runWihtinTimeout(timeoutInSeconds, TimeUnit.SECONDS, "Timed out on standby, blocking", this::standby);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while standbying components", e);
        }
    }

    @Override
    public synchronized void resume() {
        if (this.standby != null) {
            try {
                this.startComponents(this.standby, true);
            }
            finally {
                this.started = this.standby;
                this.standby = null;
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.started != null;
    }

    @Override
    public boolean isStandby() {
        return this.standby != null;
    }

    @Override
    public boolean isRunning() {
        return this.started != null || this.standby != null;
    }

    @Override
    public boolean hasSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public synchronized void snapshot() {
        this.snapshot = new ComponentRegistry(this.registry);
    }

    @Override
    public boolean isStashEmpty() {
        return this.stash.isEmpty();
    }

    @Override
    public synchronized void restart(boolean reset) {
        if (reset) {
            this.reset();
        } else {
            this.stop();
        }
        this.start();
    }

    @Override
    public synchronized boolean reset() {
        boolean r = this.stop();
        this.restoreSnapshot();
        return r;
    }

    @Override
    public synchronized boolean refresh() {
        return this.refresh(false);
    }

    @Override
    public synchronized boolean refresh(boolean reset) {
        if (this.stash.isEmpty()) {
            return false;
        }
        boolean requireStart = reset ? this.reset() : this.stop();
        Stash currentStash = this.stash;
        this.stash = new Stash();
        this.applyStash(currentStash);
        if (requireStart) {
            this.start();
        }
        return true;
    }

    protected synchronized void restoreSnapshot() {
        if (this.changed && this.snapshot != null) {
            log.info((Object)"Restoring components snapshot");
            this.registry = new ComponentRegistry(this.snapshot);
            this.changed = false;
        }
    }

    protected boolean shouldStash() {
        return this.started != null && !this.isFlushingStash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void applyStash(Stash stash) {
        log.info((Object)"Applying stashed components");
        this.isFlushingStash = true;
        try {
            for (ComponentName name : stash.toRemove) {
                this.unregister(name);
            }
            for (RegistrationInfoImpl ri : stash.toAdd) {
                this.register(ri);
            }
        }
        finally {
            this.isFlushingStash = false;
        }
    }

    @Override
    public synchronized void unstash() {
        Stash currentStash = this.stash;
        this.stash = new Stash();
        if (!this.isRunning()) {
            this.applyStash(currentStash);
        } else {
            try {
                this.applyStashWhenRunning(currentStash);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Interrupted while unstashing components", e);
            }
        }
    }

    private void applyStashWhenRunning(Stash stash) throws InterruptedException {
        block9: {
            block8: {
                List<RegistrationInfoImpl> toRemove = stash.getRegistrationsToRemove(this.registry);
                if (this.isStarted()) {
                    for (RegistrationInfoImpl ri : toRemove) {
                        this.started.remove(ri);
                        ri.stop();
                    }
                }
                for (RegistrationInfoImpl ri : toRemove) {
                    if (this.isStandby()) {
                        this.standby.remove(ri);
                    }
                    ri.deactivate();
                }
                this.applyStash(stash);
                for (RegistrationInfoImpl ri : stash.toAdd) {
                    if (!ri.isResolved()) continue;
                    ri.activate();
                }
                if (!this.isStandby()) break block8;
                for (RegistrationInfoImpl ri : stash.toAdd) {
                    if (!ri.isResolved()) continue;
                    ri.activate();
                    this.standby.add(ri);
                }
                break block9;
            }
            if (!this.isStarted()) break block9;
            for (RegistrationInfoImpl ri : stash.toAdd) {
                if (!ri.isResolved()) continue;
                ri.activate();
            }
            for (RegistrationInfoImpl ri : stash.toAdd) {
                if (!ri.isActivated()) continue;
                ri.start();
                this.started.add(ri);
            }
        }
    }

    protected void writeDevMetrics(Watch watch, String type) {
        if (!Framework.isDevModeSet()) {
            return;
        }
        File file = new File(Environment.getDefault().getTemp(), type + "-metrics.txt");
        try (PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(file), false, "UTF-8");){
            ps.println(watch.getTotal());
            Arrays.stream(watch.getIntervals()).sorted(Comparator.reverseOrder()).forEach(ps::println);
            ps.flush();
        }
        catch (IOException e) {
            log.error((Object)("Failed to write metrics file: " + file), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void runWihtinTimeout(long timeout, TimeUnit unit, String warn, Runnable runnable) throws InterruptedException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            Future<?> future = executor.submit(runnable::run);
            executor.shutdown();
            try {
                try {
                    future.get(timeout, unit);
                }
                catch (TimeoutException cause) {
                    log.warn((Object)warn);
                    future.get();
                }
            }
            catch (ExecutionException cause) {
                throw new RuntimeException("Errors caught while stopping components, giving up", cause);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    protected static class Stash {
        protected volatile List<RegistrationInfoImpl> toAdd = new ArrayList<RegistrationInfoImpl>();
        protected volatile Set<ComponentName> toRemove = new HashSet<ComponentName>();

        public void add(RegistrationInfoImpl ri) {
            this.toAdd.add(ri);
        }

        public void remove(ComponentName name) {
            this.toRemove.add(name);
        }

        public boolean isEmpty() {
            return this.toAdd.isEmpty() && this.toRemove.isEmpty();
        }

        public List<RegistrationInfoImpl> getRegistrationsToRemove(ComponentRegistry reg) {
            ArrayList<RegistrationInfoImpl> ris = new ArrayList<RegistrationInfoImpl>();
            for (ComponentName name : this.toRemove) {
                RegistrationInfoImpl ri = reg.getComponent(name);
                if (ri == null) continue;
                ris.add(ri);
            }
            return ris;
        }
    }

    protected class Listeners {
        protected ListenerList listeners = new ListenerList();

        protected Listeners() {
        }

        public void add(ComponentManager.Listener listener) {
            this.listeners.add((Object)listener);
        }

        public void remove(ComponentManager.Listener listener) {
            this.listeners.remove((Object)listener);
        }

        public void beforeActivation() {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).beforeActivation(ComponentManagerImpl.this);
            }
        }

        public void afterActivation() {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).afterActivation(ComponentManagerImpl.this);
            }
        }

        public void beforeDeactivation() {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).beforeDeactivation(ComponentManagerImpl.this);
            }
        }

        public void afterDeactivation() {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).afterDeactivation(ComponentManagerImpl.this);
            }
        }

        public void beforeStart(boolean isResume) {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).beforeStart(ComponentManagerImpl.this, isResume);
            }
        }

        public void afterStart(boolean isResume) {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).afterStart(ComponentManagerImpl.this, isResume);
            }
        }

        public void beforeStop(boolean isStandby) {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).beforeStop(ComponentManagerImpl.this, isStandby);
            }
        }

        public void afterStop(boolean isStandby) {
            for (Object listener : this.listeners.getListeners()) {
                ((ComponentManager.Listener)listener).afterStop(ComponentManagerImpl.this, isStandby);
            }
        }
    }

    protected static class RIApplicationStartedComparator
    implements Comparator<RegistrationInfo> {
        protected RIApplicationStartedComparator() {
        }

        @Override
        public int compare(RegistrationInfo r1, RegistrationInfo r2) {
            int cmp = Integer.compare(r1.getApplicationStartedOrder(), r2.getApplicationStartedOrder());
            if (cmp == 0) {
                cmp = r1.getName().getName().compareTo(r2.getName().getName());
            }
            return cmp;
        }
    }
}

