/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.util;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Watch {
    public final TimeInterval total = new TimeInterval("total");
    public final Map<String, TimeInterval> intervals = new HashMap<String, TimeInterval>();

    public Watch start() {
        this.total.t0 = 0L;
        this.total.t1 = 0L;
        this.intervals.clear();
        this.total.start();
        return this;
    }

    public Watch stop() {
        this.total.stop();
        return this;
    }

    public Watch start(String interval) {
        TimeInterval ti = this.intervals.get(interval);
        if (ti == null) {
            ti = new TimeInterval(interval);
            this.intervals.put(interval, ti);
        }
        ti.start();
        return this;
    }

    public Watch stop(String interval) {
        TimeInterval ti = this.intervals.get(interval);
        if (ti != null) {
            ti.stop();
        }
        return this;
    }

    public long elapsed(TimeUnit unit) {
        return this.total.elapsed(unit);
    }

    public long elapsed(String name, TimeUnit unit) {
        TimeInterval ti = this.intervals.get(name);
        if (ti != null) {
            return this.total.elapsed(unit);
        }
        return 0L;
    }

    public TimeInterval getTotal() {
        return this.total;
    }

    public TimeInterval[] getIntervals() {
        return this.intervals.values().toArray(new TimeInterval[this.intervals.size()]);
    }

    public static class TimeInterval
    implements Comparable<TimeInterval> {
        public String name;
        public long t0;
        public long t1;

        public TimeInterval(String name) {
            this.name = name;
        }

        public long elapsed() {
            return this.t1 - this.t0;
        }

        public long elapsed(TimeUnit unit) {
            return unit.convert(this.t1 - this.t0, TimeUnit.NANOSECONDS);
        }

        protected void start() {
            this.t0 = System.nanoTime();
        }

        protected void stop() {
            this.t1 = System.nanoTime();
        }

        @Override
        public int compareTo(TimeInterval o) {
            long dt = this.t1 - this.t0 - (o.t1 - o.t0);
            return dt < 0L ? -1 : (dt > 0L ? 1 : 0);
        }

        public String formatSeconds() {
            return new DecimalFormat("0.000").format(((double)this.t1 - (double)this.t0) / 1.0E9);
        }

        public String toString() {
            return this.name + ": " + this.formatSeconds() + " sec.";
        }
    }
}

