/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import com.google.api.client.auth.oauth2.Credential;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.automation.server.jaxrs.RestOperationException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.providers.AbstractOAuth2UserEmailProvider;
import org.nuxeo.ecm.platform.oauth2.providers.NuxeoOAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProvider;
import org.nuxeo.ecm.platform.oauth2.providers.OAuth2ServiceProviderRegistry;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AbstractResource;
import org.nuxeo.ecm.webengine.model.impl.ResourceTypeImpl;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="oauth2")
public class OAuth2Object
extends AbstractResource<ResourceTypeImpl> {
    public static final String APPLICATION_JSON_NXENTITY = "application/json+nxentity";
    public static final String TOKEN_DIR = "oauth2Tokens";

    @GET
    @Path(value="provider")
    public List<NuxeoOAuth2ServiceProvider> getProviders(@Context HttpServletRequest request) throws IOException, RestOperationException {
        return this.getProviders();
    }

    @GET
    @Path(value="provider/{providerId}")
    public Response getProvider(@PathParam(value="providerId") String providerId, @Context HttpServletRequest request) throws IOException, RestOperationException {
        return Response.ok((Object)this.getProvider(providerId)).build();
    }

    @POST
    @Path(value="provider")
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response addProvider(@Context HttpServletRequest request, NuxeoOAuth2ServiceProvider provider) throws IOException, RestOperationException {
        this.checkPermission();
        Framework.doPrivileged(() -> {
            OAuth2ServiceProviderRegistry registry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
            registry.addProvider(provider.getServiceName(), provider.getDescription(), provider.getTokenServerURL(), provider.getAuthorizationServerURL(), provider.getUserAuthorizationURL(), provider.getClientId(), provider.getClientSecret(), provider.getScopes(), Boolean.valueOf(provider.isEnabled()));
        });
        return Response.ok((Object)this.getProvider(provider.getServiceName())).build();
    }

    @PUT
    @Path(value="provider/{providerId}")
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response updateProvider(@PathParam(value="providerId") String providerId, @Context HttpServletRequest request, NuxeoOAuth2ServiceProvider provider) throws IOException, RestOperationException {
        this.checkPermission();
        this.getProvider(providerId);
        Framework.doPrivileged(() -> {
            OAuth2ServiceProviderRegistry registry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
            registry.updateProvider(providerId, (OAuth2ServiceProvider)provider);
        });
        return Response.ok((Object)this.getProvider(provider.getServiceName())).build();
    }

    @DELETE
    @Path(value="provider/{providerId}")
    public Response deleteProvider(@PathParam(value="providerId") String providerId, @Context HttpServletRequest request) throws IOException, RestOperationException {
        this.checkPermission();
        this.getProvider(providerId);
        Framework.doPrivileged(() -> {
            OAuth2ServiceProviderRegistry registry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
            registry.deleteProvider(providerId);
        });
        return Response.noContent().build();
    }

    @GET
    @Path(value="provider/{providerId}/token")
    public Response getToken(@PathParam(value="providerId") String providerId, @Context HttpServletRequest request) throws IOException, RestOperationException {
        String username;
        NuxeoOAuth2ServiceProvider provider = this.getProvider(providerId);
        NuxeoOAuth2Token token = this.getToken(provider, username = request.getUserPrincipal().getName());
        if (token == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Credential credential = this.getCredential(provider, token);
        if (credential == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        Long expiresInSeconds = credential.getExpiresInSeconds();
        if (expiresInSeconds != null && expiresInSeconds <= 0L) {
            credential.refreshToken();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("token", credential.getAccessToken());
        return this.buildResponse((Response.StatusType)Response.Status.OK, result);
    }

    @GET
    @Path(value="token")
    public List<NuxeoOAuth2Token> getTokens(@Context HttpServletRequest request) throws IOException, RestOperationException {
        this.checkPermission();
        return this.getTokens();
    }

    @GET
    @Path(value="token/{providerId}/{nxuser}")
    public Response getToken(@PathParam(value="providerId") String providerId, @PathParam(value="nxuser") String nxuser, @Context HttpServletRequest request) throws IOException, RestOperationException {
        this.checkPermission();
        NuxeoOAuth2ServiceProvider provider = this.getProvider(providerId);
        return Response.ok((Object)this.getToken(provider, nxuser)).build();
    }

    @PUT
    @Path(value="token/{providerId}/{nxuser}")
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response updateToken(@PathParam(value="providerId") String providerId, @PathParam(value="nxuser") String nxuser, @Context HttpServletRequest request, NuxeoOAuth2Token token) throws IOException, RestOperationException {
        this.checkPermission();
        NuxeoOAuth2ServiceProvider provider = this.getProvider(providerId);
        return Response.ok((Object)this.updateToken(provider, nxuser, token)).build();
    }

    @DELETE
    @Path(value="token/{providerId}/{nxuser}")
    public Response deleteToken(@PathParam(value="providerId") String providerId, @PathParam(value="nxuser") String nxuser, @Context HttpServletRequest request) throws IOException, RestOperationException {
        this.checkPermission();
        NuxeoOAuth2ServiceProvider provider = this.getProvider(providerId);
        this.deleteToken(this.getTokenDoc(provider, nxuser));
        return Response.noContent().build();
    }

    protected List<NuxeoOAuth2ServiceProvider> getProviders() {
        OAuth2ServiceProviderRegistry registry = (OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class);
        return registry.getProviders().stream().filter(NuxeoOAuth2ServiceProvider.class::isInstance).map(provider -> (NuxeoOAuth2ServiceProvider)provider).collect(Collectors.toList());
    }

    protected NuxeoOAuth2ServiceProvider getProvider(String providerId) throws RestOperationException {
        OAuth2ServiceProvider provider = ((OAuth2ServiceProviderRegistry)Framework.getService(OAuth2ServiceProviderRegistry.class)).getProvider(providerId);
        if (provider == null || !(provider instanceof NuxeoOAuth2ServiceProvider)) {
            RestOperationException err = new RestOperationException("Invalid provider: " + providerId);
            err.setStatus(404);
            throw err;
        }
        return (NuxeoOAuth2ServiceProvider)provider;
    }

    protected List<NuxeoOAuth2Token> getTokens() {
        return this.getTokens((String)null);
    }

    protected List<NuxeoOAuth2Token> getTokens(String nxuser) {
        return (List)Framework.doPrivileged(() -> {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = ds.open(TOKEN_DIR);){
                HashMap<String, String> filter = new HashMap<String, String>();
                if (nxuser != null) {
                    filter.put("nuxeoLogin", nxuser);
                }
                DocumentModelList docs = session.query(filter, Collections.emptySet(), Collections.emptyMap(), true, 0, 0);
                List list = docs.stream().map(NuxeoOAuth2Token::new).collect(Collectors.toList());
                return list;
            }
        });
    }

    protected DocumentModel getTokenDoc(NuxeoOAuth2ServiceProvider provider, String nxuser) throws RestOperationException {
        HashMap<String, String> filter = new HashMap<String, String>();
        filter.put("serviceName", provider.getServiceName());
        filter.put("nuxeoLogin", nxuser);
        List tokens = (List)Framework.doPrivileged(() -> {
            DocumentModelList entries = provider.getCredentialDataStore().query(filter);
            return entries.stream().filter(Objects::nonNull).collect(Collectors.toList());
        });
        if (tokens.size() > 1) {
            throw new NuxeoException("Found multiple " + provider.getId() + " accounts for " + nxuser);
        }
        if (tokens.size() == 0) {
            throw new RestOperationException("No token found for provider: " + provider.getId(), 404);
        }
        return (DocumentModel)tokens.get(0);
    }

    protected NuxeoOAuth2Token getToken(NuxeoOAuth2ServiceProvider provider, String nxuser) throws RestOperationException {
        return new NuxeoOAuth2Token(this.getTokenDoc(provider, nxuser));
    }

    protected NuxeoOAuth2Token updateToken(NuxeoOAuth2ServiceProvider provider, String nxuser, NuxeoOAuth2Token token) throws RestOperationException {
        DocumentModel entry = this.getTokenDoc(provider, nxuser);
        entry.setProperty("oauth2Token", "serviceName", (Object)token.getServiceName());
        entry.setProperty("oauth2Token", "nuxeoLogin", (Object)token.getNuxeoLogin());
        entry.setProperty("oauth2Token", "clientId", (Object)token.getClientId());
        entry.setProperty("oauth2Token", "isShared", (Object)token.isShared());
        entry.setProperty("oauth2Token", "sharedWith", (Object)token.getSharedWith());
        entry.setProperty("oauth2Token", "serviceLogin", (Object)token.getServiceLogin());
        entry.setProperty("oauth2Token", "creationDate", (Object)token.getCreationDate());
        Framework.doPrivileged(() -> {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = ds.open(TOKEN_DIR);){
                session.updateEntry(entry);
            }
        });
        return this.getToken(provider, nxuser);
    }

    protected void deleteToken(DocumentModel token) throws RestOperationException {
        Framework.doPrivileged(() -> {
            DirectoryService ds = (DirectoryService)Framework.getService(DirectoryService.class);
            try (Session session = ds.open(TOKEN_DIR);){
                session.deleteEntry(token);
            }
        });
    }

    protected Credential getCredential(NuxeoOAuth2ServiceProvider provider, NuxeoOAuth2Token token) {
        return provider.loadCredential(provider instanceof AbstractOAuth2UserEmailProvider ? token.getServiceLogin() : token.getNuxeoLogin());
    }

    protected Response buildResponse(Response.StatusType status, Object obj) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String message = mapper.writeValueAsString(obj);
        return Response.status((Response.StatusType)status).header("Content-Length", (Object)message.getBytes("UTF-8").length).type("application/json; charset=UTF-8").entity((Object)message).build();
    }

    protected void checkPermission() throws RestOperationException {
        if (!this.hasPermission()) {
            throw new RestOperationException("You do not have permissions to perform this operation.", 403);
        }
    }

    protected boolean hasPermission() {
        return ((NuxeoPrincipal)this.getContext().getCoreSession().getPrincipal()).isAdministrator();
    }
}

