/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.listeners;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class ResizeAvatarPictureListener
implements EventListener {
    protected static final int RESIZED_IMAGE_WIDTH = 300;
    protected static final int RESIZED_IMAGE_HEIGHT = 200;
    private static final Log log = LogFactory.getLog(ResizeAvatarPictureListener.class);

    public void handleEvent(Event event) {
        Blob image;
        DocumentEventContext ctx;
        DocumentModel doc;
        if (this.isBeforeUpdate(event) && (doc = (ctx = (DocumentEventContext)event.getContext()).getSourceDocument()).hasFacet("UserProfile") && (image = (Blob)doc.getPropertyValue("userprofile:avatar")) != null) {
            this.resizeAvatar(doc, image);
        }
    }

    protected boolean isBeforeUpdate(Event event) {
        return "beforeDocumentModification".equals(event.getName()) && event.getContext() instanceof DocumentEventContext;
    }

    protected void resizeAvatar(DocumentModel doc, Blob avatarImage) throws PropertyException {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        SimpleBlobHolder bh = new SimpleBlobHolder(avatarImage);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("targetWidth", String.valueOf(300));
        parameters.put("targetHeight", String.valueOf(200));
        try {
            BlobHolder result = conversionService.convert("resizeAvatar", (BlobHolder)bh, parameters);
            if (result != null) {
                doc.setPropertyValue("userprofile:avatar", (Serializable)result.getBlob());
            }
        }
        catch (NuxeoException e) {
            log.warn((Object)"Unable to resize avatar image");
            log.debug((Object)e, (Throwable)e);
        }
    }
}

