/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDTextStream;
import org.apache.pdfbox.pdmodel.fdf.FDFField;
import org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldFactory;
import org.apache.pdfbox.util.BitFlagHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDField
implements COSObjectable {
    public static final int FLAG_READ_ONLY = 1;
    public static final int FLAG_REQUIRED = 2;
    public static final int FLAG_NO_EXPORT = 4;
    private PDAcroForm acroForm;
    private COSDictionary dictionary;

    public PDField(PDAcroForm theAcroForm) {
        this.acroForm = theAcroForm;
        this.dictionary = new COSDictionary();
    }

    public PDField(PDAcroForm theAcroForm, COSDictionary field) {
        this.acroForm = theAcroForm;
        this.dictionary = field;
    }

    public String getPartialName() {
        return this.getDictionary().getString(COSName.T);
    }

    public void setPartialName(String name) {
        this.getDictionary().setString(COSName.T, name);
    }

    public String getFullyQualifiedName() throws IOException {
        PDField parent = this.getParent();
        String parentName = null;
        if (parent != null) {
            parentName = parent.getFullyQualifiedName();
        }
        String finalName = this.getPartialName();
        if (parentName != null) {
            finalName = finalName != null ? parentName + "." + finalName : parentName;
        }
        return finalName;
    }

    public String getAlternateFieldName() {
        return this.getDictionary().getString(COSName.TU);
    }

    public void setAlternateFieldName(String alternateFieldName) {
        this.getDictionary().setString(COSName.TU, alternateFieldName);
    }

    public String getFieldType() {
        return this.getDictionary().getNameAsString(COSName.FT);
    }

    public String findFieldType() {
        return this.findFieldType(this.getDictionary());
    }

    private String findFieldType(COSDictionary dic) {
        COSDictionary parent;
        String retval = dic.getNameAsString(COSName.FT);
        if (retval == null && (parent = (COSDictionary)dic.getDictionaryObject(COSName.PARENT, COSName.P)) != null) {
            retval = this.findFieldType(parent);
        }
        return retval;
    }

    public abstract void setValue(String var1) throws IOException;

    public abstract String getValue() throws IOException;

    public void setReadonly(boolean readonly) {
        BitFlagHelper.setFlag(this.getDictionary(), COSName.FF, 1, readonly);
    }

    public boolean isReadonly() {
        return BitFlagHelper.getFlag(this.getDictionary(), COSName.FF, 1);
    }

    public void setRequired(boolean required) {
        BitFlagHelper.setFlag(this.getDictionary(), COSName.FF, 2, required);
    }

    public boolean isRequired() {
        return BitFlagHelper.getFlag(this.getDictionary(), COSName.FF, 2);
    }

    public void setNoExport(boolean noExport) {
        BitFlagHelper.setFlag(this.getDictionary(), COSName.FF, 4, noExport);
    }

    public boolean isNoExport() {
        return BitFlagHelper.getFlag(this.getDictionary(), COSName.FF, 4);
    }

    public int getFieldFlags() {
        int retval = 0;
        COSInteger ff = (COSInteger)this.getDictionary().getDictionaryObject(COSName.FF);
        if (ff != null) {
            retval = ff.intValue();
        }
        return retval;
    }

    public void setFieldFlags(int flags) {
        this.getDictionary().setInt(COSName.FF, flags);
    }

    public void importFDF(FDFField fdfField) throws IOException {
        Integer ff;
        Object fieldValue = fdfField.getValue();
        int fieldFlags = this.getFieldFlags();
        if (fieldValue != null) {
            if (fieldValue instanceof String) {
                this.setValue((String)fieldValue);
            } else if (fieldValue instanceof PDTextStream) {
                this.setValue(((PDTextStream)fieldValue).getAsString());
            } else {
                throw new IOException("Unknown field type:" + fieldValue.getClass().getName());
            }
        }
        if ((ff = fdfField.getFieldFlags()) != null) {
            this.setFieldFlags(ff);
        } else {
            Integer clrFf;
            Integer setFf = fdfField.getSetFieldFlags();
            if (setFf != null) {
                int setFfInt = setFf;
                this.setFieldFlags(fieldFlags |= setFfInt);
            }
            if ((clrFf = fdfField.getClearFieldFlags()) != null) {
                int clrFfValue = clrFf;
                this.setFieldFlags(fieldFlags &= (clrFfValue ^= 0xFFFFFFFF));
            }
        }
        PDAnnotationWidget widget = this.getWidget();
        if (widget != null) {
            int annotFlags = widget.getAnnotationFlags();
            Integer f = fdfField.getWidgetFieldFlags();
            if (f != null && widget != null) {
                widget.setAnnotationFlags(f);
            } else {
                Integer clrF;
                Integer setF = fdfField.getSetWidgetFieldFlags();
                if (setF != null) {
                    widget.setAnnotationFlags(annotFlags |= setF.intValue());
                }
                if ((clrF = fdfField.getClearWidgetFieldFlags()) != null) {
                    int clrFValue = clrF;
                    clrFValue = (int)((long)clrFValue ^ 0xFFFFFFFFL);
                    widget.setAnnotationFlags(annotFlags &= clrFValue);
                }
            }
        }
        List<FDFField> fdfKids = fdfField.getKids();
        List<COSObjectable> pdKids = this.getKids();
        for (int i = 0; fdfKids != null && i < fdfKids.size(); ++i) {
            FDFField fdfChild = fdfKids.get(i);
            String fdfName = fdfChild.getPartialFieldName();
            for (int j = 0; j < pdKids.size(); ++j) {
                COSObjectable pdChildObj = pdKids.get(j);
                if (!(pdChildObj instanceof PDField)) continue;
                PDField pdChild = (PDField)pdChildObj;
                if (fdfName == null || !fdfName.equals(pdChild.getPartialName())) continue;
                pdChild.importFDF(fdfChild);
            }
        }
    }

    public PDAnnotationWidget getWidget() throws IOException {
        COSObjectable firstKid;
        PDAnnotationWidget retval = null;
        List<COSObjectable> kids = this.getKids();
        retval = kids == null ? new PDAnnotationWidget(this.getDictionary()) : (kids.size() > 0 ? ((firstKid = kids.get(0)) instanceof PDAnnotationWidget ? (PDAnnotationWidget)firstKid : ((PDField)firstKid).getWidget()) : null);
        return retval;
    }

    public PDField getParent() throws IOException {
        PDField parent = null;
        COSDictionary parentDic = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.PARENT, COSName.P);
        if (parentDic != null) {
            parent = PDFieldFactory.createField(this.getAcroForm(), parentDic);
        }
        return parent;
    }

    public void setParent(PDField parent) {
        this.getDictionary().setItem("Parent", (COSObjectable)parent);
    }

    public PDField findKid(String[] name, int nameIndex) throws IOException {
        PDField retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            for (int i = 0; retval == null && i < kids.size(); ++i) {
                COSDictionary kidDictionary = (COSDictionary)kids.getObject(i);
                if (!name[nameIndex].equals(kidDictionary.getString("T"))) continue;
                retval = PDFieldFactory.createField(this.acroForm, kidDictionary);
                if (name.length <= nameIndex + 1) continue;
                retval = retval.findKid(name, nameIndex + 1);
            }
        }
        return retval;
    }

    public List<COSObjectable> getKids() throws IOException {
        COSArrayList retval = null;
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<COSObjectable> kidsList = new ArrayList<COSObjectable>();
            for (int i = 0; i < kids.size(); ++i) {
                COSDictionary kidDictionary = (COSDictionary)kids.getObject(i);
                if (kidDictionary == null) continue;
                if (kidDictionary.getDictionaryObject(COSName.T) != null) {
                    PDField field = PDFieldFactory.createField(this.acroForm, kidDictionary);
                    if (field == null) continue;
                    kidsList.add(field);
                    continue;
                }
                if (!"Widget".equals(kidDictionary.getNameAsString(COSName.SUBTYPE))) continue;
                kidsList.add(new PDAnnotationWidget(kidDictionary));
            }
            retval = new COSArrayList(kidsList, kids);
        }
        return retval;
    }

    public void setKids(List<COSObjectable> kids) {
        COSArray kidsArray = COSArrayList.converterToCOSArray(kids);
        this.getDictionary().setItem(COSName.KIDS, (COSBase)kidsArray);
    }

    public String toString() {
        return "" + this.getDictionary().getDictionaryObject(COSName.V);
    }

    public PDAcroForm getAcroForm() {
        return this.acroForm;
    }

    public void setAcroForm(PDAcroForm value) {
        this.acroForm = value;
    }

    public COSDictionary getDictionary() {
        return this.dictionary;
    }

    @Override
    public COSBase getCOSObject() {
        return this.dictionary;
    }

    public PDFormFieldAdditionalActions getActions() {
        COSDictionary aa = (COSDictionary)this.dictionary.getDictionaryObject(COSName.AA);
        PDFormFieldAdditionalActions retval = null;
        if (aa != null) {
            retval = new PDFormFieldAdditionalActions(aa);
        }
        return retval;
    }

    public void setActions(PDFormFieldAdditionalActions actions) {
        this.dictionary.setItem(COSName.AA, (COSObjectable)actions);
    }

    protected void setFieldType(String fieldType) {
        if (fieldType.compareTo("Btn") != 0 && fieldType.compareTo("Ch") != 0 && fieldType.compareTo("Tx") != 0 && fieldType.compareTo("Sig") != 0) {
            throw new IllegalArgumentException("Unknown field type given " + fieldType);
        }
        this.getDictionary().setName(COSName.FT, fieldType);
    }
}

