/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.runtime.api.Framework;

public final class TaskEventNotificationHelper {
    private static final Log log = LogFactory.getLog(TaskEventNotificationHelper.class);

    public static void notifyEvent(CoreSession coreSession, DocumentModel document, NuxeoPrincipal principal, Task task, String eventId, Map<String, Serializable> properties, String comment, String category) {
        EventContextImpl eventContext;
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (properties == null) {
            properties = new HashMap<String, Serializable>();
        }
        if (document != null) {
            properties.put("repositoryName", (Serializable)((Object)document.getRepositoryName()));
            properties.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
            properties.put("documentLifeCycle", (Serializable)((Object)document.getCurrentLifeCycleState()));
            eventContext = new DocumentEventContext(coreSession, (Principal)principal, document);
        } else {
            eventContext = new EventContextImpl(coreSession, (Principal)principal);
        }
        properties.put("comment", (Serializable)((Object)comment));
        properties.put("category", (Serializable)((Object)category));
        properties.put("taskInstance", (Serializable)task);
        String disableNotif = task.getVariable("disableNotificationService");
        if (disableNotif != null && Boolean.TRUE.equals(Boolean.valueOf(disableNotif))) {
            properties.put("disableNotificationService", Boolean.TRUE);
        }
        eventContext.setProperties(properties);
        Event event = eventContext.newEvent(eventId);
        TaskEventNotificationHelper.getEventProducer().fireEvent(event);
    }

    public static void notifyTaskEnded(CoreSession coreSession, NuxeoPrincipal principal, Task task, String comment, String eventName, Map<String, Serializable> extraEventProperties) {
        ArrayList<String> docIds = new ArrayList<String>();
        docIds.addAll(task.getTargetDocumentsIds());
        String docIdVar = task.getVariable(TaskService.VariableName.documentId.name());
        if (!docIds.contains(docIdVar)) {
            docIds.add(docIdVar);
        }
        String docRepo = task.getVariable(TaskService.VariableName.documentRepositoryName.name());
        ArrayList<DocumentModel> documents = new ArrayList<DocumentModel>();
        if (coreSession.getRepositoryName().equals(docRepo)) {
            try {
                for (String id : docIds) {
                    DocumentModel document = coreSession.getDocument((DocumentRef)new IdRef(id));
                    documents.add(document);
                }
            }
            catch (DocumentNotFoundException e) {
                log.error((Object)String.format("Could not fetch document with id '%s:(%s)' for notification", docRepo, docIds), (Throwable)e);
            }
        } else {
            log.error((Object)String.format("Could not resolve document for notification: document is on repository '%s' and given session is on repository '%s'", docRepo, coreSession.getRepositoryName()));
        }
        HashMap<String, Serializable> eventProperties = new HashMap<String, Serializable>();
        ArrayList<String> notificationRecipients = new ArrayList<String>();
        notificationRecipients.add(task.getInitiator());
        notificationRecipients.addAll(task.getActors());
        eventProperties.put("recipients", notificationRecipients);
        if (extraEventProperties != null) {
            eventProperties.putAll(extraEventProperties);
        }
        boolean taskEndedByDelegatedActor = task.getDelegatedActors() != null && task.getDelegatedActors().contains(principal.getName());
        for (DocumentModel doc : documents) {
            TaskEventNotificationHelper.notifyEvent(coreSession, doc, principal, task, eventName, eventProperties, comment, null);
            if (!taskEndedByDelegatedActor) continue;
            TaskEventNotificationHelper.notifyEvent(coreSession, doc, principal, task, eventName, eventProperties, String.format("Task ended by an delegated actor '%s' ", principal.getName()) + (!StringUtils.isEmpty((String)comment) ? " with the following comment: " + comment : ""), null);
        }
    }

    public static EventProducer getEventProducer() {
        return (EventProducer)Framework.getLocalService(EventProducer.class);
    }
}

