/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.extension;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;

public class AutomationRenderer {
    protected static final Log log = LogFactory.getLog(AutomationRenderer.class);
    private static final String VARIANT_POLICY_USER = "user";

    public static boolean isRenditionAvailable(DocumentModel doc, RenditionDefinition def) {
        String chain = def.getOperationChain();
        if (chain == null) {
            log.error((Object)"Can not run Automation rendition if chain is not defined");
            return false;
        }
        AutomationService as = (AutomationService)Framework.getLocalService(AutomationService.class);
        try {
            if (as.getOperation(chain) == null) {
                log.error((Object)("Chain " + chain + " is not defined : rendition can not be used"));
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to test Rendition availability", (Throwable)e);
            return false;
        }
        if (!def.isEmptyBlobAllowed()) {
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh == null) {
                return false;
            }
            try {
                Blob blob = bh.getBlob();
                if (blob == null) {
                    return false;
                }
            }
            catch (Exception e) {
                log.error((Object)"Unable to get Blob to test Rendition availability", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Blob> render(DocumentModel doc, RenditionDefinition definition, CoreSession session) {
        chain = definition.getOperationChain();
        if (chain == null) {
            throw new NuxeoException("no operation defined");
        }
        if (session == null) {
            session = doc.getCoreSession();
        }
        as = (AutomationService)Framework.getLocalService(AutomationService.class);
        oc = new OperationContext(session);
        var6_7 = null;
        try {
            oc.push("document", (Object)doc);
            bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (bh != null) {
                try {
                    blob = bh.getBlob();
                    if (blob == null) ** GOTO lbl26
                    oc.push("blob", (Object)blob);
                }
                catch (Exception e) {
                    if (definition.isEmptyBlobAllowed()) ** GOTO lbl26
                    throw new NuxeoException("No Blob available", (Throwable)e);
                }
            } else if (!definition.isEmptyBlobAllowed()) {
                throw new NuxeoException("No Blob available");
            }
lbl26:
            // 5 sources

            blob = (Blob)as.run(oc, definition.getOperationChain());
            if (blob != null && StringUtils.isBlank((String)blob.getFilename())) {
                filename = AutomationRenderer.getFilenameWithExtension(doc.getTitle(), blob.getMimeType(), "bin");
                blob.setFilename(filename);
            }
            blobs = new ArrayList<Blob>();
            blobs.add(blob);
            var10_13 = blobs;
            return var10_13;
        }
        catch (Throwable var7_9) {
            var6_7 = var7_9;
            throw var7_9;
        }
        finally {
            if (oc != null) {
                if (var6_7 != null) {
                    try {
                        oc.close();
                    }
                    catch (Throwable var11_14) {
                        var6_7.addSuppressed(var11_14);
                    }
                } else {
                    oc.close();
                }
            }
        }
        {
            catch (Exception e) {
                throw new NuxeoException("Exception while running the operation chain: " + definition.getOperationChain(), (Throwable)e);
            }
        }
    }

    public static String getVariant(DocumentModel doc, RenditionDefinition definition) {
        if (VARIANT_POLICY_USER.equals(definition.getVariantPolicy())) {
            NuxeoPrincipal principal = (NuxeoPrincipal)doc.getCoreSession().getPrincipal();
            if (principal.isAdministrator()) {
                return "administratoruser:";
            }
            return "user:" + principal.getName();
        }
        return null;
    }

    public static String getFilenameWithExtension(String filename, String mimeType, String defaultExtension) {
        String baseName = FilenameUtils.getBaseName((String)filename);
        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
        MimetypeEntry mimeTypeEntry = mimetypeRegistry.getMimetypeEntryByMimeType(mimeType);
        List extensions = mimeTypeEntry.getExtensions();
        String extension = !extensions.isEmpty() ? (String)extensions.get(0) : defaultExtension;
        return extension == null ? filename : baseName + "." + extension;
    }
}

