/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.lazy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.lazy.AbstractLazyCachableRenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.rendition.service.RenditionServiceImpl;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractRenditionBuilderWork
extends TransientStoreWork {
    private static final long serialVersionUID = 1L;
    protected String key;
    protected final DocumentRef docRef;
    protected final String repositoryName;
    protected final String renditionName;
    protected static Log log = LogFactory.getLog(AbstractRenditionBuilderWork.class);
    public static final String CATEGORY = "renditionBuilder";

    public AbstractRenditionBuilderWork(String key, DocumentModel doc, RenditionDefinition def) {
        this.key = key;
        this.docRef = doc.getRef();
        this.repositoryName = doc.getRepositoryName();
        this.renditionName = def.getName();
        this.setOriginatingUsername(doc.getCoreSession().getPrincipal().getName());
        this.id = this.buildId(doc, def);
    }

    protected String buildId(DocumentModel doc, RenditionDefinition def) {
        StringBuffer sb = new StringBuffer("rendition:");
        sb.append(doc.getId());
        String variant = def.getProvider().getVariant(doc, def);
        if (variant != null) {
            sb.append("::");
            sb.append(variant);
        }
        sb.append("::");
        sb.append(def.getName());
        return sb.toString();
    }

    public String getTitle() {
        return "Lazy Rendition for " + this.renditionName + " on " + this.docRef.toString() + " on behalf of " + this.originatingUsername;
    }

    public String getCategory() {
        return CATEGORY;
    }

    protected String getTransientStoreName() {
        return "LazyRenditionCache";
    }

    public void work() {
        String rendKey;
        this.openUserSession();
        DocumentModel doc = this.session.getDocument(this.docRef);
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition def = ((RenditionServiceImpl)rs).getRenditionDefinition(this.renditionName);
        RenditionProvider renditionProvider = def.getProvider();
        if (renditionProvider instanceof AbstractLazyCachableRenditionProvider && !(rendKey = ((AbstractLazyCachableRenditionProvider)renditionProvider).buildRenditionKey(doc, def)).equals(this.key)) {
            this.refreshStoreEntry(rendKey);
            this.key = rendKey;
        }
        List<Blob> blobs = this.doComputeRendition(this.session, doc, def);
        this.updateAndCompleteStoreEntry(blobs);
    }

    public void cleanUp(boolean ok, Exception e) {
        super.cleanUp(ok, e);
        if (ok) {
            return;
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        StringBlob emptyBlob = new StringBlob("");
        emptyBlob.setFilename("error");
        emptyBlob.setMimeType("text/plain;error=true");
        blobs.add((Blob)emptyBlob);
        this.updateAndCompleteStoreEntry(blobs);
    }

    void refreshStoreEntry(String renditionKey) {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(this.getTransientStoreName());
        if (ts.exists(this.key)) {
            ts.release(this.key);
        }
        ts.putParameter(renditionKey, "workerid", (Serializable)((Object)this.getId()));
        ArrayList<StringBlob> blobs = new ArrayList<StringBlob>();
        StringBlob emptyBlob = new StringBlob("");
        emptyBlob.setFilename("inprogress");
        emptyBlob.setMimeType("text/plain;empty=true");
        blobs.add(emptyBlob);
        ts.putBlobs(renditionKey, blobs);
    }

    void updateAndCompleteStoreEntry(List<Blob> blobs) {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(this.getTransientStoreName());
        if (!ts.exists(this.key)) {
            throw new NuxeoException("Rendition TransientStore entry can not be null");
        }
        ts.putBlobs(this.key, blobs);
        ts.setCompleted(this.key, true);
    }

    protected abstract List<Blob> doComputeRendition(CoreSession var1, DocumentModel var2, RenditionDefinition var3);
}

