/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.extension.DefaultAutomationRenditionProvider;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.impl.LiveRendition;
import org.nuxeo.ecm.platform.rendition.impl.StoredRendition;
import org.nuxeo.ecm.platform.rendition.service.DefaultStoredRenditionManager;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProviderDescriptor;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionProviderRegistry;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinitionRegistry;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.rendition.service.StoredRenditionManager;
import org.nuxeo.ecm.platform.rendition.service.StoredRenditionManagerDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class RenditionServiceImpl
extends DefaultComponent
implements RenditionService {
    public static final String RENDITION_DEFINITIONS_EP = "renditionDefinitions";
    public static final String RENDITON_DEFINION_PROVIDERS_EP = "renditionDefinitionProviders";
    public static final String STORED_RENDITION_MANAGERS_EP = "storedRenditionManagers";
    private static final Log log = LogFactory.getLog(RenditionServiceImpl.class);
    @Deprecated
    protected AutomationService automationService;
    @Deprecated
    protected Map<String, RenditionDefinition> renditionDefinitions;
    protected RenditionDefinitionRegistry renditionDefinitionRegistry;
    protected RenditionDefinitionProviderRegistry renditionDefinitionProviderRegistry;
    protected static final StoredRenditionManager DEFAULT_STORED_RENDITION_MANAGER = new DefaultStoredRenditionManager();
    protected Deque<StoredRenditionManagerDescriptor> storedRenditionManagerDescriptors = new LinkedList<StoredRenditionManagerDescriptor>();

    public StoredRenditionManager getStoredRenditionManager() {
        StoredRenditionManagerDescriptor descr = this.storedRenditionManagerDescriptors.peekLast();
        return descr == null ? DEFAULT_STORED_RENDITION_MANAGER : descr.getStoredRenditionManager();
    }

    public void activate(ComponentContext context) {
        this.renditionDefinitions = new HashMap<String, RenditionDefinition>();
        this.renditionDefinitionRegistry = new RenditionDefinitionRegistry();
        this.renditionDefinitionProviderRegistry = new RenditionDefinitionProviderRegistry();
        super.activate(context);
    }

    public void deactivate(ComponentContext context) {
        this.renditionDefinitions = null;
        this.renditionDefinitionRegistry = null;
        this.renditionDefinitionProviderRegistry = null;
        super.deactivate(context);
    }

    public RenditionDefinition getRenditionDefinition(String name) {
        return this.renditionDefinitionRegistry.getRenditionDefinition(name);
    }

    @Deprecated
    public List<RenditionDefinition> getDeclaredRenditionDefinitions() {
        return new ArrayList<RenditionDefinition>(this.renditionDefinitionRegistry.descriptors.values());
    }

    @Deprecated
    public List<RenditionDefinition> getDeclaredRenditionDefinitionsForProviderType(String providerType) {
        ArrayList<RenditionDefinition> defs = new ArrayList<RenditionDefinition>();
        for (RenditionDefinition def : this.getDeclaredRenditionDefinitions()) {
            if (!def.getProviderType().equals(providerType)) continue;
            defs.add(def);
        }
        return defs;
    }

    public List<RenditionDefinition> getAvailableRenditionDefinitions(DocumentModel doc) {
        ArrayList<RenditionDefinition> defs = new ArrayList<RenditionDefinition>();
        defs.addAll(this.renditionDefinitionRegistry.getRenditionDefinitions(doc));
        defs.addAll(this.renditionDefinitionProviderRegistry.getRenditionDefinitions(doc));
        return defs;
    }

    public DocumentRef storeRendition(DocumentModel source, String renditionDefinitionName) {
        Rendition rendition = this.getRendition(source, renditionDefinitionName, true);
        return rendition == null ? null : rendition.getHostDocument().getRef();
    }

    @Deprecated
    protected DocumentModel storeRendition(DocumentModel sourceDocument, Rendition rendition, String name) {
        StoredRendition storedRendition = this.storeRendition(sourceDocument, rendition);
        return storedRendition == null ? null : storedRendition.getHostDocument();
    }

    protected StoredRendition storeRendition(DocumentModel sourceDocument, Rendition rendition) {
        if (!rendition.isCompleted()) {
            return null;
        }
        List renderedBlobs = rendition.getBlobs();
        Blob renderedBlob = (Blob)renderedBlobs.get(0);
        String mimeType = renderedBlob.getMimeType();
        if (mimeType != null && mimeType.contains("error=true")) {
            return null;
        }
        CoreSession session = sourceDocument.getCoreSession();
        DocumentModel version = null;
        boolean isVersionable = sourceDocument.isVersionable();
        if (isVersionable) {
            DocumentRef versionRef = this.createVersionIfNeeded(sourceDocument, session);
            version = session.getDocument(versionRef);
        }
        RenditionDefinition renditionDefinition = this.getRenditionDefinition(rendition.getName());
        StoredRendition storedRendition = this.getStoredRenditionManager().createStoredRendition(sourceDocument, version, renderedBlob, renditionDefinition);
        return storedRendition;
    }

    protected DocumentRef createVersionIfNeeded(DocumentModel source, CoreSession session) {
        if (source.isVersionable()) {
            if (source.isVersion()) {
                return source.getRef();
            }
            if (source.isCheckedOut()) {
                DocumentRef versionRef = session.checkIn(source.getRef(), VersioningOption.MINOR, null);
                source.refresh(1, null);
                return versionRef;
            }
            return session.getLastDocumentVersionRef(source.getRef());
        }
        return null;
    }

    @Deprecated
    protected AutomationService getAutomationService() {
        return (AutomationService)Framework.getService(AutomationService.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RENDITION_DEFINITIONS_EP.equals(extensionPoint)) {
            RenditionDefinition renditionDefinition = (RenditionDefinition)contribution;
            this.renditionDefinitionRegistry.addContribution(renditionDefinition);
        } else if (RENDITON_DEFINION_PROVIDERS_EP.equals(extensionPoint)) {
            this.renditionDefinitionProviderRegistry.addContribution((RenditionDefinitionProviderDescriptor)contribution);
        } else if (STORED_RENDITION_MANAGERS_EP.equals(extensionPoint)) {
            this.storedRenditionManagerDescriptors.add((StoredRenditionManagerDescriptor)contribution);
        }
    }

    @Deprecated
    protected void registerRendition(RenditionDefinition renditionDefinition) {
        String name = renditionDefinition.getName();
        if (name == null) {
            log.error((Object)"Cannot register rendition without a name");
            return;
        }
        boolean enabled = renditionDefinition.isEnabled();
        if (this.renditionDefinitions.containsKey(name)) {
            log.info((Object)("Overriding rendition with name: " + name));
            if (enabled) {
                renditionDefinition = this.mergeRenditions(this.renditionDefinitions.get(name), renditionDefinition);
            } else {
                log.info((Object)("Disabled rendition with name " + name));
                this.renditionDefinitions.remove(name);
            }
        }
        if (enabled) {
            log.info((Object)("Registering rendition with name: " + name));
            this.renditionDefinitions.put(name, renditionDefinition);
        }
        this.setupProvider(renditionDefinition);
    }

    @Deprecated
    protected void setupProvider(RenditionDefinition definition) {
        if (definition.getProviderClass() == null) {
            definition.setProvider((RenditionProvider)new DefaultAutomationRenditionProvider());
        } else {
            try {
                RenditionProvider provider = (RenditionProvider)definition.getProviderClass().newInstance();
                definition.setProvider(provider);
            }
            catch (Exception e) {
                log.error((Object)"Unable to create RenditionProvider", (Throwable)e);
            }
        }
    }

    protected RenditionDefinition mergeRenditions(RenditionDefinition oldRenditionDefinition, RenditionDefinition newRenditionDefinition) {
        String operationChain;
        String label = newRenditionDefinition.getLabel();
        if (label != null) {
            oldRenditionDefinition.label = label;
        }
        if ((operationChain = newRenditionDefinition.getOperationChain()) != null) {
            oldRenditionDefinition.operationChain = operationChain;
        }
        return oldRenditionDefinition;
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (RENDITION_DEFINITIONS_EP.equals(extensionPoint)) {
            this.renditionDefinitionRegistry.removeContribution((RenditionDefinition)contribution);
        } else if (RENDITON_DEFINION_PROVIDERS_EP.equals(extensionPoint)) {
            this.renditionDefinitionProviderRegistry.removeContribution((RenditionDefinitionProviderDescriptor)contribution);
        } else if (STORED_RENDITION_MANAGERS_EP.equals(extensionPoint)) {
            this.storedRenditionManagerDescriptors.remove((StoredRenditionManagerDescriptor)contribution);
        }
    }

    @Deprecated
    protected void unregisterRendition(RenditionDefinition renditionDefinition) {
        String name = renditionDefinition.getName();
        this.renditionDefinitions.remove(name);
        log.info((Object)("Unregistering rendition with name: " + name));
    }

    public Rendition getRendition(DocumentModel doc, String renditionName) {
        RenditionDefinition renditionDefinition = this.getAvailableRenditionDefinition(doc, renditionName);
        return this.getRendition(doc, renditionDefinition, renditionDefinition.isStoreByDefault());
    }

    public Rendition getRendition(DocumentModel doc, String renditionName, boolean store) {
        RenditionDefinition renditionDefinition = this.getAvailableRenditionDefinition(doc, renditionName);
        return this.getRendition(doc, renditionDefinition, store);
    }

    protected Rendition getRendition(DocumentModel doc, RenditionDefinition renditionDefinition, boolean store) {
        StoredRendition storedRendition;
        StoredRendition rendition = null;
        boolean isVersionable = doc.isVersionable();
        if (!(isVersionable && doc.isCheckedOut() || (rendition = this.getStoredRenditionManager().findStoredRendition(doc, renditionDefinition)) == null)) {
            return rendition;
        }
        rendition = new LiveRendition(doc, renditionDefinition);
        if (store && (storedRendition = this.storeRendition(doc, (Rendition)rendition)) != null) {
            return storedRendition;
        }
        return rendition;
    }

    protected RenditionDefinition getAvailableRenditionDefinition(DocumentModel doc, String renditionName) {
        RenditionDefinition renditionDefinition = this.renditionDefinitionRegistry.getRenditionDefinition(renditionName);
        if (renditionDefinition == null) {
            renditionDefinition = this.renditionDefinitionProviderRegistry.getRenditionDefinition(renditionName, doc);
            if (renditionDefinition == null) {
                String message = "The rendition definition '%s' is not registered";
                throw new NuxeoException(String.format(message, renditionName));
            }
        } else if (!this.renditionDefinitionRegistry.canUseRenditionDefinition(renditionDefinition, doc)) {
            throw new NuxeoException("Rendition " + renditionName + " cannot be used for this doc " + doc.getId());
        }
        if (!renditionDefinition.getProvider().isAvailable(doc, renditionDefinition)) {
            throw new NuxeoException("Rendition " + renditionName + " not available for this doc " + doc.getId());
        }
        return renditionDefinition;
    }

    public List<Rendition> getAvailableRenditions(DocumentModel doc) {
        return this.getAvailableRenditions(doc, false);
    }

    public List<Rendition> getAvailableRenditions(DocumentModel doc, boolean onlyVisible) {
        ArrayList<Rendition> renditions = new ArrayList<Rendition>();
        if (doc.isProxy()) {
            return renditions;
        }
        List<RenditionDefinition> defs = this.getAvailableRenditionDefinitions(doc);
        if (defs != null) {
            for (RenditionDefinition def : defs) {
                Rendition rendition;
                if (onlyVisible && (!onlyVisible || !def.isVisible()) || (rendition = this.getRendition(doc, def.getName(), false)) == null) continue;
                renditions.add(rendition);
            }
        }
        return renditions;
    }

    public void deleteStoredRenditions(String repositoryName) {
        StoredRenditionsCleaner cleaner = new StoredRenditionsCleaner(repositoryName);
        cleaner.runUnrestricted();
    }

    private final class StoredRenditionsCleaner
    extends UnrestrictedSessionRunner {
        private static final int BATCH_SIZE = 100;

        private StoredRenditionsCleaner(String repositoryName) {
            super(repositoryName);
        }

        public void run() {
            Map<String, List<String>> sourceIdToRenditionRefs = this.computeLiveDocumentRefsToRenditionRefs();
            this.removeStoredRenditions(sourceIdToRenditionRefs);
        }

        private Map<String, List<String>> computeLiveDocumentRefsToRenditionRefs() {
            HashMap<String, List<String>> liveDocumentRefsToRenditionRefs = new HashMap<String, List<String>>();
            String query = String.format("SELECT %s, %s, %s FROM Document WHERE %s IS NOT NULL AND ecm:isVersion = 0", "ecm:uuid", "rend:sourceId", "rend:sourceVersionableId", "rend:sourceId");
            try (IterableQueryResult result = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                for (Map res : result) {
                    String renditionRef = ((Serializable)res.get("ecm:uuid")).toString();
                    String sourceId = ((Serializable)res.get("rend:sourceId")).toString();
                    Serializable sourceVersionableId = (Serializable)res.get("rend:sourceVersionableId");
                    String key = sourceVersionableId != null ? sourceVersionableId.toString() : sourceId;
                    liveDocumentRefsToRenditionRefs.computeIfAbsent(key, k -> new ArrayList()).add(renditionRef);
                }
            }
            return liveDocumentRefsToRenditionRefs;
        }

        private void removeStoredRenditions(Map<String, List<String>> liveDocumentRefsToRenditionRefs) {
            ArrayList<String> liveDocumentRefs = new ArrayList<String>(liveDocumentRefsToRenditionRefs.keySet());
            if (liveDocumentRefs.isEmpty()) {
                return;
            }
            for (int processedSourceIds = 0; processedSourceIds < liveDocumentRefs.size(); processedSourceIds += 100) {
                int limit = processedSourceIds + 100 > liveDocumentRefs.size() ? liveDocumentRefs.size() : processedSourceIds + 100;
                List batchSourceIds = liveDocumentRefs.subList(processedSourceIds, limit);
                ArrayList existingSourceIds = new ArrayList();
                String query = NXQLQueryBuilder.getQuery((String)"SELECT ecm:uuid FROM Document WHERE ecm:uuid IN ?", (Object[])new Object[]{batchSourceIds}, (boolean)true, (boolean)true, null, (SortInfo[])new SortInfo[0]);
                try (IterableQueryResult result = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
                    result.forEach(res -> existingSourceIds.add(((Serializable)res.get("ecm:uuid")).toString()));
                }
                batchSourceIds.removeAll(existingSourceIds);
                List renditionRefsToDelete = batchSourceIds.stream().map(liveDocumentRefsToRenditionRefs::get).reduce(new ArrayList(), (allRefs, refs) -> {
                    allRefs.addAll(refs);
                    return allRefs;
                });
                if (!renditionRefsToDelete.isEmpty()) {
                    this.session.removeDocuments(renditionRefsToDelete.stream().map(IdRef::new).collect(Collectors.toList()).toArray(new DocumentRef[renditionRefsToDelete.size()]));
                }
                if (!TransactionHelper.isTransactionActiveOrMarkedRollback()) continue;
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
        }
    }
}

