/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.util.Arrays;
import java.util.List;
import redis.clients.jedis.Client;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.exceptions.JedisException;

public abstract class BinaryJedisPubSub {
    private int subscribedChannels = 0;
    private Client client;

    public void onMessage(byte[] channel, byte[] message) {
    }

    public void onPMessage(byte[] pattern, byte[] channel, byte[] message) {
    }

    public void onSubscribe(byte[] channel, int subscribedChannels) {
    }

    public void onUnsubscribe(byte[] channel, int subscribedChannels) {
    }

    public void onPUnsubscribe(byte[] pattern, int subscribedChannels) {
    }

    public void onPSubscribe(byte[] pattern, int subscribedChannels) {
    }

    public void unsubscribe() {
        this.client.unsubscribe();
        this.client.flush();
    }

    public void unsubscribe(byte[] ... channels) {
        this.client.unsubscribe(channels);
        this.client.flush();
    }

    public void subscribe(byte[] ... channels) {
        this.client.subscribe(channels);
        this.client.flush();
    }

    public void psubscribe(byte[] ... patterns) {
        this.client.psubscribe(patterns);
        this.client.flush();
    }

    public void punsubscribe() {
        this.client.punsubscribe();
        this.client.flush();
    }

    public void punsubscribe(byte[] ... patterns) {
        this.client.punsubscribe(patterns);
        this.client.flush();
    }

    public boolean isSubscribed() {
        return this.subscribedChannels > 0;
    }

    public void proceedWithPatterns(Client client, byte[] ... patterns) {
        this.client = client;
        client.psubscribe(patterns);
        this.process(client);
    }

    public void proceed(Client client, byte[] ... channels) {
        this.client = client;
        client.subscribe(channels);
        this.process(client);
    }

    private void process(Client client) {
        do {
            byte[] bpattern;
            byte[] bchannel;
            List<Object> reply;
            Object firstObj;
            if (!((firstObj = (reply = client.getObjectMultiBulkReply()).get(0)) instanceof byte[])) {
                throw new JedisException("Unknown message type: " + firstObj);
            }
            byte[] resp = (byte[])firstObj;
            if (Arrays.equals(Protocol.Keyword.SUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                this.onSubscribe(bchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.UNSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bchannel = (byte[])reply.get(1);
                this.onUnsubscribe(bchannel, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.MESSAGE.raw, resp)) {
                bchannel = (byte[])reply.get(1);
                byte[] bmesg = (byte[])reply.get(2);
                this.onMessage(bchannel, bmesg);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PMESSAGE.raw, resp)) {
                bpattern = (byte[])reply.get(1);
                byte[] bchannel2 = (byte[])reply.get(2);
                byte[] bmesg = (byte[])reply.get(3);
                this.onPMessage(bpattern, bchannel2, bmesg);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                this.onPSubscribe(bpattern, this.subscribedChannels);
                continue;
            }
            if (Arrays.equals(Protocol.Keyword.PUNSUBSCRIBE.raw, resp)) {
                this.subscribedChannels = ((Long)reply.get(2)).intValue();
                bpattern = (byte[])reply.get(1);
                this.onPUnsubscribe(bpattern, this.subscribedChannels);
                continue;
            }
            throw new JedisException("Unknown message type: " + firstObj);
        } while (this.isSubscribed());
    }

    public int getSubscribedChannels() {
        return this.subscribedChannels;
    }
}

