/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.io.services;

import org.nuxeo.ecm.automation.io.services.codec.CodecDescriptor;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodecService;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class IOComponent
extends DefaultComponent {
    protected static final String XP_CODECS = "codecs";
    private JsonFactoryManager jsonFactoryManager;
    private ObjectCodecService codecs;

    public void activate(ComponentContext context) {
        this.jsonFactoryManager = (JsonFactoryManager)Framework.getLocalService(JsonFactoryManager.class);
        this.codecs = new ObjectCodecService(this.jsonFactoryManager.getJsonFactory());
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_CODECS.equals(extensionPoint)) {
            CodecDescriptor codec = (CodecDescriptor)contribution;
            this.codecs.addCodec(codec.newInstance());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_CODECS.equals(extensionPoint)) {
            CodecDescriptor codec = (CodecDescriptor)contribution;
            this.codecs.removeCodec(codec.newInstance().getJavaType());
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ObjectCodecService.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.codecs);
        }
        if (JsonFactoryManager.class.isAssignableFrom(adapter)) {
            return adapter.cast(this.jsonFactoryManager);
        }
        return null;
    }

    public void start(ComponentContext context) {
        this.codecs.postInit();
    }
}

