/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.ui.web.auth.digest;

import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.api.login.UserIdentificationInfo;
import org.nuxeo.ecm.platform.login.BaseLoginModule;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class DigestLoginPlugin
extends BaseLoginModule {
    private static final Log log = LogFactory.getLog(DigestLoginPlugin.class);
    protected static final String REALM = "realm";
    protected static final String HTTP_METHOD = "httpMethod";
    protected static final String URI = "uri";
    protected static final String QOP = "qop";
    protected static final String NONCE = "nonce";
    protected static final String NC = "nc";
    protected static final String CNONCE = "cnonce";
    protected static final String PASSWORD_FIELD = "passwordField";

    public Boolean initLoginModule() {
        return Boolean.TRUE;
    }

    public String validatedUserIdentity(UserIdentificationInfo userIdent) {
        try {
            String storedHA1 = this.getStoredHA1(userIdent.getUserName());
            if (StringUtils.isEmpty((String)storedHA1)) {
                log.warn((Object)"Digest authentication failed. Stored HA1 is empty");
                return null;
            }
            Map loginParameters = userIdent.getLoginParameters();
            String generateDigest = DigestLoginPlugin.generateDigest(storedHA1, (String)loginParameters.get(HTTP_METHOD), (String)loginParameters.get(URI), (String)loginParameters.get(QOP), (String)loginParameters.get(NONCE), (String)loginParameters.get(NC), (String)loginParameters.get(CNONCE));
            if (generateDigest.equals(userIdent.getPassword())) {
                return userIdent.getUserName();
            }
            log.warn((Object)("Digest authentication failed for user: " + userIdent.getUserName() + " realm: " + (String)loginParameters.get(REALM)));
            return null;
        }
        catch (IllegalArgumentException | DirectoryException e) {
            log.error((Object)"Digest authentication failed", e);
            return null;
        }
    }

    public static String generateDigest(String ha1, String httpMethod, String uri, String qop, String nonce, String nc, String cnonce) throws IllegalArgumentException {
        String digest;
        String a2 = httpMethod + ":" + uri;
        String ha2 = DigestUtils.md5Hex((String)a2);
        if (qop == null) {
            digest = ha1 + ":" + nonce + ":" + ha2;
        } else if ("auth".equals(qop)) {
            digest = ha1 + ":" + nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + ha2;
        } else {
            throw new IllegalArgumentException("This method does not support a qop: '" + qop + "'");
        }
        return DigestUtils.md5Hex((String)digest);
    }

    public static String encodeDigestAuthPassword(String username, String realm, String password) {
        String a1 = username + ":" + realm + ":" + password;
        return DigestUtils.md5Hex((String)a1);
    }

    protected String getStoredHA1(String username) throws DirectoryException {
        UserManager userManager = (UserManager)Framework.getService(UserManager.class);
        String dirName = userManager.getDigestAuthDirectory();
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        Directory directory = directoryService.getDirectory(dirName);
        if (directory == null) {
            throw new IllegalArgumentException("Digest Auth directory not found: " + dirName);
        }
        try (Session dir = directoryService.open(dirName);){
            dir.setReadAllColumns(true);
            String schema = directoryService.getDirectorySchema(dirName);
            DocumentModel entry = dir.getEntry(username, true);
            String passwordField = this.parameters.containsKey(PASSWORD_FIELD) ? (String)this.parameters.get(PASSWORD_FIELD) : dir.getPasswordField();
            String string = entry == null ? null : (String)entry.getProperty(schema, passwordField);
            return string;
        }
    }
}

