/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.wro.provider;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.web.resources.api.Processor;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.ecm.web.resources.wro.provider.NuxeoUriLocator;
import org.nuxeo.runtime.api.Framework;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.provider.ConfigurableProviderSupport;

public class NuxeoConfigurableProvider
extends ConfigurableProviderSupport {
    private static final Log log = LogFactory.getLog(NuxeoConfigurableProvider.class);
    public static final String PRE_TYPE = "wroPre";
    public static final String POST_TYPE = "wroPost";

    public Map<String, UriLocator> provideLocators() {
        HashMap<String, UriLocator> map = new HashMap<String, UriLocator>();
        map.put("nuxeoUri", new NuxeoUriLocator());
        return map;
    }

    public Map<String, ResourcePreProcessor> providePreProcessors() {
        HashMap<String, ResourcePreProcessor> map = new HashMap<String, ResourcePreProcessor>();
        List<Processor> processors = NuxeoConfigurableProvider.resolveProcessors(PRE_TYPE);
        for (Processor p : processors) {
            Class klass = p.getTargetProcessorClass();
            if (klass == null) continue;
            try {
                ResourcePreProcessor proc = (ResourcePreProcessor)klass.newInstance();
                map.put(p.getName(), proc);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Caught error when instanciating resource pre processor", (Throwable)e);
            }
        }
        return map;
    }

    public Map<String, ResourcePostProcessor> providePostProcessors() {
        HashMap<String, ResourcePostProcessor> map = new HashMap<String, ResourcePostProcessor>();
        List<Processor> processors = NuxeoConfigurableProvider.resolveProcessors(POST_TYPE);
        for (Processor p : processors) {
            Class klass = p.getTargetProcessorClass();
            if (klass == null) continue;
            try {
                ResourcePostProcessor proc = (ResourcePostProcessor)klass.newInstance();
                map.put(p.getName(), proc);
            }
            catch (ReflectiveOperationException e) {
                log.error((Object)"Caught error when instanciating resource post processor", (Throwable)e);
            }
        }
        return map;
    }

    public static List<Processor> resolveProcessors(String type) {
        WebResourceManager service = (WebResourceManager)Framework.getService(WebResourceManager.class);
        List processors = service.getProcessors(type);
        if (processors != null) {
            return processors;
        }
        return Collections.emptyList();
    }
}

