/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.pubsub;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.pubsub.PubSubService;
import org.nuxeo.ecm.core.pubsub.SerializableInvalidations;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractPubSubInvalidator<T extends SerializableInvalidations> {
    private static final Log log = LogFactory.getLog(AbstractPubSubInvalidator.class);
    private static final String UTF_8 = "UTF-8";
    protected String topic;
    protected byte[] discriminatorBytes;
    protected volatile T bufferedInvalidations;
    protected static final byte DISCRIMINATOR_SEP = 58;

    public abstract T newInvalidations();

    public abstract T deserialize(InputStream var1) throws IOException;

    public void initialize(String topic, String discriminator) {
        this.topic = topic;
        try {
            this.discriminatorBytes = discriminator.getBytes(UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        for (byte b : this.discriminatorBytes) {
            if (b != 58) continue;
            throw new IllegalArgumentException("Invalid discriminator, must not contains separator ':': " + discriminator);
        }
        this.bufferedInvalidations = this.newInvalidations();
        PubSubService pubSubService = (PubSubService)Framework.getService(PubSubService.class);
        pubSubService.registerSubscriber(topic, this::subscriber);
    }

    public void close() {
        PubSubService pubSubService = (PubSubService)Framework.getService(PubSubService.class);
        pubSubService.unregisterSubscriber(this.topic, this::subscriber);
        this.bufferedInvalidations = this.newInvalidations();
    }

    public void sendInvalidations(T invalidations) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Sending invalidations: " + invalidations));
        }
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        try {
            baout.write(this.discriminatorBytes);
        }
        catch (IOException e) {
            return;
        }
        baout.write(58);
        try {
            invalidations.serialize(baout);
        }
        catch (IOException e) {
            log.error((Object)"Failed to serialize invalidations", (Throwable)e);
            return;
        }
        byte[] message = baout.toByteArray();
        PubSubService pubSubService = (PubSubService)Framework.getService(PubSubService.class);
        pubSubService.publish(this.topic, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscriber(String topic, byte[] message) {
        T invalidations;
        int start = this.scanDiscriminator(message);
        if (start == -1) {
            return;
        }
        ByteArrayInputStream bain = new ByteArrayInputStream(message, start, message.length - start);
        try {
            invalidations = this.deserialize(bain);
        }
        catch (IOException e) {
            log.error((Object)"Failed to deserialize invalidations", (Throwable)e);
            return;
        }
        if (invalidations == null || invalidations.isEmpty()) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Receiving invalidations: " + invalidations));
        }
        AbstractPubSubInvalidator abstractPubSubInvalidator = this;
        synchronized (abstractPubSubInvalidator) {
            this.bufferedInvalidations.add((SerializableInvalidations)invalidations);
        }
    }

    protected int scanDiscriminator(byte[] message) {
        if (message == null) {
            return -1;
        }
        int start = -1;
        boolean differ = false;
        for (int i = 0; i < message.length; ++i) {
            byte b = message[i];
            if (b == 58) {
                differ = differ || this.discriminatorBytes.length > i;
                start = i + 1;
                break;
            }
            if (differ) continue;
            if (i == this.discriminatorBytes.length) {
                differ = true;
                continue;
            }
            if (b == this.discriminatorBytes[i]) continue;
            differ = true;
        }
        if (!differ) {
            return -1;
        }
        return start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T receiveInvalidations() {
        T invalidations;
        T newInvalidations = this.newInvalidations();
        AbstractPubSubInvalidator abstractPubSubInvalidator = this;
        synchronized (abstractPubSubInvalidator) {
            invalidations = this.bufferedInvalidations;
            this.bufferedInvalidations = newInvalidations;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Received invalidations: " + invalidations));
        }
        return invalidations;
    }
}

