/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.work.MemoryWorkQueuing;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;

public class MemoryBlockingQueue
extends NuxeoBlockingQueue {
    protected final BlockingQueue<Runnable> queue;
    protected final Map<String, Work> works = new HashMap<String, Work>();
    protected final Set<String> scheduledWorks = new HashSet<String>();
    protected final Set<String> runningWorks = new HashSet<String>();
    long scheduledCount;
    long runningCount;
    long completedCount;
    long cancelledCount;

    public MemoryBlockingQueue(String id, MemoryWorkQueuing queuing, int capacity) {
        super(id, queuing);
        this.queue = new ReentrantLinkedBlockingQueue<Runnable>(capacity);
    }

    @Override
    protected synchronized WorkQueueMetrics metrics() {
        return new WorkQueueMetrics(this.queueId, this.scheduledCount, this.runningCount, this.completedCount, this.cancelledCount);
    }

    @Override
    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public void putElement(Runnable r) throws InterruptedException {
        this.queue.put(r);
    }

    @Override
    public Runnable pollElement() {
        Runnable r = (Runnable)this.queue.poll();
        return r;
    }

    @Override
    public Runnable take() throws InterruptedException {
        Runnable r = this.queue.take();
        if (this.anotherWorkIsAlreadyRunning(r)) {
            this.offer(r);
            Thread.sleep(100L);
            return null;
        }
        return r;
    }

    private boolean anotherWorkIsAlreadyRunning(Runnable r) throws InterruptedException {
        Work work = WorkHolder.getWork(r);
        String id = work.getId();
        return this.runningWorks.contains(id);
    }

    @Override
    public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        if ((nanos = this.awaitActivation(nanos)) <= 0L) {
            return null;
        }
        return this.queue.poll(nanos, TimeUnit.NANOSECONDS);
    }

    synchronized WorkQueueMetrics workSchedule(Work work) {
        String id = work.getId();
        if (this.scheduledWorks.contains(id)) {
            return this.metrics();
        }
        if (!this.offer(new WorkHolder(work))) {
            return this.metrics();
        }
        this.works.put(id, work);
        this.scheduledWorks.add(id);
        ++this.scheduledCount;
        return this.metrics();
    }

    synchronized WorkQueueMetrics workRunning(Work work) {
        String id = work.getId();
        this.scheduledWorks.remove(id);
        this.works.put(id, work);
        this.runningWorks.add(id);
        --this.scheduledCount;
        ++this.runningCount;
        return this.metrics();
    }

    synchronized WorkQueueMetrics workCanceled(Work work) {
        String id = work.getId();
        Iterator it = this.queue.iterator();
        while (it.hasNext()) {
            if (!id.equals(WorkHolder.getWork((Runnable)it.next()).getId())) continue;
            it.remove();
            this.scheduledWorks.remove(id);
            this.works.remove(id);
            --this.scheduledCount;
            ++this.cancelledCount;
            break;
        }
        return this.metrics();
    }

    synchronized WorkQueueMetrics workCompleted(Work work) {
        String id = work.getId();
        if (this.runningWorks.remove(id) && !this.scheduledWorks.contains(id)) {
            this.works.remove(id);
        }
        --this.runningCount;
        ++this.completedCount;
        return this.metrics();
    }

    synchronized WorkQueueMetrics workRescheduleRunning(Work work) {
        String id = work.getId();
        if (!this.runningWorks.remove(id)) {
            return this.metrics();
        }
        this.works.remove(id);
        --this.runningCount;
        return this.workSchedule(work);
    }

    synchronized Work lookup(String workId) {
        return this.works.get(workId);
    }

    synchronized List<Work> list() {
        return new ArrayList<Work>(this.works.values());
    }

    synchronized List<String> keys() {
        return new ArrayList<String>(this.works.keySet());
    }

    synchronized List<Work> listScheduled() {
        return this.scheduledWorks.stream().map(this.works::get).collect(Collectors.toList());
    }

    synchronized List<String> scheduledKeys() {
        return new ArrayList<String>(this.scheduledWorks);
    }

    synchronized List<Work> listRunning() {
        return this.runningWorks.stream().map(this.works::get).collect(Collectors.toList());
    }

    synchronized List<String> runningKeys() {
        return new ArrayList<String>(this.runningWorks);
    }

    private static class ReentrantLinkedBlockingQueue<T>
    extends LinkedBlockingQueue<T> {
        private static final long serialVersionUID = 1L;
        private final ReentrantLock limitedPutLock = new ReentrantLock();
        private final int limitedCapacity;

        public ReentrantLinkedBlockingQueue(int capacity) {
            super(capacity < 0 ? Integer.MAX_VALUE : 2 * capacity);
            this.limitedCapacity = capacity;
        }

        public void limitedPut(T e) throws InterruptedException {
            this.limitedPutLock.lockInterruptibly();
            try {
                while (this.remainingCapacity() < this.limitedCapacity) {
                    Thread.sleep(100L);
                }
                this.put(e);
            }
            finally {
                this.limitedPutLock.unlock();
            }
        }

        @Override
        public boolean offer(T e) {
            if (this.limitedCapacity < 0) {
                return super.offer(e);
            }
            try {
                if (Thread.currentThread().getName().startsWith("Nuxeo-Work-")) {
                    this.put(e);
                } else {
                    this.limitedPut(e);
                }
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("interrupted", ie);
            }
        }
    }
}

