/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ldap;

import com.sun.jndi.ldap.LdapURL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.ldap.LDAPUrlDescriptor;
import org.nuxeo.ecm.directory.ldap.dns.DNSServiceEntry;
import org.nuxeo.ecm.directory.ldap.dns.DNSServiceResolver;
import org.nuxeo.ecm.directory.ldap.dns.DNSServiceResolverImpl;

@XObject(value="server")
public class LDAPServerDescriptor {
    public static final Log log = LogFactory.getLog(LDAPServerDescriptor.class);
    protected static final String LDAPS_SCHEME = "ldaps";
    protected static final String LDAP_SCHEME = "ldap";
    @XNode(value="@name")
    public String name;
    public String ldapUrls;
    public String bindDn;
    @XNode(value="connectionTimeout")
    public int connectionTimeout = 10000;
    @XNode(value="poolingEnabled")
    public boolean poolingEnabled = true;
    @XNode(value="verifyServerCert")
    public boolean verifyServerCert = true;
    @XNode(value="retries")
    public int retries = 5;
    protected LinkedHashSet<LdapEntry> ldapEntries;
    protected boolean isDynamicServerList = false;
    protected boolean useSsl = false;
    protected final DNSServiceResolver srvResolver = DNSServiceResolverImpl.getInstance();
    public String bindPassword = "";

    public boolean isDynamicServerList() {
        return this.isDynamicServerList;
    }

    public String getName() {
        return this.name;
    }

    @XNode(value="bindDn")
    public void setBindDn(String bindDn) {
        this.bindDn = null != bindDn && bindDn.trim().equals("") ? null : bindDn;
    }

    public String getBindDn() {
        return this.bindDn;
    }

    @XNode(value="bindPassword")
    public void setBindPassword(String bindPassword) {
        this.bindPassword = bindPassword == null ? "" : bindPassword;
    }

    public String getBindPassword() {
        return this.bindPassword;
    }

    public String getLdapUrls() {
        if (this.ldapUrls != null) {
            return this.ldapUrls;
        }
        StringBuilder calculatedLdapUrls = new StringBuilder();
        for (LdapEntry entry : this.ldapEntries) {
            calculatedLdapUrls.append(entry);
            calculatedLdapUrls.append(' ');
        }
        if (!this.isDynamicServerList) {
            this.ldapUrls = calculatedLdapUrls.toString().trim();
            return this.ldapUrls;
        }
        return calculatedLdapUrls.toString().trim();
    }

    @XNodeList(value="ldapUrl", componentType=LDAPUrlDescriptor.class, type=LDAPUrlDescriptor[].class)
    public void setLdapUrls(LDAPUrlDescriptor[] ldapUrls) throws DirectoryException {
        if (ldapUrls == null) {
            throw new DirectoryException("At least one <ldapUrl/> server declaration is required");
        }
        this.ldapEntries = new LinkedHashSet();
        HashSet<LDAPUrlDescriptor> processed = new HashSet<LDAPUrlDescriptor>();
        ArrayList<String> urls = new ArrayList<String>(ldapUrls.length);
        for (LDAPUrlDescriptor url : ldapUrls) {
            LdapURL ldapUrl;
            try {
                if (StringUtils.isEmpty((String)url.getValue())) {
                    urls.add(url.getValue());
                    this.ldapEntries.add(new LdapEntryDescriptor(url));
                    continue;
                }
                ldapUrl = new LdapURL(url.getValue());
                if (!processed.add(url)) {
                    continue;
                }
            }
            catch (NamingException e) {
                throw new DirectoryException((Throwable)e);
            }
            boolean bl = this.useSsl = this.useSsl || ldapUrl.useSsl();
            if (ldapUrl.getHost() == null) {
                String domain = this.convertDNtoFQDN(ldapUrl.getDN());
                if (domain != null) {
                    List<String> discoveredUrls;
                    try {
                        discoveredUrls = this.discoverLdapServers(domain, ldapUrl.useSsl(), url.getSrvPrefix());
                    }
                    catch (NamingException e) {
                        throw new DirectoryException(String.format("SRV record DNS lookup failed for %s.%s: %s", url.getSrvPrefix(), domain, e.getMessage()), (Throwable)e);
                    }
                    urls.addAll(discoveredUrls);
                    this.ldapEntries.add(new LdapEntryDomain(url, domain, ldapUrl.useSsl()));
                    this.isDynamicServerList = true;
                    continue;
                }
                throw new DirectoryException("Invalid LDAP SRV reference, this should be of the form ldap:///dc=example,dc=org");
            }
            urls.add(url.getValue());
            this.ldapEntries.add(new LdapEntryDescriptor(url));
        }
        if (urls.isEmpty()) {
            throw new DirectoryException("No valid server urls returned from DNS query");
        }
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    protected List<String> discoverLdapServers(String domain, boolean useSsl, String srvPrefix) throws NamingException {
        ArrayList<String> result = new ArrayList<String>();
        List<DNSServiceEntry> servers = this.getSRVResolver().resolveLDAPDomainServers(domain, srvPrefix);
        for (DNSServiceEntry serviceEntry : servers) {
            StringBuilder realUrl = useSsl ? new StringBuilder("ldaps://") : new StringBuilder("ldap://");
            realUrl.append(serviceEntry);
            result.add(realUrl.toString());
        }
        return result;
    }

    protected String convertDNtoFQDN(String dn) throws DirectoryException {
        try {
            String component;
            LdapDN ldapDN = new LdapDN(dn);
            Enumeration components = ldapDN.getAll();
            ArrayList<String> domainComponents = new ArrayList<String>();
            while (components.hasMoreElements() && (component = (String)components.nextElement()).startsWith("dc=")) {
                domainComponents.add(component.substring(3));
            }
            Collections.reverse(domainComponents);
            return StringUtils.join(domainComponents, (String)".");
        }
        catch (InvalidNameException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public boolean isPoolingEnabled() {
        return this.poolingEnabled;
    }

    public boolean isVerifyServerCert() {
        return this.verifyServerCert;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    protected DNSServiceResolver getSRVResolver() {
        return this.srvResolver;
    }

    public int getRetries() {
        return this.retries;
    }

    protected final class LdapEntryDomain
    extends LdapEntryDescriptor {
        protected final String domain;
        protected final boolean useSsl;

        public LdapEntryDomain(LDAPUrlDescriptor descriptor, String domain, boolean useSsl) {
            super(descriptor);
            this.domain = domain;
            this.useSsl = useSsl;
        }

        @Override
        public String getUrl() throws NamingException {
            List<DNSServiceEntry> servers = LDAPServerDescriptor.this.getSRVResolver().resolveLDAPDomainServers(this.domain, this.url.getSrvPrefix());
            StringBuilder result = new StringBuilder();
            for (DNSServiceEntry serviceEntry : servers) {
                result.append(this.useSsl ? LDAPServerDescriptor.LDAPS_SCHEME + "://" : LDAPServerDescriptor.LDAP_SCHEME + "://");
                result.append(serviceEntry);
                result.append(' ');
            }
            return result.toString().trim();
        }

        private LDAPServerDescriptor getOuterType() {
            return LDAPServerDescriptor.this;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
            result = 31 * result + (this.useSsl ? 1231 : 1237);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LdapEntryDomain other = (LdapEntryDomain)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
                return false;
            }
            return this.useSsl == other.useSsl;
        }
    }

    protected class LdapEntryDescriptor
    implements LdapEntry {
        protected LDAPUrlDescriptor url;

        public LdapEntryDescriptor(LDAPUrlDescriptor descriptor) {
            this.url = descriptor;
        }

        public String toString() {
            try {
                return this.getUrl();
            }
            catch (NamingException e) {
                log.error((Object)e, (Throwable)e);
                return "[DNS lookup failed]";
            }
        }

        public boolean equals(Object obj) {
            if (obj instanceof LdapEntryDescriptor) {
                return this.url.equals(obj);
            }
            return false;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        @Override
        public String getUrl() throws NamingException {
            return this.url.getValue();
        }
    }

    protected static interface LdapEntry {
        public String getUrl() throws NamingException;
    }
}

