/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderClassReplacerDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.core.PageProviderClassReplacerRegistry;
import org.nuxeo.ecm.platform.query.core.PageProviderRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class PageProviderServiceImpl
extends DefaultComponent
implements PageProviderService {
    private static final long serialVersionUID = 1L;
    public static final String PROVIDER_EP = "providers";
    public static final String REPLACER_EP = "replacers";
    @Deprecated
    public static final String NAMED_PARAMETERS = "namedParameters";
    protected PageProviderRegistry providerReg = new PageProviderRegistry();
    protected PageProviderClassReplacerRegistry replacersReg = new PageProviderClassReplacerRegistry();

    @Override
    public PageProviderDefinition getPageProviderDefinition(String name) {
        PageProviderDefinition def = this.providerReg.getPageProvider(name);
        if (def == null) {
            return null;
        }
        return def.clone();
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<String> highlights, List<QuickFilter> quickFilters, Object ... parameters) {
        Long maxPageSize;
        if (desc == null) {
            return null;
        }
        PageProvider<?> pageProvider = this.newPageProviderInstance(name, desc);
        HashMap<String, Serializable> allProps = new HashMap<String, Serializable>();
        Map localProps = desc.getProperties();
        if (localProps != null) {
            allProps.putAll(localProps);
        }
        if (properties != null) {
            allProps.putAll(properties);
        }
        pageProvider.setProperties(allProps);
        pageProvider.setSortable(desc.isSortable());
        pageProvider.setParameters(parameters);
        pageProvider.setPageSizeOptions(desc.getPageSizeOptions());
        if (searchDocument != null) {
            pageProvider.setSearchDocumentModel(searchDocument);
        }
        if ((maxPageSize = desc.getMaxPageSize()) != null) {
            pageProvider.setMaxPageSize(maxPageSize.longValue());
        }
        if (sortInfos == null) {
            pageProvider.setSortInfos(desc.getSortInfos());
        } else {
            pageProvider.setSortInfos(sortInfos);
        }
        if (quickFilters != null) {
            pageProvider.setQuickFilters(quickFilters);
        }
        if (highlights != null) {
            pageProvider.setHighlights(highlights);
        }
        if (pageSize == null || pageSize < 0L) {
            pageProvider.setPageSize(desc.getPageSize());
        } else {
            pageProvider.setPageSize(pageSize.longValue());
        }
        if (currentPage != null && currentPage > 0L) {
            pageProvider.setCurrentPage(currentPage.longValue());
        }
        return pageProvider;
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<QuickFilter> quickFilters, Object ... parameters) {
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, null, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<String> highlights, List<QuickFilter> quickFilters, Object ... parameters) {
        return this.getPageProvider(name, (DocumentModel)null, sortInfos, pageSize, currentPage, properties, highlights, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, PageProviderDefinition desc, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) {
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, null, null, parameters);
    }

    protected PageProvider<?> newPageProviderInstance(String name, PageProviderDefinition desc) {
        PageProvider<?> ret;
        if (desc instanceof CoreQueryPageProviderDescriptor) {
            ret = this.newCoreQueryPageProviderInstance(name);
        } else if (desc instanceof GenericPageProviderDescriptor) {
            Class<PageProvider<?>> klass = ((GenericPageProviderDescriptor)desc).getPageProviderClass();
            ret = this.newPageProviderInstance(name, klass);
        } else {
            throw new NuxeoException(String.format("Invalid page provider definition with name '%s'", name));
        }
        ret.setName(name);
        ret.setDefinition(desc);
        return ret;
    }

    protected PageProvider<?> newCoreQueryPageProviderInstance(String name) {
        Class<? extends PageProvider<?>> klass = this.replacersReg.getClassForPageProvider(name);
        PageProvider ret = klass == null ? new PageProvider() : this.newPageProviderInstance(name, klass);
        return ret;
    }

    protected PageProvider<?> newPageProviderInstance(String name, Class<? extends PageProvider<?>> klass) {
        PageProvider<?> ret;
        if (klass == null) {
            throw new NuxeoException(String.format("Cannot find class for page provider definition with name '%s': check ERROR logs at startup", name));
        }
        try {
            ret = klass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException(String.format("Cannot create an instance of class %s for page provider definition with name '%s'", klass.getName(), name), (Throwable)e);
        }
        return ret;
    }

    @Override
    public PageProvider<?> getPageProvider(String name, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) {
        PageProviderDefinition desc = this.providerReg.getPageProvider(name);
        if (desc == null) {
            throw new NuxeoException(String.format("Could not resolve page provider with name '%s'", name));
        }
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, null, null, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<String> highlights, List<QuickFilter> quickFilters, Object ... parameters) {
        PageProviderDefinition desc = this.providerReg.getPageProvider(name);
        if (desc == null) {
            throw new NuxeoException(String.format("Could not resolve page provider with name '%s'", name));
        }
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, highlights, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, DocumentModel searchDocument, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, List<QuickFilter> quickFilters, Object ... parameters) {
        PageProviderDefinition desc = this.providerReg.getPageProvider(name);
        if (desc == null) {
            throw new NuxeoException(String.format("Could not resolve page provider with name '%s'", name));
        }
        return this.getPageProvider(name, desc, searchDocument, sortInfos, pageSize, currentPage, properties, quickFilters, parameters);
    }

    @Override
    public PageProvider<?> getPageProvider(String name, List<SortInfo> sortInfos, Long pageSize, Long currentPage, Map<String, Serializable> properties, Object ... parameters) {
        return this.getPageProvider(name, (DocumentModel)null, sortInfos, pageSize, currentPage, properties, parameters);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PROVIDER_EP.equals(extensionPoint)) {
            PageProviderDefinition desc = (PageProviderDefinition)contribution;
            this.registerPageProviderDefinition(desc);
        } else if (REPLACER_EP.equals(extensionPoint)) {
            PageProviderClassReplacerDefinition desc = (PageProviderClassReplacerDefinition)contribution;
            this.replacersReg.addContribution(desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (PROVIDER_EP.equals(extensionPoint)) {
            PageProviderDefinition desc = (PageProviderDefinition)contribution;
            this.unregisterPageProviderDefinition(desc);
        }
    }

    public void start(ComponentContext context) {
        this.replacersReg.dumpReplacerMap();
    }

    @Override
    public void registerPageProviderDefinition(PageProviderDefinition desc) {
        this.providerReg.addContribution(desc);
    }

    @Override
    public void unregisterPageProviderDefinition(PageProviderDefinition desc) {
        this.providerReg.removeContribution(desc);
    }

    @Override
    public Set<String> getPageProviderDefinitionNames() {
        return Collections.unmodifiableSet(this.providerReg.providers.keySet());
    }
}

