/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.runtime.ObjectIdImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ChangeEventInfo;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.ChangeType;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisContentAlreadyExistsException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisVersioningException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BindingsObjectFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.BulkUpdateObjectIdAndChangeTokenImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ChangeEventInfoDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FailedToDeleteDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectListImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisTypeDefinitionType;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractCmisService;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ProgressControlCmisService;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.support.wrapper.AbstractCmisServiceWrapper;
import org.apache.chemistry.opencmis.server.support.wrapper.CallContextAwareCmisService;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.opencmis.impl.server.CMISQLtoNXQL;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoContentStream;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyData;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoPropertyDataBase;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepositories;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoRepository;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoTypeHelper;
import org.nuxeo.ecm.core.opencmis.impl.server.versioning.CMISVersioningFilter;
import org.nuxeo.ecm.core.opencmis.impl.util.ListUtils;
import org.nuxeo.ecm.core.opencmis.impl.util.SimpleImageInfo;
import org.nuxeo.ecm.core.opencmis.impl.util.TypeManagerImpl;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLDocumentVersion;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.service.DefaultAuditBackend;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.mimetype.MimetypeNotFoundException;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.mimetype.service.MimetypeRegistryService;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsIterableQueryResultImpl;
import org.nuxeo.elasticsearch.audit.ESAuditBackend;
import org.nuxeo.elasticsearch.audit.io.AuditEntryJSONReader;
import org.nuxeo.elasticsearch.core.EsSearchHitConverter;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoCmisService
extends AbstractCmisService
implements CallContextAwareCmisService,
ProgressControlCmisService {
    public static final int DEFAULT_TYPE_LEVELS = 2;
    public static final int DEFAULT_FOLDER_LEVELS = 2;
    public static final int DEFAULT_CHANGE_LOG_SIZE = 100;
    public static final int MAX_CHANGE_LOG_SIZE = 1000000;
    public static final int DEFAULT_QUERY_SIZE = 100;
    public static final int DEFAULT_MAX_CHILDREN = 100;
    public static final int DEFAULT_MAX_RELATIONSHIPS = 100;
    public static final String PERMISSION_NOTHING = "Nothing";
    public static final String NX_CHANGE_LOG_ID = "nuxeo:changeLogId";
    public static final String ES_AUDIT_ID = "id";
    public static final String ES_AUDIT_REPOSITORY_ID = "repositoryId";
    public static final String ES_AUDIT_EVENT_ID = "eventId";
    public static final String ERROR_ON_CANCEL_CHECK_OUT_OF_DRAFT_VERSION_PROP = "org.nuxeo.cmis.errorOnCancelCheckOutOfDraftVersion";
    private static final Log log = LogFactory.getLog(NuxeoCmisService.class);
    protected final BindingsObjectFactory objectFactory = new BindingsObjectFactoryImpl();
    protected final NuxeoRepository repository;
    protected final boolean coreSessionOwned;
    protected CoreSession coreSession;
    protected String cachedChangeLogToken;
    protected CallContext callContext;
    protected final Filter documentFilter;
    protected final Set<String> readPermissions;
    protected final Set<String> writePermissions;
    protected final boolean errorOnCancelCheckOutOfDraftVersion;
    protected static String REPLACE_QUOTE = Matcher.quoteReplacement("\\'");
    protected boolean collectObjectInfos = true;
    protected Map<String, ObjectInfo> objectInfos;

    public static NuxeoCmisService extractFromCmisService(CmisService service) {
        if (service == null) {
            throw new NullPointerException();
        }
        while (!(service instanceof NuxeoCmisService)) {
            if (!(service instanceof AbstractCmisServiceWrapper)) {
                return null;
            }
            service = ((AbstractCmisServiceWrapper)service).getWrappedService();
        }
        return (NuxeoCmisService)service;
    }

    public NuxeoCmisService(CoreSession coreSession) {
        this(coreSession, coreSession.getRepositoryName());
    }

    public NuxeoCmisService(String repositoryName) {
        this(null, repositoryName);
    }

    protected NuxeoCmisService(CoreSession coreSession, String repositoryName) {
        this.coreSession = coreSession;
        this.coreSessionOwned = coreSession == null;
        this.repository = NuxeoCmisService.getNuxeoRepository(repositoryName);
        this.documentFilter = this.getDocumentFilter();
        SecurityService securityService = (SecurityService)Framework.getService(SecurityService.class);
        this.readPermissions = new HashSet<String>(Arrays.asList(securityService.getPermissionsToCheck("Read")));
        this.writePermissions = new HashSet<String>(Arrays.asList(securityService.getPermissionsToCheck("ReadWrite")));
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        this.errorOnCancelCheckOutOfDraftVersion = configurationService.isBooleanPropertyTrue(ERROR_ON_CANCEL_CHECK_OUT_OF_DRAFT_VERSION_PROP);
        CMISVersioningFilter.enable();
    }

    public void close() {
        if (this.coreSessionOwned && this.coreSession != null) {
            this.coreSession.close();
            this.coreSession = null;
        }
        this.clearObjectInfos();
        CMISVersioningFilter.disable();
    }

    public ProgressControlCmisService.Progress beforeServiceCall() {
        return ProgressControlCmisService.Progress.CONTINUE;
    }

    public ProgressControlCmisService.Progress afterServiceCall() {
        if (!TransactionHelper.setTransactionRollbackOnlyIfTimedOut()) {
            return ProgressControlCmisService.Progress.CONTINUE;
        }
        HttpServletResponse response = (HttpServletResponse)this.getCallContext().get("httpServletResponse");
        if (response != null) {
            try {
                response.sendError(503, "Transaction timeout");
            }
            catch (IOException e) {
                throw new CmisRuntimeException("Failed to set timeout status", (Throwable)e);
            }
        }
        return ProgressControlCmisService.Progress.STOP;
    }

    protected static NuxeoRepository getNuxeoRepository(String repositoryName) {
        if (repositoryName == null) {
            return null;
        }
        return ((NuxeoRepositories)((Object)Framework.getService(NuxeoRepositories.class))).getRepository(repositoryName);
    }

    protected static CoreSession openCoreSession(String repositoryName, String username) {
        if (repositoryName == null) {
            return null;
        }
        return CoreInstance.openCoreSession((String)repositoryName, (String)username);
    }

    public NuxeoRepository getNuxeoRepository() {
        return this.repository;
    }

    public CoreSession getCoreSession() {
        return this.coreSession;
    }

    public BindingsObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public CallContext getCallContext() {
        return this.callContext;
    }

    protected TypeManagerImpl getTypeManager() {
        CmisVersion cmisVersion = this.callContext == null ? CmisVersion.CMIS_1_1 : this.callContext.getCmisVersion();
        return this.repository.getTypeManager(cmisVersion);
    }

    public void setCallContext(CallContext callContext) {
        this.close();
        this.callContext = callContext;
        if (this.coreSessionOwned) {
            String username = callContext.getBinding().equals("local") ? callContext.getUsername() : null;
            this.coreSession = this.repository == null ? null : NuxeoCmisService.openCoreSession(this.repository.getId(), username);
            CMISVersioningFilter.enable();
        }
    }

    protected Filter getDocumentFilter() {
        FacetFilter facetFilter = new FacetFilter("HiddenInNavigation", false);
        LifeCycleFilter lcFilter = new LifeCycleFilter("deleted", false);
        return new CompoundFilter(new Filter[]{facetFilter, lcFilter});
    }

    protected String getIdFromDocumentRef(DocumentRef ref) {
        if (ref instanceof IdRef) {
            return ((IdRef)ref).value;
        }
        return this.coreSession.getDocument(ref).getId();
    }

    protected void save() {
        this.coreSession.save();
        this.cachedChangeLogToken = null;
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        List<NuxeoRepository> repos = ((NuxeoRepositories)((Object)Framework.getService(NuxeoRepositories.class))).getRepositories();
        ArrayList<RepositoryInfo> infos = new ArrayList<RepositoryInfo>(repos.size());
        for (NuxeoRepository repo : repos) {
            String latestChangeLogToken = this.getLatestChangeLogToken(repo.getId());
            infos.add(repo.getRepositoryInfo(latestChangeLogToken, this.callContext));
        }
        return infos;
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        String latestChangeLogToken;
        if (this.cachedChangeLogToken != null) {
            latestChangeLogToken = this.cachedChangeLogToken;
        } else {
            this.cachedChangeLogToken = latestChangeLogToken = this.getLatestChangeLogToken(repositoryId);
        }
        NuxeoRepository repository = NuxeoCmisService.getNuxeoRepository(repositoryId);
        return repository.getRepositoryInfo(latestChangeLogToken, this.callContext);
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        TypeDefinition type = this.getTypeManager().getTypeDefinition(typeId);
        if (type == null) {
            throw new CmisInvalidArgumentException("No such type: " + typeId);
        }
        return WSConverter.convert((CmisTypeDefinitionType)WSConverter.convert((TypeDefinition)type));
    }

    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        TypeDefinitionList types = this.getTypeManager().getTypeChildren(typeId, includePropertyDefinitions, maxItems, skipCount);
        return WSConverter.convert((CmisTypeDefinitionListType)WSConverter.convert((TypeDefinitionList)types));
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        int d = depth == null ? 2 : depth.intValue();
        List<TypeDefinitionContainer> types = this.getTypeManager().getTypeDescendants(typeId, d, includePropertyDefinitions);
        ArrayList tmp = new ArrayList(types.size());
        WSConverter.convertTypeContainerList(types, tmp);
        return WSConverter.convertTypeContainerList(tmp);
    }

    protected DocumentModel getDocumentModel(String id) {
        IdRef docRef = new IdRef(id);
        if (!this.coreSession.exists((DocumentRef)docRef)) {
            throw new CmisObjectNotFoundException(docRef.toString());
        }
        DocumentModel doc = this.coreSession.getDocument((DocumentRef)docRef);
        if (this.isFilteredOut(doc)) {
            throw new CmisObjectNotFoundException(docRef.toString());
        }
        return doc;
    }

    public NuxeoObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData data = new NuxeoObjectData((CmisService)this, doc, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        this.collectObjectInfo(repositoryId, objectId);
        return data;
    }

    public boolean isFilteredOut(DocumentModel doc) {
        if (NuxeoTypeHelper.getBaseTypeId(doc).equals((Object)BaseTypeId.CMIS_RELATIONSHIP)) {
            return false;
        }
        return !this.documentFilter.accept(doc);
    }

    protected DocumentModel createDocumentModel(ObjectId folder, TypeDefinition type) {
        String typeId = type.getId();
        String nuxeoTypeId = type.getLocalName();
        if (BaseTypeId.CMIS_DOCUMENT.value().equals(typeId)) {
            nuxeoTypeId = "File";
        } else if (BaseTypeId.CMIS_FOLDER.value().equals(typeId)) {
            nuxeoTypeId = "Folder";
        } else if (BaseTypeId.CMIS_RELATIONSHIP.value().equals(typeId)) {
            nuxeoTypeId = "DefaultRelation";
        }
        DocumentModel doc = this.coreSession.createDocumentModel(nuxeoTypeId);
        if (folder != null) {
            IdRef parentRef = new IdRef(folder.getId());
            if (!this.coreSession.exists((DocumentRef)parentRef)) {
                throw new CmisInvalidArgumentException(parentRef.toString());
            }
            DocumentModel parentDoc = this.coreSession.getDocument((DocumentRef)parentRef);
            String pathSegment = nuxeoTypeId;
            doc.setPathInfo(parentDoc.getPathAsString(), pathSegment);
        }
        return doc;
    }

    protected DocumentModel createDocumentModel(ObjectId folder, ContentStream contentStream, String name) {
        Blob blob;
        FileManager fileManager = (FileManager)Framework.getLocalService(FileManager.class);
        MimetypeRegistryService mtr = (MimetypeRegistryService)Framework.getLocalService(MimetypeRegistry.class);
        if (fileManager == null || mtr == null || name == null || folder == null) {
            return null;
        }
        DocumentModel parent = this.coreSession.getDocument((DocumentRef)new IdRef(folder.getId()));
        String path = parent.getPathAsString();
        if (contentStream == null) {
            String mimeType;
            try {
                mimeType = mtr.getMimetypeFromFilename(name);
            }
            catch (MimetypeNotFoundException e) {
                mimeType = "application/octet-stream";
            }
            blob = Blobs.createBlob((String)"", (String)mimeType, null, (String)name);
        } else {
            try {
                blob = NuxeoPropertyData.getPersistentBlob(contentStream, null);
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        try {
            return fileManager.createDocumentFromBlob(this.coreSession, blob, path, false, name);
        }
        catch (IOException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    protected NuxeoObjectData createObject(String repositoryId, Properties properties, ObjectId folder, BaseTypeId baseType, ContentStream contentStream) {
        boolean setContentStream;
        boolean created;
        String name;
        String typeId;
        PropertyData d;
        Map p;
        TypeDefinition type = null;
        if (properties != null && (p = properties.getProperties()) != null && (d = (PropertyData)p.get("cmis:objectTypeId")) != null) {
            typeId = (String)d.getFirstValue();
            if (baseType == null) {
                type = this.getTypeManager().getTypeDefinition(typeId);
                if (type == null) {
                    throw new IllegalArgumentException(typeId);
                }
                baseType = type.getBaseTypeId();
            }
        } else {
            typeId = null;
        }
        if (typeId == null) {
            switch (baseType) {
                case CMIS_DOCUMENT: {
                    typeId = BaseTypeId.CMIS_DOCUMENT.value();
                    break;
                }
                case CMIS_FOLDER: {
                    typeId = BaseTypeId.CMIS_FOLDER.value();
                    break;
                }
                case CMIS_POLICY: {
                    throw new CmisRuntimeException("Cannot create policy");
                }
                case CMIS_RELATIONSHIP: {
                    throw new CmisRuntimeException("Cannot create relationship");
                }
                default: {
                    throw new CmisRuntimeException("No base type");
                }
            }
        }
        if (type == null) {
            type = this.getTypeManager().getTypeDefinition(typeId);
        }
        if (type == null || type.getBaseTypeId() != baseType) {
            throw new CmisInvalidArgumentException(typeId);
        }
        if (type.isCreatable() == Boolean.FALSE) {
            throw new CmisInvalidArgumentException("Not creatable: " + typeId);
        }
        PropertyData npd = (PropertyData)properties.getProperties().get("cmis:name");
        String string = name = npd == null ? null : (String)npd.getFirstValue();
        if (StringUtils.isBlank((String)name)) {
            throw new CmisConstraintException("The mandatory property cmis:name is missing");
        }
        if (contentStream != null && StringUtils.isBlank((String)contentStream.getFileName())) {
            contentStream = new ContentStreamImpl(name, contentStream.getBigLength(), contentStream.getMimeType().trim(), contentStream.getStream());
        }
        DocumentModel doc = null;
        if (BaseTypeId.CMIS_DOCUMENT.value().equals(typeId)) {
            doc = this.createDocumentModel(folder, contentStream, name);
        }
        boolean bl = created = doc != null;
        if (!created) {
            doc = this.createDocumentModel(folder, type);
        }
        NuxeoObjectData data = new NuxeoObjectData((CmisService)this, doc);
        this.updateProperties(data, properties, true);
        boolean bl2 = setContentStream = !created && contentStream != null;
        if (setContentStream) {
            try {
                NuxeoPropertyData.setContentStream(doc, contentStream, true);
            }
            catch (CmisContentAlreadyExistsException cmisContentAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        if (!created) {
            PathSegmentService pss = (PathSegmentService)Framework.getLocalService(PathSegmentService.class);
            String pathSegment = pss.generatePathSegment(doc);
            Path path = doc.getPath();
            doc.setPathInfo(path == null ? null : path.removeLastSegments(1).toString(), pathSegment);
            doc = this.coreSession.createDocument(doc);
        } else {
            doc = this.coreSession.saveDocument(doc);
        }
        if (setContentStream) {
            NuxeoPropertyData.validateBlobDigest(doc, this.callContext);
        }
        data.doc = doc;
        this.save();
        this.collectObjectInfo(repositoryId, data.getId());
        return data;
    }

    protected <T> void updateProperties(NuxeoObjectData object, Properties properties, boolean creation) {
        Map p;
        List<TypeDefinition> types = object.getTypeDefinitions();
        if (properties == null || (p = properties.getProperties()) == null) {
            return;
        }
        for (Map.Entry en : p.entrySet()) {
            String key = (String)en.getKey();
            PropertyData d = (PropertyData)en.getValue();
            this.setObjectProperty(object, key, d, types, creation);
        }
    }

    protected <T> void updateProperties(NuxeoObjectData object, Map<String, ?> properties, TypeDefinition type, boolean creation) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, ?> en : properties.entrySet()) {
            String key = en.getKey();
            Object value = en.getValue();
            PropertyDefinition pd = (PropertyDefinition)type.getPropertyDefinitions().get(key);
            if (pd == null) {
                throw new CmisRuntimeException("Unknown property: " + key);
            }
            this.setObjectProperty(object, key, value, pd, creation);
        }
    }

    protected <T> void setObjectProperty(NuxeoObjectData object, String key, PropertyData<T> d, List<TypeDefinition> types, boolean creation) {
        TypeDefinition type;
        PropertyDefinition pd = null;
        Iterator<TypeDefinition> iterator = types.iterator();
        while (iterator.hasNext() && (pd = (PropertyDefinition)(type = iterator.next()).getPropertyDefinitions().get(key)) == null) {
        }
        if (pd == null) {
            throw new CmisRuntimeException("Unknown property: " + key);
        }
        Object value = d == null ? null : (pd.getCardinality() == Cardinality.SINGLE ? d.getFirstValue() : d.getValues());
        this.setObjectProperty(object, key, value, pd, creation);
    }

    protected <T> void setObjectProperty(NuxeoObjectData object, String key, Object value, PropertyDefinition<T> pd, boolean creation) {
        Updatability updatability = pd.getUpdatability();
        if (updatability == Updatability.READONLY || updatability == Updatability.ONCREATE && !creation) {
            return;
        }
        if ("cmis:objectTypeId".equals(key) || "cmis:lastModificationDate".equals(key)) {
            return;
        }
        NuxeoPropertyDataBase np = (NuxeoPropertyDataBase)NuxeoPropertyData.construct(object, pd, this.callContext);
        np.setValue(value);
    }

    protected String setInitialVersioningState(NuxeoObjectData object, VersioningState versioningState) {
        String id;
        if (versioningState == null) {
            versioningState = VersioningState.MAJOR;
        }
        DocumentRef ref = null;
        switch (versioningState) {
            case NONE: 
            case CHECKEDOUT: {
                object.doc.setLock();
                this.save();
                id = object.getId();
                break;
            }
            case MINOR: {
                ref = object.doc.checkIn(VersioningOption.MINOR, null);
                this.save();
                id = object.getId();
                break;
            }
            case MAJOR: {
                ref = object.doc.checkIn(VersioningOption.MAJOR, null);
                this.save();
                id = object.getId();
                break;
            }
            default: {
                throw new AssertionError(versioningState);
            }
        }
        return id;
    }

    public String create(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, ExtensionsData extension) {
        NuxeoObjectData object = this.createObject(repositoryId, properties, (ObjectId)new ObjectIdImpl(folderId), null, contentStream);
        return this.setInitialVersioningState(object, versioningState);
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        NuxeoObjectData object = this.createObject(repositoryId, properties, (ObjectId)new ObjectIdImpl(folderId), BaseTypeId.CMIS_DOCUMENT, contentStream);
        return this.setInitialVersioningState(object, versioningState);
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        NuxeoObjectData object = this.createObject(repositoryId, properties, (ObjectId)new ObjectIdImpl(folderId), BaseTypeId.CMIS_FOLDER, null);
        return object.getId();
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        NuxeoObjectData object = this.createObject(repositoryId, properties, null, BaseTypeId.CMIS_RELATIONSHIP, null);
        return object.getId();
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        if (folderId == null) {
            throw new CmisInvalidArgumentException("Invalid null folder ID");
        }
        DocumentModel doc = this.getDocumentModel(sourceId);
        DocumentModel folder = this.getDocumentModel(folderId);
        DocumentModel copyDoc = this.coreSession.copy(doc.getRef(), folder.getRef(), null, new CoreSession.CopyOption[0]);
        NuxeoObjectData copy = new NuxeoObjectData((CmisService)this, copyDoc);
        if (properties != null && properties.getPropertyList() != null && !properties.getPropertyList().isEmpty()) {
            this.updateProperties(copy, properties, false);
            copy.doc = this.coreSession.saveDocument(copyDoc);
        }
        this.save();
        return this.setInitialVersioningState(copy, versioningState);
    }

    public NuxeoObjectData copy(String sourceId, String targetId, Map<String, ?> properties, TypeDefinition type, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        DocumentModel doc = this.getDocumentModel(sourceId);
        DocumentModel folder = this.getDocumentModel(targetId);
        DocumentModel copyDoc = this.coreSession.copy(doc.getRef(), folder.getRef(), null, new CoreSession.CopyOption[0]);
        NuxeoObjectData copy = new NuxeoObjectData((CmisService)this, copyDoc, context);
        if (properties != null && !properties.isEmpty()) {
            this.updateProperties(copy, properties, type, false);
            copy.doc = this.coreSession.saveDocument(copyDoc);
        }
        this.save();
        String id = this.setInitialVersioningState(copy, versioningState);
        NuxeoObjectData res = id.equals(copy.getId()) ? copy : new NuxeoObjectData((CmisService)this, this.getDocumentModel(id));
        return res;
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectIdHolder, Holder<String> changeTokenHolder, ExtensionsData extension) {
        this.setContentStream(repositoryId, objectIdHolder, Boolean.TRUE, changeTokenHolder, null, extension);
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        if (unfileObjects == UnfileObject.UNFILE) {
            throw new CmisConstraintException("Unfiling not supported");
        }
        if (this.repository.getRootFolderId().equals(folderId)) {
            throw new CmisInvalidArgumentException("Cannot delete root");
        }
        DocumentModel doc = this.getDocumentModel(folderId);
        if (!doc.isFolder()) {
            throw new CmisInvalidArgumentException("Not a folder: " + folderId);
        }
        this.coreSession.removeDocument((DocumentRef)new IdRef(folderId));
        this.save();
        return new FailedToDeleteDataImpl();
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        DocumentModel doc = this.getDocumentModel(objectId);
        return NuxeoObjectData.getAllowableActions(doc, false);
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        ContentStream cs;
        HttpServletRequest request = (HttpServletRequest)this.callContext.get("httpServletRequest");
        if (streamId == null) {
            DocumentModel doc = this.getDocumentModel(objectId);
            cs = NuxeoPropertyData.getContentStream(doc, request);
            if (cs == null) {
                throw new CmisConstraintException("No content stream: " + objectId);
            }
        } else {
            String renditionName = streamId.replaceAll("^nuxeo:rendition:", "");
            cs = this.getRenditionServiceStream(objectId, renditionName);
            if (cs == null) {
                throw new CmisInvalidArgumentException("Invalid stream id: " + streamId);
            }
        }
        if (cs instanceof NuxeoContentStream) {
            NuxeoContentStream ncs = (NuxeoContentStream)cs;
            Blob blob = ncs.blob;
            String blobDigestAlgorithm = blob.getDigestAlgorithm();
            if ("MD5".equals(blobDigestAlgorithm) && NuxeoContentStream.hasWantDigestRequestHeader(request, "contentMD5")) {
                this.setResponseHeader("Content-MD5", blob, this.callContext);
            }
            if (NuxeoContentStream.hasWantDigestRequestHeader(request, blobDigestAlgorithm)) {
                this.setResponseHeader("Digest", blob, this.callContext);
            }
        }
        return cs;
    }

    protected void setResponseHeader(String headerName, Blob blob, CallContext callContext) {
        String digest = NuxeoPropertyData.transcodeHexToBase64(blob.getDigest());
        HttpServletResponse response = (HttpServletResponse)callContext.get("httpServletResponse");
        if ("Digest".equalsIgnoreCase(headerName)) {
            digest = blob.getDigestAlgorithm() + "=" + digest;
        }
        response.setHeader(headerName, digest);
    }

    @Deprecated
    protected ContentStream getIconRenditionStream(String objectId) {
        SimpleImageInfo info;
        String iconPath;
        DocumentModel doc = this.getDocumentModel(objectId);
        try {
            iconPath = (String)((Object)doc.getPropertyValue("common:icon"));
        }
        catch (PropertyException e) {
            iconPath = null;
        }
        InputStream is = NuxeoObjectData.getIconStream(iconPath, this.callContext);
        if (is == null) {
            throw new CmisConstraintException("No icon content stream: " + objectId);
        }
        int slash = iconPath.lastIndexOf(47);
        String filename = slash == -1 ? iconPath : iconPath.substring(slash + 1);
        try {
            info = new SimpleImageInfo(is);
        }
        catch (IOException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
        is = NuxeoObjectData.getIconStream(iconPath, this.callContext);
        return new ContentStreamImpl(filename, BigInteger.valueOf(info.getLength()), info.getMimeType(), is);
    }

    protected ContentStream getRenditionServiceStream(String objectId, String renditionName) {
        DocumentModel doc;
        RenditionService renditionService = (RenditionService)Framework.getLocalService(RenditionService.class);
        Rendition rendition = renditionService.getRendition(doc = this.getDocumentModel(objectId), renditionName);
        if (rendition == null) {
            return null;
        }
        Blob blob = rendition.getBlob();
        if (blob == null) {
            return null;
        }
        Calendar modificationDate = rendition.getModificationDate();
        GregorianCalendar lastModified = modificationDate instanceof GregorianCalendar ? (GregorianCalendar)modificationDate : null;
        HttpServletRequest request = (HttpServletRequest)this.getCallContext().get("httpServletRequest");
        return NuxeoContentStream.create(doc, null, blob, "cmisRendition", Collections.singletonMap("rendition", renditionName), lastModified, request);
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        if (!NuxeoObjectData.needsRenditions(renditionFilter)) {
            return Collections.emptyList();
        }
        DocumentModel doc = this.getDocumentModel(objectId);
        return NuxeoObjectData.getRenditions(doc, renditionFilter, maxItems, skipCount, this.callContext);
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        DocumentModel doc;
        PathRef pathRef = new PathRef(path);
        if (this.coreSession.exists((DocumentRef)pathRef)) {
            doc = this.coreSession.getDocument((DocumentRef)pathRef);
            if (this.isFilteredOut(doc)) {
                throw new CmisObjectNotFoundException(path);
            }
        } else {
            doc = this.getObjectByPathOfNames(path);
        }
        NuxeoObjectData data = new NuxeoObjectData((CmisService)this, doc, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, extension);
        this.collectObjectInfo(repositoryId, data.getId());
        return data;
    }

    protected DocumentModel getObjectByPathOfNames(String path) throws CmisObjectNotFoundException {
        DocumentModel doc = this.coreSession.getRootDocument();
        for (String name : new Path(path).segments()) {
            String query = String.format("SELECT * FROM Document WHERE ecm:parentId = %s AND dc:title = %s", NuxeoCmisService.escapeStringForNXQL(doc.getId()), NuxeoCmisService.escapeStringForNXQL(name));
            DocumentModelList docs = this.coreSession.query(query = this.addProxyClause(query));
            if (docs.isEmpty()) {
                throw new CmisObjectNotFoundException(path);
            }
            doc = null;
            for (DocumentModel d : docs) {
                if (this.isFilteredOut(d)) continue;
                if (doc == null) {
                    doc = d;
                    continue;
                }
                log.warn((Object)String.format("Path '%s' returns several documents for '%s'", path, name));
                break;
            }
            if (doc != null) continue;
            throw new CmisObjectNotFoundException(path);
        }
        return doc;
    }

    protected static String escapeStringForNXQL(String s) {
        return "'" + s.replaceAll("'", REPLACE_QUOTE) + "'";
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData data = new NuxeoObjectData((CmisService)this, doc, filter, null, null, null, null, null, null);
        return data.getProperties();
    }

    public ObjectInfo getObjectInfo(String repositoryId, String objectId) {
        ObjectInfo info = this.getObjectInfo().get(objectId);
        if (info != null) {
            return info;
        }
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData data = new NuxeoObjectData((CmisService)this, doc, null, Boolean.TRUE, IncludeRelationships.BOTH, "*", Boolean.TRUE, Boolean.TRUE, null);
        return this.getObjectInfo(repositoryId, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectInfo getObjectInfo(String repositoryId, ObjectData data) {
        ObjectInfo info = this.getObjectInfo().get(data.getId());
        if (info != null) {
            return info;
        }
        try {
            this.collectObjectInfos = false;
            info = this.getObjectInfoIntern(repositoryId, data);
            this.getObjectInfo().put(info.getId(), info);
        }
        finally {
            this.collectObjectInfos = true;
        }
        return info;
    }

    protected Map<String, ObjectInfo> getObjectInfo() {
        if (this.objectInfos == null) {
            this.objectInfos = new HashMap<String, ObjectInfo>();
        }
        return this.objectInfos;
    }

    public void clearObjectInfos() {
        this.objectInfos = null;
    }

    protected void collectObjectInfo(String repositoryId, String objectId) {
        if (this.collectObjectInfos && this.callContext.isObjectInfoRequired()) {
            this.getObjectInfo(repositoryId, objectId);
        }
    }

    public void addObjectInfo(ObjectInfo info) {
        throw new UnsupportedOperationException();
    }

    public void moveObject(String repositoryId, Holder<String> objectIdHolder, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        if (this.repository.getRootFolderId().equals(objectId)) {
            throw new CmisConstraintException("Cannot move root");
        }
        if (targetFolderId == null) {
            throw new CmisInvalidArgumentException("Missing target folder ID");
        }
        this.getDocumentModel(objectId);
        IdRef docRef = new IdRef(objectId);
        DocumentModel parent = this.coreSession.getParentDocument((DocumentRef)docRef);
        if (this.isFilteredOut(parent)) {
            throw new CmisObjectNotFoundException("No parent: " + objectId);
        }
        if (sourceFolderId == null) {
            sourceFolderId = parent.getId();
        } else if (!parent.getId().equals(sourceFolderId)) {
            throw new CmisInvalidArgumentException("Object " + objectId + " is not filed in " + sourceFolderId);
        }
        DocumentModel target = this.getDocumentModel(targetFolderId);
        if (!target.isFolder()) {
            throw new CmisInvalidArgumentException("Target is not a folder: " + targetFolderId);
        }
        this.coreSession.move((DocumentRef)docRef, (DocumentRef)new IdRef(targetFolderId), null);
        this.save();
    }

    public void setContentStream(String repositoryId, Holder<String> objectIdHolder, Boolean overwriteFlag, Holder<String> changeTokenHolder, ContentStream contentStream, ExtensionsData extension) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        DocumentModel doc = this.getDocumentModel(objectId);
        try {
            NuxeoPropertyData.setContentStream(doc, contentStream, !Boolean.FALSE.equals(overwriteFlag));
            this.setChangeTokenForUpdate(doc, changeTokenHolder);
            try {
                doc = this.coreSession.saveDocument(doc);
            }
            catch (ConcurrentUpdateException e) {
                throw new CmisUpdateConflictException(e.getMessage());
            }
            NuxeoPropertyData.validateBlobDigest(doc, this.callContext);
            this.save();
        }
        catch (IOException e) {
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    protected void setChangeTokenForUpdate(DocumentModel doc, Holder<String> changeTokenHolder) {
        if (changeTokenHolder == null) {
            return;
        }
        String changeToken = (String)changeTokenHolder.getValue();
        if (changeToken == null) {
            return;
        }
        doc.putContextData("changeToken", (Serializable)((Object)changeToken));
    }

    public void updateProperties(String repositoryId, Holder<String> objectIdHolder, Holder<String> changeTokenHolder, Properties properties, ExtensionsData extension) {
        this.updateProperties(objectIdHolder, changeTokenHolder, properties);
        this.save();
    }

    protected void updateProperties(Holder<String> objectIdHolder, Holder<String> changeTokenHolder, Properties properties) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData object = new NuxeoObjectData((CmisService)this, doc);
        this.updateProperties(object, properties, false);
        this.setChangeTokenForUpdate(doc, changeTokenHolder);
        try {
            this.coreSession.saveDocument(doc);
        }
        catch (ConcurrentUpdateException e) {
            throw new CmisUpdateConflictException(e.getMessage());
        }
    }

    public List<BulkUpdateObjectIdAndChangeToken> bulkUpdateProperties(String repositoryId, List<BulkUpdateObjectIdAndChangeToken> objectIdAndChangeToken, Properties properties, List<String> addSecondaryTypeIds, List<String> removeSecondaryTypeIds, ExtensionsData extension) {
        ArrayList<BulkUpdateObjectIdAndChangeToken> list = new ArrayList<BulkUpdateObjectIdAndChangeToken>(objectIdAndChangeToken.size());
        for (BulkUpdateObjectIdAndChangeToken idt : objectIdAndChangeToken) {
            String id = idt.getId();
            Holder objectIdHolder = new Holder((Object)id);
            Holder changeTokenHolder = new Holder((Object)idt.getChangeToken());
            this.updateProperties((Holder<String>)objectIdHolder, (Holder<String>)changeTokenHolder, properties);
            list.add((BulkUpdateObjectIdAndChangeToken)new BulkUpdateObjectIdAndChangeTokenImpl(id, (String)objectIdHolder.getValue(), (String)changeTokenHolder.getValue()));
        }
        this.save();
        return list;
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        return this.applyAcl(objectId, addAces, removeAces, false, aclPropagation);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl aces, AclPropagation aclPropagation) {
        return this.applyAcl(objectId, aces, null, true, aclPropagation);
    }

    protected Acl applyAcl(String objectId, Acl addAces, Acl removeAces, boolean clearFirst, AclPropagation aclPropagation) {
        DocumentModel doc = this.getDocumentModel(objectId);
        if (aclPropagation == null) {
            aclPropagation = AclPropagation.REPOSITORYDETERMINED;
        }
        if (aclPropagation == AclPropagation.OBJECTONLY && doc.getDocumentType().isFolder()) {
            throw new CmisInvalidArgumentException("Cannot use ACLPropagation=objectonly on Folder");
        }
        IdRef docRef = new IdRef(objectId);
        ACP acp = this.coreSession.getACP((DocumentRef)docRef);
        ACL acl = acp.getOrCreateACL("local");
        if (clearFirst) {
            acl.clear();
        }
        if (addAces != null) {
            for (Ace ace : addAces.getAces()) {
                String principalId = ace.getPrincipalId();
                for (String permission : ace.getPermissions()) {
                    String perm = NuxeoCmisService.permissionToNuxeo(permission);
                    if (PERMISSION_NOTHING.equals(perm)) {
                        acl.add(new ACE("Everyone", "Everything", false));
                        continue;
                    }
                    acl.add(new ACE(principalId, perm, true));
                }
            }
        }
        if (removeAces != null) {
            Iterator it = acl.iterator();
            block2: while (it.hasNext()) {
                String permission;
                Ace ace;
                ace = (ACE)it.next();
                String username = ace.getUsername();
                String perm = ace.getPermission();
                if (ace.isDenied()) {
                    if (!"Everyone".equals(username) || !"Everything".equals(perm)) continue;
                    perm = PERMISSION_NOTHING;
                }
                permission = NuxeoCmisService.permissionFromNuxeo(perm);
                for (Ace race : removeAces.getAces()) {
                    String principalId = race.getPrincipalId();
                    if (!username.equals(principalId) || !race.getPermissions().contains(permission)) continue;
                    it.remove();
                    continue block2;
                }
            }
        }
        this.coreSession.setACP((DocumentRef)docRef, acp, true);
        return NuxeoObjectData.getAcl(acp, false, this);
    }

    protected static String permissionToNuxeo(String permission) {
        switch (permission) {
            case "cmis:read": {
                return "Read";
            }
            case "cmis:write": {
                return "ReadWrite";
            }
            case "cmis:all": {
                return "Everything";
            }
        }
        return permission;
    }

    protected static String permissionFromNuxeo(String permission) {
        switch (permission) {
            case "Read": {
                return "cmis:read";
            }
            case "ReadWrite": {
                return "cmis:write";
            }
            case "Everything": {
                return "cmis:all";
            }
        }
        return permission;
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        boolean basic = !Boolean.FALSE.equals(onlyBasicPermissions);
        this.getDocumentModel(objectId);
        ACP acp = this.coreSession.getACP((DocumentRef)new IdRef(objectId));
        return NuxeoObjectData.getAcl(acp, basic, this);
    }

    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogTokenHolder, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeAcl, BigInteger maxItems, ExtensionsData extension) {
        String latestChangeLogToken;
        boolean hasMoreItems;
        int max;
        long minId;
        if (changeLogTokenHolder == null) {
            throw new CmisInvalidArgumentException("Missing change log token holder");
        }
        String changeLogToken = (String)changeLogTokenHolder.getValue();
        if (changeLogToken == null) {
            minId = 0L;
        } else {
            try {
                minId = Long.parseLong(changeLogToken);
            }
            catch (NumberFormatException e) {
                throw new CmisInvalidArgumentException("Invalid change log token");
            }
        }
        int n = max = maxItems == null ? -1 : maxItems.intValue();
        if (max <= 0) {
            max = 100;
        }
        if (max > 1000000) {
            max = 1000000;
        }
        List<Object> ods = null;
        for (int scale = 1; scale < 128; scale *= 2) {
            int pageSize = max * scale + 1;
            if (pageSize < 0) {
                pageSize = Integer.MAX_VALUE;
            }
            if ((ods = this.readAuditLog(repositoryId, minId, max, pageSize)) != null || pageSize == Integer.MAX_VALUE) break;
        }
        if (ods == null) {
            ods = Collections.emptyList();
        }
        boolean bl = hasMoreItems = ods.size() > max;
        if (hasMoreItems) {
            ods = ods.subList(0, max);
        }
        if (ods.size() == 0) {
            latestChangeLogToken = null;
        } else {
            ObjectData last = (ObjectData)ods.get(ods.size() - 1);
            latestChangeLogToken = (String)((PropertyData)last.getProperties().getProperties().get(NX_CHANGE_LOG_ID)).getFirstValue();
        }
        ObjectListImpl ol = new ObjectListImpl();
        ol.setHasMoreItems(Boolean.valueOf(hasMoreItems));
        ol.setObjects(ods);
        ol.setNumItems(BigInteger.valueOf(-1L));
        changeLogTokenHolder.setValue((Object)latestChangeLogToken);
        return ol;
    }

    protected SearchRequestBuilder getElasticsearchBuilder() {
        ElasticSearchAdmin esa = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        String indexName = esa.getIndexNameForType("entry");
        return esa.getClient().prepareSearch(new String[]{indexName}).setTypes(new String[]{"entry"}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH);
    }

    protected List<ObjectData> readAuditLog(String repositoryId, long minId, int max, int pageSize) {
        ArrayList<LogEntry> entries;
        AuditReader reader = (AuditReader)Framework.getLocalService(AuditReader.class);
        if (reader == null) {
            throw new CmisRuntimeException("Cannot find audit service");
        }
        if (reader instanceof DefaultAuditBackend) {
            String query = "FROM LogEntry log WHERE log.id >= :minId   AND log.eventId IN (:evCreated, :evModified, :evRemoved)   AND log.repositoryId = :repoId ORDER BY log.id";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("minId", minId);
            params.put("evCreated", "documentCreated");
            params.put("evModified", "documentModified");
            params.put("evRemoved", "documentRemoved");
            params.put("repoId", repositoryId);
            entries = reader.nativeQuery(query, params, 1, pageSize);
        } else if (reader instanceof ESAuditBackend) {
            SearchRequestBuilder builder = this.getElasticsearchBuilder();
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)QueryBuilders.termQuery((String)ES_AUDIT_REPOSITORY_ID, (String)repositoryId)).filter((QueryBuilder)QueryBuilders.termsQuery((String)ES_AUDIT_EVENT_ID, (String[])new String[]{"documentCreated", "documentModified", "documentRemoved"})).filter((QueryBuilder)QueryBuilders.rangeQuery((String)ES_AUDIT_ID).gte(minId));
            builder.setQuery((QueryBuilder)query);
            builder.addSort(ES_AUDIT_ID, SortOrder.ASC);
            entries = new ArrayList<LogEntry>();
            SearchResponse searchResponse = (SearchResponse)builder.setSize(pageSize).execute().actionGet();
            for (SearchHit hit : searchResponse.getHits()) {
                try {
                    entries.add(AuditEntryJSONReader.read((String)hit.getSourceAsString()));
                }
                catch (IOException e) {
                    throw new CmisRuntimeException("Failed to parse audit entry: " + hit, (Throwable)e);
                }
            }
        } else {
            throw new CmisRuntimeException("Unknown audit backend: " + reader.getClass().getName());
        }
        ArrayList<ObjectData> ods = new ArrayList<ObjectData>();
        for (LogEntry entry : entries) {
            ObjectData od = this.getLogEntryObjectData(entry);
            if (od == null) continue;
            ods.add(od);
            if (ods.size() <= max) continue;
            return ods;
        }
        if (entries.size() < pageSize) {
            return ods;
        }
        return null;
    }

    protected ObjectData getLogEntryObjectData(LogEntry logEntry) {
        ChangeType changeType;
        String docType = logEntry.getDocType();
        if (!this.getTypeManager().hasType(docType)) {
            return null;
        }
        String eventId = logEntry.getEventId();
        if ("documentCreated".equals(eventId)) {
            changeType = ChangeType.CREATED;
        } else if ("documentModified".equals(eventId)) {
            changeType = ChangeType.UPDATED;
        } else if ("documentRemoved".equals(eventId)) {
            changeType = ChangeType.DELETED;
        } else {
            return null;
        }
        ChangeEventInfoDataImpl cei = new ChangeEventInfoDataImpl();
        cei.setChangeType(changeType);
        GregorianCalendar changeTime = (GregorianCalendar)Calendar.getInstance();
        Date date = logEntry.getEventDate();
        changeTime.setTime(date);
        cei.setChangeTime(changeTime);
        ObjectDataImpl od = new ObjectDataImpl();
        od.setChangeEventInfo((ChangeEventInfo)cei);
        PropertiesImpl properties = new PropertiesImpl();
        properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectId", logEntry.getDocUUID()));
        properties.addProperty((PropertyData)new PropertyIdImpl("cmis:objectTypeId", docType));
        properties.addProperty((PropertyData)new PropertyStringImpl(NX_CHANGE_LOG_ID, String.valueOf(logEntry.getId())));
        od.setProperties((Properties)properties);
        return od;
    }

    protected String getLatestChangeLogToken(String repositoryId) {
        long id;
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        if (reader == null) {
            log.warn((Object)"Audit Service not found. latest change log token will be '0'");
            return "0";
        }
        if (reader instanceof DefaultAuditBackend) {
            String query = "FROM LogEntry log WHERE log.eventId IN (:evCreated, :evModified, :evRemoved)   AND log.repositoryId = :repoId ORDER BY log.id DESC";
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("evCreated", "documentCreated");
            params.put("evModified", "documentModified");
            params.put("evRemoved", "documentRemoved");
            params.put("repoId", repositoryId);
            List entries = reader.nativeQuery(query, params, 1, 1);
            id = entries.isEmpty() ? 0L : ((LogEntry)entries.get(0)).getId();
        } else if (reader instanceof ESAuditBackend) {
            SearchRequestBuilder builder = this.getElasticsearchBuilder();
            BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchAllQuery()).filter((QueryBuilder)QueryBuilders.termQuery((String)ES_AUDIT_REPOSITORY_ID, (String)repositoryId)).filter((QueryBuilder)QueryBuilders.termsQuery((String)ES_AUDIT_EVENT_ID, (String[])new String[]{"documentCreated", "documentModified", "documentRemoved"}));
            builder.setQuery((QueryBuilder)query);
            builder.addSort(ES_AUDIT_ID, SortOrder.DESC);
            builder.setSize(1);
            SearchResponse searchResponse = (SearchResponse)builder.execute().actionGet();
            SearchHit[] hits = searchResponse.getHits().hits();
            if (hits.length == 0) {
                id = 0L;
            } else {
                String hit = hits[0].getSourceAsString();
                try {
                    id = AuditEntryJSONReader.read((String)hit).getId();
                }
                catch (IOException e) {
                    throw new CmisRuntimeException("Failed to parse audit entry: " + hit, (Throwable)e);
                }
            }
        } else {
            throw new CmisRuntimeException("Unknown audit backend: " + reader.getClass().getName());
        }
        return String.valueOf(id);
    }

    protected String addProxyClause(String query) {
        if (!this.repository.supportsProxies()) {
            query = query + " AND ecm:isProxy = 0";
        }
        return query;
    }

    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        long max;
        long skip;
        long l = skip = skipCount == null ? 0L : skipCount.longValue();
        if (skip < 0L) {
            skip = 0L;
        }
        long l2 = max = maxItems == null ? -1L : maxItems.longValue();
        if (max <= 0L) {
            max = 100L;
        }
        HashMap typeInfo = new HashMap();
        PartialList<Map<String, Serializable>> res = this.queryProjection(statement, max, skip, Boolean.TRUE.equals(searchAllVersions), typeInfo);
        ArrayList<ObjectDataImpl> list = new ArrayList<ObjectDataImpl>(res.list.size());
        for (Map map : res.list) {
            ObjectDataImpl od = this.makeObjectData(map, typeInfo);
            String id = od.getId();
            if (id != null) {
                DocumentModel doc = null;
                if (Boolean.TRUE.equals(includeAllowableActions)) {
                    doc = this.getDocumentModel(id);
                    AllowableActions allowableActions = NuxeoObjectData.getAllowableActions(doc, false);
                    od.setAllowableActions(allowableActions);
                }
                if (includeRelationships != null && includeRelationships != IncludeRelationships.NONE) {
                    List<ObjectData> relationships = NuxeoObjectData.getRelationships(id, includeRelationships, this);
                    od.setRelationships(relationships);
                }
                if (NuxeoObjectData.needsRenditions(renditionFilter)) {
                    if (doc == null) {
                        doc = this.getDocumentModel(id);
                    }
                    List<RenditionData> renditions = NuxeoObjectData.getRenditions(doc, renditionFilter, null, null, this.callContext);
                    od.setRenditions(renditions);
                }
            }
            list.add(od);
        }
        long numItems = res.totalSize;
        ObjectListImpl objList = new ObjectListImpl();
        objList.setObjects(list);
        objList.setNumItems(BigInteger.valueOf(numItems));
        objList.setHasMoreItems(Boolean.valueOf(numItems > skip + (long)list.size()));
        return objList;
    }

    public IterableQueryResult queryAndFetch(String query, boolean searchAllVersions, Map<String, PropertyDefinition<?>> typeInfo) {
        IterableQueryResult it;
        String nxql;
        if (this.repository.supportsJoins()) {
            if (this.repository.supportsProxies()) {
                throw new CmisRuntimeException("Server configuration error: cannot supports joins and proxies at the same time");
            }
            return this.coreSession.queryAndFetch(query, "CMISQL", new Object[]{this, typeInfo, searchAllVersions});
        }
        CMISQLtoNXQL converter = new CMISQLtoNXQL(this.repository.supportsProxies());
        try {
            nxql = converter.getNXQL(query, this, typeInfo, searchAllVersions);
        }
        catch (QueryParseException e) {
            throw new CmisInvalidArgumentException(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.repository.useElasticsearch()) {
                ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
                NxQueryBuilder qb = new NxQueryBuilder(this.coreSession).nxql(nxql).limit(1000).onlyElasticsearchResponse();
                it = new EsIterableQueryResultImpl(ess, ess.scroll(qb, 1000L));
            } else {
                it = this.coreSession.queryAndFetch(nxql, "NXQL", true, new Object[0]);
            }
        }
        catch (QueryParseException e) {
            e.addInfo("Invalid query: CMISQL: " + query);
            throw e;
        }
        return converter.getIterableQueryResult(it, this);
    }

    public IterableQueryResult queryAndFetch(String query, boolean searchAllVersions) {
        return this.queryAndFetch(query, searchAllVersions, null);
    }

    public PartialList<Map<String, Serializable>> queryProjection(String query, long limit, long offset, boolean searchAllVersions, Map<String, PropertyDefinition<?>> typeInfo) {
        PartialList pl;
        String nxql;
        if (this.repository.supportsJoins()) {
            if (this.repository.supportsProxies()) {
                throw new CmisRuntimeException("Server configuration error: cannot supports joins and proxies at the same time");
            }
            return this.coreSession.queryProjection(query, "CMISQL", false, limit, offset, -1L, new Object[]{this, typeInfo, searchAllVersions});
        }
        CMISQLtoNXQL converter = new CMISQLtoNXQL(this.repository.supportsProxies());
        try {
            nxql = converter.getNXQL(query, this, typeInfo, searchAllVersions);
        }
        catch (QueryParseException e) {
            throw new CmisInvalidArgumentException(e.getMessage(), (Throwable)e);
        }
        try {
            if (this.repository.useElasticsearch()) {
                ElasticSearchService ess = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
                NxQueryBuilder qb = new NxQueryBuilder(this.coreSession).nxql(nxql).limit((int)limit).offset((int)offset).onlyElasticsearchResponse();
                SearchResponse esResponse = ess.queryAndAggregate(qb).getElasticsearchResponse();
                SearchHits esHits = esResponse.getHits();
                List list = new EsSearchHitConverter(qb.getSelectFieldsAndTypes()).convert(esHits.getHits());
                pl = new PartialList(list, esHits.getTotalHits());
            } else {
                pl = this.coreSession.queryProjection(nxql, "NXQL", true, limit, offset, -1L, new Object[0]);
            }
        }
        catch (QueryParseException e) {
            e.addInfo("Invalid query: CMISQL: " + query);
            throw e;
        }
        return converter.convertToCMIS((PartialList<Map<String, Serializable>>)pl, this);
    }

    protected ObjectDataImpl makeObjectData(Map<String, Serializable> map, Map<String, PropertyDefinition<?>> typeInfo) {
        ObjectDataImpl od = new ObjectDataImpl();
        PropertiesImpl properties = new PropertiesImpl();
        for (Map.Entry<String, Serializable> en : map.entrySet()) {
            String queryName = en.getKey();
            PropertyDefinition<?> pd = typeInfo.get(queryName);
            if (pd == null) {
                throw new NullPointerException("Cannot get " + queryName);
            }
            AbstractPropertyData p = (AbstractPropertyData)this.objectFactory.createPropertyData(pd, (Object)en.getValue());
            p.setLocalName(pd.getLocalName());
            p.setDisplayName(pd.getDisplayName());
            p.setQueryName(queryName);
            properties.addProperty((PropertyData)p);
        }
        od.setProperties((Properties)properties);
        return od;
    }

    public void addObjectToFolder(String repositoryId, String objectId, String folderId, Boolean allVersions, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public void removeObjectFromFolder(String repositoryId, String objectId, String folderId, ExtensionsData extension) {
        if (folderId != null) {
            DocumentModel folder = this.getDocumentModel(folderId);
            DocumentModel parent = this.coreSession.getParentDocument((DocumentRef)new IdRef(objectId));
            if (!parent.getId().equals(folder.getId())) {
                throw new CmisInvalidArgumentException("Object " + objectId + " is not filed in  " + folderId);
            }
        }
        this.deleteObject(repositoryId, objectId, Boolean.FALSE, extension);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        if (folderId == null) {
            throw new CmisInvalidArgumentException("Null folderId");
        }
        return this.getChildrenInternal(repositoryId, folderId, filter, orderBy, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, maxItems, skipCount, false);
    }

    protected ObjectInFolderList getChildrenInternal(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, boolean folderOnly) {
        long offset;
        long limit;
        ObjectInFolderListImpl result = new ObjectInFolderListImpl();
        ArrayList<ObjectInFolderDataImpl> list = new ArrayList<ObjectInFolderDataImpl>();
        DocumentModel folder = this.getDocumentModel(folderId);
        if (!folder.isFolder()) {
            return null;
        }
        String query = String.format("SELECT * FROM %s WHERE %s = '%s' AND %s <> '%s' AND %s <> '%s'", folderOnly ? "Folder" : "Document", "ecm:parentId", folderId, "ecm:mixinType", "HiddenInNavigation", "ecm:currentLifeCycleState", "deleted");
        query = this.addProxyClause(query);
        if (!StringUtils.isBlank((String)orderBy)) {
            CMISQLtoNXQL converter = new CMISQLtoNXQL(this.repository.supportsProxies());
            query = query + " ORDER BY " + converter.convertOrderBy(orderBy, this.getTypeManager());
        }
        long l = limit = maxItems == null ? 0L : maxItems.longValue();
        if (limit < 0L) {
            limit = 0L;
        }
        long l2 = offset = skipCount == null ? 0L : skipCount.longValue();
        if (offset < 0L) {
            offset = 0L;
        }
        DocumentModelList children = this.coreSession.query(query, null, limit, offset, true);
        for (DocumentModel child : children) {
            NuxeoObjectData data = new NuxeoObjectData((CmisService)this, child, filter, includeAllowableActions, includeRelationships, renditionFilter, Boolean.FALSE, Boolean.FALSE, null);
            ObjectInFolderDataImpl oifd = new ObjectInFolderDataImpl();
            oifd.setObject((ObjectData)data);
            if (Boolean.TRUE.equals(includePathSegment)) {
                oifd.setPathSegment(child.getName());
            }
            list.add(oifd);
            this.collectObjectInfo(repositoryId, data.getId());
        }
        Boolean hasMoreItems = limit == 0L ? Boolean.FALSE : Boolean.valueOf(children.totalSize() > offset + limit);
        result.setObjects(list);
        result.setHasMoreItems(hasMoreItems);
        result.setNumItems(BigInteger.valueOf(children.totalSize()));
        this.collectObjectInfo(repositoryId, folderId);
        return result;
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        int levels;
        if (folderId == null) {
            throw new CmisInvalidArgumentException("Null folderId");
        }
        int n = levels = depth == null ? 2 : depth.intValue();
        if (levels == 0) {
            throw new CmisInvalidArgumentException("Invalid depth: 0");
        }
        return this.getDescendantsInternal(repositoryId, folderId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, 0, levels, false);
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        int levels;
        if (folderId == null) {
            throw new CmisInvalidArgumentException("Null folderId");
        }
        int n = levels = depth == null ? 2 : depth.intValue();
        if (levels == 0) {
            throw new CmisInvalidArgumentException("Invalid depth: 0");
        }
        return this.getDescendantsInternal(repositoryId, folderId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegment, 0, levels, true);
    }

    protected List<ObjectInFolderContainer> getDescendantsInternal(String repositoryId, String folderId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegments, int level, int maxLevels, boolean folderOnly) {
        if (maxLevels != -1 && level >= maxLevels) {
            return null;
        }
        ObjectInFolderList children = this.getChildrenInternal(repositoryId, folderId, filter, null, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments, null, null, folderOnly);
        if (children == null) {
            return Collections.emptyList();
        }
        ArrayList<ObjectInFolderContainer> res = new ArrayList<ObjectInFolderContainer>(children.getObjects().size());
        for (ObjectInFolderData child : children.getObjects()) {
            ObjectInFolderContainerImpl oifc = new ObjectInFolderContainerImpl();
            oifc.setObject(child);
            List<ObjectInFolderContainer> subChildren = this.getDescendantsInternal(repositoryId, child.getObject().getId(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePathSegments, level + 1, maxLevels, folderOnly);
            if (subChildren != null) {
                oifc.setChildren(subChildren);
            }
            res.add((ObjectInFolderContainer)oifc);
        }
        return res;
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        List<ObjectParentData> parents = this.getObjectParentsInternal(repositoryId, folderId, filter, null, null, null, Boolean.TRUE, true);
        return parents.isEmpty() ? null : parents.get(0).getObject();
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        return this.getObjectParentsInternal(repositoryId, objectId, filter, includeAllowableActions, includeRelationships, renditionFilter, includeRelativePathSegment, false);
    }

    protected List<ObjectParentData> getObjectParentsInternal(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, boolean folderOnly) {
        IdRef docRef = new IdRef(objectId);
        if (!this.coreSession.exists((DocumentRef)docRef)) {
            throw new CmisObjectNotFoundException(objectId);
        }
        DocumentModel doc = this.coreSession.getDocument((DocumentRef)docRef);
        if (this.isFilteredOut(doc)) {
            throw new CmisObjectNotFoundException(objectId);
        }
        if (folderOnly && !doc.isFolder()) {
            throw new CmisInvalidArgumentException("Not a folder: " + objectId);
        }
        String pathSegment = doc.getName();
        if (pathSegment == null) {
            return Collections.emptyList();
        }
        DocumentRef parentRef = doc.getParentRef();
        if (parentRef == null) {
            return Collections.emptyList();
        }
        if (!this.coreSession.exists(parentRef)) {
            return Collections.emptyList();
        }
        DocumentModel parent = this.coreSession.getDocument(parentRef);
        if (this.isFilteredOut(parent)) {
            return Collections.emptyList();
        }
        String parentId = parent.getId();
        NuxeoObjectData od = this.getObject(repositoryId, parentId, filter, includeAllowableActions, includeRelationships, renditionFilter, Boolean.FALSE, Boolean.FALSE, null);
        ObjectParentDataImpl opd = new ObjectParentDataImpl((ObjectData)od);
        if (!Boolean.FALSE.equals(includeRelativePathSegment)) {
            opd.setRelativePathSegment(pathSegment);
        }
        return Collections.singletonList(opd);
    }

    public void applyPolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public List<ObjectData> getAppliedPolicies(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        return Collections.emptyList();
    }

    public void removePolicy(String repositoryId, String policyId, String objectId, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    public ObjectList getObjectRelationships(String repositoryId, String objectId, Boolean includeSubRelationshipTypes, RelationshipDirection relationshipDirection, String typeId, String filter, Boolean includeAllowableActions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        IncludeRelationships includeRelationships = relationshipDirection == null || relationshipDirection == RelationshipDirection.SOURCE ? IncludeRelationships.SOURCE : (relationshipDirection == RelationshipDirection.TARGET ? IncludeRelationships.TARGET : IncludeRelationships.BOTH);
        List<ObjectData> rels = NuxeoObjectData.getRelationships(objectId, includeRelationships, this);
        ListUtils.BatchedList<ObjectData> batch = ListUtils.getBatchedList(rels, maxItems, skipCount, 100);
        ObjectListImpl res = new ObjectListImpl();
        res.setObjects(batch.getList());
        res.setNumItems(batch.getNumItems());
        res.setHasMoreItems(batch.getHasMoreItems());
        for (ObjectData data : res.getObjects()) {
            this.collectObjectInfo(repositoryId, data.getId());
        }
        return res;
    }

    public void checkIn(String repositoryId, Holder<String> objectIdHolder, Boolean major, Properties properties, ContentStream contentStream, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension) {
        DocumentRef ver;
        boolean setContentStream;
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        VersioningOption option = Boolean.TRUE.equals(major) ? VersioningOption.MAJOR : VersioningOption.MINOR;
        DocumentModel doc = this.getDocumentModel(objectId);
        NuxeoObjectData object = new NuxeoObjectData((CmisService)this, doc);
        this.updateProperties(object, properties, false);
        boolean bl = setContentStream = contentStream != null;
        if (setContentStream) {
            try {
                NuxeoPropertyData.setContentStream(doc, contentStream, true);
            }
            catch (IOException e) {
                throw new CmisRuntimeException(e.toString(), (Throwable)e);
            }
        }
        doc.putContextData("comment", (Serializable)((Object)checkinComment));
        doc = this.coreSession.saveDocument(doc);
        if (setContentStream) {
            NuxeoPropertyData.validateBlobDigest(doc, this.callContext);
        }
        try {
            ver = doc.checkIn(option, checkinComment);
        }
        catch (SQLDocumentVersion.VersionNotModifiableException e) {
            throw new CmisInvalidArgumentException("Cannot check in non-PWC: " + doc);
        }
        doc.removeLock();
        this.save();
        objectIdHolder.setValue((Object)this.getIdFromDocumentRef(ver));
    }

    public void checkOut(String repositoryId, Holder<String> objectIdHolder, ExtensionsData extension, Holder<Boolean> contentCopiedHolder) {
        String objectId;
        if (objectIdHolder == null || (objectId = (String)objectIdHolder.getValue()) == null) {
            throw new CmisInvalidArgumentException("Missing object ID");
        }
        String pwcId = this.checkOut(objectId);
        objectIdHolder.setValue((Object)pwcId);
        if (contentCopiedHolder != null) {
            contentCopiedHolder.setValue((Object)Boolean.TRUE);
        }
    }

    public String checkOut(String objectId) {
        DocumentModel doc = this.getDocumentModel(objectId);
        try {
            DocumentModel pwc;
            if (doc.isVersion()) {
                pwc = this.coreSession.getWorkingCopy(doc.getRef());
                if (pwc == null) {
                    throw new CmisObjectNotFoundException(objectId);
                }
            } else {
                pwc = doc;
            }
            if (pwc.isCheckedOut()) {
                throw new CmisConstraintException("Already checked out: " + objectId);
            }
            if (pwc.isLocked()) {
                throw new CmisConstraintException("Cannot check out since currently locked: " + objectId);
            }
            pwc.setLock();
            pwc.checkOut();
            this.save();
            return pwc.getId();
        }
        catch (SQLDocumentVersion.VersionNotModifiableException e) {
            throw new CmisInvalidArgumentException("Cannot check out non-version: " + objectId);
        }
        catch (NuxeoException e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("Document already locked")) {
                throw new CmisConstraintException("Cannot check out since currently locked: " + objectId);
            }
            throw new CmisRuntimeException(e.toString(), (Throwable)e);
        }
    }

    public void cancelCheckOut(String repositoryId, String objectId, ExtensionsData extension) {
        this.cancelCheckOut(objectId);
    }

    public void cancelCheckOut(String objectId) {
        DocumentModel doc = this.getDocumentModel(objectId);
        if (!doc.isCheckedOut()) {
            throw new CmisInvalidArgumentException("Cannot cancel check out of non-PWC: " + doc);
        }
        DocumentRef docRef = doc.getRef();
        DocumentRef verRef = this.coreSession.getLastDocumentVersionRef(docRef);
        if (verRef == null) {
            if (this.errorOnCancelCheckOutOfDraftVersion && "0.0".equals(doc.getVersionLabel())) {
                throw new CmisVersioningException("Cannot cancelCheckOut of draft version due to configuration");
            }
            this.coreSession.removeDocument(docRef);
        } else {
            this.coreSession.restoreToVersion(docRef, verRef, true, true);
            doc.removeLock();
        }
        this.save();
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        List<String> props = StringUtils.isBlank((String)filter) ? Arrays.asList("cmis:objectId", "cmis:objectTypeId", "cmis:baseTypeId") : NuxeoObjectData.getPropertyIdsFromFilter(filter);
        ArrayList<String> clauses = new ArrayList<String>(3);
        clauses.add("nuxeo:isVersion = false");
        clauses.add("nuxeo:isCheckedIn = false");
        if (folderId != null) {
            String qid = "'" + folderId.replace("'", "''") + "'";
            clauses.add("IN_FOLDER(" + qid + ")");
        }
        String order = StringUtils.isBlank((String)orderBy) ? "" : " ORDER BY " + orderBy;
        String statement = "SELECT " + StringUtils.join(props, (String)", ") + " FROM " + BaseTypeId.CMIS_DOCUMENT.value() + " WHERE " + StringUtils.join(clauses, (String)" AND ") + order;
        Boolean searchAllVersions = Boolean.TRUE;
        return this.query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, extension);
    }

    public List<ObjectData> getAllVersions(String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension) {
        DocumentModel pwc;
        DocumentModel doc;
        if (objectId != null) {
            doc = this.getDocumentModel(objectId);
        } else if (versionSeriesId != null) {
            doc = this.getDocumentModel(versionSeriesId);
        } else {
            throw new CmisInvalidArgumentException("Missing object ID or version series ID");
        }
        List versions = this.coreSession.getVersionsRefs(doc.getRef());
        ArrayList<ObjectData> list = new ArrayList<ObjectData>(versions.size());
        for (DocumentRef verRef : versions) {
            if (!this.coreSession.hasPermission(verRef, "Read")) continue;
            String verId = this.getIdFromDocumentRef(verRef);
            NuxeoObjectData od = this.getObject(repositoryId, verId, filter, includeAllowableActions, IncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
            list.add(od);
        }
        DocumentModel documentModel = pwc = doc.isVersion() ? this.coreSession.getWorkingCopy(doc.getRef()) : doc;
        if (pwc != null && pwc.isCheckedOut()) {
            NuxeoObjectData od = new NuxeoObjectData((CmisService)this, pwc, filter, includeAllowableActions, IncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, extension);
            list.add(od);
        }
        Collections.reverse(list);
        return list;
    }

    public NuxeoObjectData getObjectOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension) {
        DocumentModel doc;
        if (objectId != null) {
            doc = this.getDocumentModel(objectId);
        } else if (versionSeriesId != null) {
            doc = this.getDocumentModel(versionSeriesId);
        } else {
            throw new CmisInvalidArgumentException("Missing object ID or version series ID");
        }
        if (Boolean.TRUE.equals(major)) {
            List versions = this.coreSession.getVersions(doc.getRef());
            Collections.reverse(versions);
            for (DocumentModel ver : versions) {
                if (!ver.isMajorVersion()) continue;
                return this.getObject(repositoryId, ver.getId(), filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
            }
            return null;
        }
        DocumentRef verRef = this.coreSession.getLastDocumentVersionRef(doc.getRef());
        String verId = this.getIdFromDocumentRef(verRef);
        return this.getObject(repositoryId, verId, filter, includeAllowableActions, includeRelationships, renditionFilter, includePolicyIds, includeAcl, null);
    }

    public Properties getPropertiesOfLatestVersion(String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        NuxeoObjectData od = this.getObjectOfLatestVersion(repositoryId, objectId, versionSeriesId, major, filter, Boolean.FALSE, IncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
        return od == null ? null : od.getProperties();
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        DocumentModelList docs;
        DocumentModel doc = this.getDocumentModel(objectId);
        if (doc.isFolder() && (docs = this.coreSession.getChildren((DocumentRef)new IdRef(objectId), null, this.documentFilter, null)).size() > 0) {
            throw new CmisConstraintException("Cannot delete non-empty folder: " + objectId);
        }
        this.coreSession.removeDocument(doc.getRef());
        this.save();
    }

    public void deleteObjectOrCancelCheckOut(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        DocumentModel doc = this.getDocumentModel(objectId);
        DocumentRef docRef = doc.getRef();
        DocumentRef verRef = this.coreSession.getLastDocumentVersionRef(docRef);
        if (verRef != null && doc.isLocked() && doc.isCheckedOut()) {
            this.cancelCheckOut(repositoryId, objectId, extension);
        } else {
            this.deleteObject(repositoryId, objectId, allVersions, extension);
        }
    }
}

