/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.config;

import java.io.File;
import java.io.Serializable;
import org.nuxeo.common.Environment;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.api.Framework;

@XObject(value="elasticSearchLocal")
public class ElasticSearchLocalConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@enabled")
    protected boolean isEnabled = true;
    @XNode(value="@clusterName")
    protected String clusterName;
    @XNode(value="@nodeName")
    protected String nodeName = "Nuxeo";
    @XNode(value="@pathHome")
    private String homePath;
    @XNode(value="@pathData")
    protected String dataPath;
    @XNode(value="@indexStoreType")
    protected String indexStoreType;
    @XNode(value="@httpEnabled")
    protected boolean httpEnabled = false;
    @XNode(value="@httpPort")
    protected String httpPort = "9200";
    @XNode(value="@networkHost")
    protected String networkHost = "127.0.0.1";
    @XNode(value="@useExternalVersion")
    protected boolean externalVersion = true;

    public String getClusterName() {
        return this.clusterName;
    }

    public String getHomePath() {
        if (this.homePath == null) {
            File dir = new File(Environment.getDefault().getTemp(), "elasticsearch");
            this.homePath = dir.getPath();
        }
        return this.homePath;
    }

    public String getDataPath() {
        if (this.dataPath == null) {
            File dir = new File(Framework.getRuntime().getHome(), "data/elasticsearch");
            this.dataPath = dir.getPath();
        }
        return this.dataPath;
    }

    public String getIndexStorageType() {
        if (this.indexStoreType == null) {
            this.indexStoreType = "mmapfs";
        }
        return this.indexStoreType;
    }

    public String getNetworkHost() {
        return this.networkHost;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean httpEnabled() {
        return this.httpEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setDataPath(String dataPath) {
        this.dataPath = dataPath;
    }

    public void setHomePath(String homePath) {
        this.homePath = homePath;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
    }

    public void setIndexStorageType(String indexStorageType) {
        this.indexStoreType = indexStorageType;
    }

    public void setNetworkHost(String networkHost) {
        this.networkHost = networkHost;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public boolean useExternalVersion() {
        return this.externalVersion;
    }

    public String toString() {
        if (this.isEnabled()) {
            return String.format("EsLocalConfig(%s, %s, %s, %s)", this.getClusterName(), this.getDataPath(), this.httpEnabled(), this.getIndexStorageType());
        }
        return "EsLocalConfig disabled";
    }

    public String getHttpPort() {
        return this.httpPort;
    }
}

