/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.Settings;
import org.nuxeo.elasticsearch.api.ESClientInitializationService;
import org.nuxeo.elasticsearch.config.ElasticSearchRemoteConfig;

public class ESClientInitializationServiceImpl
implements ESClientInitializationService {
    protected String username;
    protected String password;
    protected String sslKeystorePath;
    protected String sslKeystorePassword;

    @Override
    public Settings initializeSettings(ElasticSearchRemoteConfig config) {
        return this.initializeSettingsBuilder(config).build();
    }

    @Override
    public TransportClient initializeClient(Settings settings) {
        return this.initializeClientBuilder().settings(settings).build();
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getSslKeystorePath() {
        return this.sslKeystorePath;
    }

    @Override
    public void setSslKeystorePath(String sslKeystorePath) {
        this.sslKeystorePath = sslKeystorePath;
    }

    @Override
    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    @Override
    public void setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
    }

    protected Settings.Builder initializeSettingsBuilder(ElasticSearchRemoteConfig config) {
        Settings.Builder builder = Settings.settingsBuilder().put("cluster.name", config.getClusterName()).put("client.transport.nodes_sampler_interval", config.getSamplerInterval()).put("client.transport.ping_timeout", config.getPingTimeout()).put("client.transport.ignore_cluster_name", config.isIgnoreClusterName()).put("client.transport.sniff", config.isClusterSniff());
        return builder;
    }

    protected TransportClient.Builder initializeClientBuilder() {
        return TransportClient.builder();
    }
}

